package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.ContentCategorySchema
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class ContentCategorySchemaDao : BaseDao<ContentCategorySchema> {
  @Query(`value` = "SELECT ContentCategorySchema.* FROM ContentCategorySchema")
  public actual abstract fun publicContentCategorySchemas(): List<ContentCategorySchema>

  @Query(`value` = "SELECT * FROM ContentCategorySchema WHERE schemaUrl = :schemaUrl")
  public actual abstract fun findBySchemaUrl(schemaUrl: String): ContentCategorySchema?
}
