package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.composites.ContentEntryImportJobProgress
import com.ustadmobile.lib.db.entities.ContentEntryImportJob
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

@Dao
public actual abstract class ContentEntryImportJobDao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertJobItem(jobItem: ContentEntryImportJob): Long

  @Query(`value` =
      "\n        UPDATE ContentEntryImportJob \n           SET cjiStatus = :status\n         WHERE cjiUid= :cjiUid  \n    ")
  public actual abstract suspend fun updateItemStatus(cjiUid: Long, status: Int)

  @Query(`value` =
      "\n        UPDATE ContentEntryImportJob \n           SET cjiStatus = :status,\n               cjiError = :error\n         WHERE cjiUid= :cjiUid  \n    ")
  public actual abstract suspend fun updateItemStatusAndError(
    cjiUid: Long,
    status: Int,
    error: String?,
  )

  @Query(`value` =
      "\n        UPDATE ContentEntryImportJob\n           SET cjiErrorDismissed = :dismissed\n         WHERE cjiUid = :cjiUid  \n    ")
  public actual abstract suspend fun updateErrorDismissed(cjiUid: Long, dismissed: Boolean)

  @Query(`value` =
      "\n        UPDATE ContentEntryImportJob\n           SET cjiItemProgress = :cjiProgress,\n               cjiItemTotal = :cjiTotal\n         WHERE cjiUid = :cjiUid     \n    ")
  public actual abstract suspend fun updateItemProgress(
    cjiUid: Long,
    cjiProgress: Long,
    cjiTotal: Long,
  )

  @Query(`value` =
      "\n        SELECT ContentEntryImportJob.*\n          FROM ContentEntryImportJob\n         WHERE cjiUid = :cjiUid \n    ")
  public actual abstract suspend fun findByUidAsync(cjiUid: Long): ContentEntryImportJob?

  @Query(`value` =
      "\n        SELECT COALESCE(\n               (SELECT ContentEntryImportJob.cjiOwnerPersonUid\n                  FROM ContentEntryImportJob\n                 WHERE ContentEntryImportJob.cjiUid = :cjiUid), 0)\n    ")
  public actual abstract suspend fun findOwnerByUidAsync(cjiUid: Long): Long

  @Query(`value` =
      "\n        SELECT ContentEntryImportJob.cjiUid,\n               ContentEntryImportJob.cjiItemProgress,\n               ContentEntryImportJob.cjiItemTotal,\n               ContentEntryImportJob.cjiStatus,\n               ContentEntryImportJob.cjiError,\n               ContentEntryImportJob.cjiOwnerPersonUid\n          FROM ContentEntryImportJob\n         WHERE ContentEntryImportJob.cjiContentEntryUid = :contentEntryUid\n           AND (   ContentEntryImportJob.cjiStatus BETWEEN 4 AND 20\n                OR (ContentEntryImportJob.cjiStatus = 25 AND NOT ContentEntryImportJob.cjiErrorDismissed))\n    ")
  public actual abstract fun findInProgressJobsByContentEntryUid(contentEntryUid: Long):
      Flow<List<ContentEntryImportJobProgress>>

  @Query(`value` =
      "\n        SELECT ContentEntryImportJob.cjiUid,\n               ContentEntryImportJob.cjiItemProgress,\n               ContentEntryImportJob.cjiItemTotal,\n               ContentEntryImportJob.cjiStatus,\n               ContentEntryImportJob.cjiError,\n               ContentEntryImportJob.cjiOwnerPersonUid\n          FROM ContentEntryImportJob\n         WHERE ContentEntryImportJob.cjiContentEntryUid = :contentEntryUid\n           AND (   ContentEntryImportJob.cjiStatus BETWEEN 4 AND 20\n                OR (ContentEntryImportJob.cjiStatus = 25 AND NOT ContentEntryImportJob.cjiErrorDismissed))\n    ")
  public actual abstract suspend
      fun findInProgressJobsByContentEntryUidAsync(contentEntryUid: Long):
      List<ContentEntryImportJobProgress>
}
