package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.ContentEntryPicture
import kotlin.Any
import kotlin.Long
import kotlinx.coroutines.flow.Flow

@Dao
public actual abstract class ContentEntryPictureDao : BaseDao<ContentEntryPicture> {
  @Query(`value` =
      "\n        SELECT * \n          FROM ContentEntryPicture \n         WHERE cepContentEntryUid = :entryUid\n           AND cepActive\n      ORDER BY cepTimestamp DESC \n         LIMIT 1\n         ")
  public actual abstract suspend fun findByContentEntryUidAsync(entryUid: Long):
      ContentEntryPicture?

  @Query(`value` =
      "\n         SELECT * \n          FROM ContentEntryPicture \n         WHERE cepContentEntryUid = :entryUid\n           AND cepActive\n      ORDER BY cepTimestamp DESC \n         LIMIT 1\n         ")
  public actual abstract fun findByContentEntryUidLive(entryUid: Long): Flow<ContentEntryPicture?>

  @Update(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun updateAsync(ContentEntryPicture: ContentEntryPicture)
}
