package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.replication.withRepoChangeMonitorAsync
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.CourseBlockPicture
import io.ktor.client.HttpClient
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class CourseBlockPictureDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: CourseBlockPictureDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : CourseBlockPictureDao() {
  override suspend fun upsertListAsync(entities: List<CourseBlockPicture>) {
    _repo.withRepoChangeMonitorAsync("CourseBlockPicture") {
      _dao.upsertListAsync(entities)
    }
  }

  override suspend fun updateUri(
    uid: Long,
    uri: String?,
    thumbnailUri: String?,
    time: Long,
  ) {
    _repo.withRepoChangeMonitorAsync("CourseBlockPicture") {
      _dao.updateUri(uid, uri, thumbnailUri, time)
    }
  }
}
