package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.CourseGroupSet
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

@Dao
public actual abstract class CourseGroupSetDao : BaseDao<CourseGroupSet> {
  @Update(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun updateAsync(entity: CourseGroupSet): Int

  @Query(`value` =
      "\n        SELECT *\n         FROM CourseGroupSet\n        WHERE cgsActive\n          AND cgsClazzUid = :clazzUid\n          AND ((:searchText = '%') OR (cgsName LIKE :searchText))\n     ORDER BY CASE(:sortOrder)\n              WHEN 1 THEN cgsName\n              ELSE ''\n              END ASC,\n              CASE(:sortOrder)\n              WHEN 2 THEN cgsName\n              ELSE ''\n              END DESC\n    ")
  public actual abstract fun findAllCourseGroupSetForClazz(
    clazzUid: Long,
    searchText: String,
    sortOrder: Int,
  ): PagingSource<Int, CourseGroupSet>

  @Query(`value` =
      "\n        SELECT *\n         FROM CourseGroupSet\n        WHERE cgsActive\n          AND cgsClazzUid = :clazzUid\n     ORDER BY cgsName   \n    ")
  public actual abstract fun findAllCourseGroupSetForClazzList(clazzUid: Long): List<CourseGroupSet>

  @Query(`value` =
      "\n        SELECT *\n         FROM CourseGroupSet\n        WHERE cgsActive\n          AND cgsClazzUid = :clazzUid\n     ORDER BY cgsName   \n    ")
  public actual abstract suspend fun findAllCourseGroupSetForClazzListAsync(clazzUid: Long):
      List<CourseGroupSet>

  @Query(`value` =
      "\n        SELECT * \n         FROM CourseGroupSet \n        WHERE cgsUid = :uid\n        ")
  public actual abstract suspend fun findByUidAsync(uid: Long): CourseGroupSet?

  @Query(`value` =
      "\n        SELECT * \n         FROM CourseGroupSet \n        WHERE cgsUid = :uid\n        ")
  public actual abstract fun findByUidAsFlow(uid: Long): Flow<CourseGroupSet?>

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertAsync(entity: CourseGroupSet)
}
