package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapper
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.ext.requirePagingSourceLoadParams
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.log.DoorLogLevel
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.paging.loadPageDataForHttp
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.ClazzAssignment
import com.ustadmobile.lib.db.entities.ClazzEnrolment
import com.ustadmobile.lib.db.entities.CourseGroupMember
import com.ustadmobile.lib.db.entities.CoursePermission
import com.ustadmobile.lib.db.entities.PeerReviewerAllocation
import com.ustadmobile.lib.db.entities.Person
import com.ustadmobile.lib.db.entities.PersonPicture
import com.ustadmobile.lib.db.entities.SystemPermission
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.nullable
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.findByClazzUidAsPagingSource_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_includeDeleted : Boolean = request.queryParam("includeDeleted")?.let {
    json.decodeFromString(Boolean.serializer(), it)
  } ?: false
  val _pagingLoadParams = request.requirePagingSourceLoadParams(
    json = json,
    keyDeserializationStrategy = Int.serializer().nullable,
  )

  val _result_findByClazzUidAsPagingSource_pagingSource = findByClazzUidAsPagingSource(
    clazzUid = _arg_clazzUid,
    includeDeleted = true,
  ).loadPageDataForHttp(_pagingLoadParams)
  val _result_findByClazzUidAsPagingSource = _result_findByClazzUidAsPagingSource_pagingSource.data
  serverConfig.logger.log(DoorLogLevel.VERBOSE,
      "DoorPaging: loaded from: ${_pagingLoadParams.key} endOfPaginationReached=${_result_findByClazzUidAsPagingSource_pagingSource.endOfPaginationReached}")
  val _endOfPaginationReached =
      _result_findByClazzUidAsPagingSource_pagingSource.endOfPaginationReached

  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_findByClazzUidAsPagingSource.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByClazzUidAsPagingSource.mapNotNull {
        _row ->
        _row.person?.let {
          DoorReplicationEntity(tableId = 9,
            orUid = 0,
            entity = json.encodeToJsonElement(Person.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findByClazzUidAsPagingSource.mapNotNull {
        _row ->
        _row.personPicture?.let {
          DoorReplicationEntity(tableId = 50,
            orUid = 0,
            entity = json.encodeToJsonElement(PersonPicture.serializer(), it).jsonObject,
          )
        }

      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
      add(Pair(DoorConstants.HEADER_PAGING_END_REACHED, _endOfPaginationReached.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.findByUidAndClazzUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_uid : Long = request.queryParam("uid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAndClazzUid = findByUidAndClazzUid(
    uid = _arg_uid,
    clazzUid = _arg_clazzUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAndClazzUid?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 10_012,
          orUid = 0,
          entity = json.encodeToJsonElement(CoursePermission.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.findByUidAndClazzUidAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_uid : Long = request.queryParam("uid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAndClazzUidAsFlow = findByUidAndClazzUidAsFlow(
    uid = _arg_uid,
    clazzUid = _arg_clazzUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAndClazzUidAsFlow?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 10_012,
          orUid = 0,
          entity = json.encodeToJsonElement(CoursePermission.serializer(), _row).jsonObject,
        )
      )
    }
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.userHasEnrolmentEditPermission_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzEnrolmentUid : Long = request.queryParam("clazzEnrolmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_personHasPermissionWithClazzByEnrolmentUidEntities2 =
      personHasPermissionWithClazzByEnrolmentUidEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzEnrolmentUid = _arg_clazzEnrolmentUid,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_personHasPermissionWithClazzByEnrolmentUidEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzByEnrolmentUidEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.personHasPermissionWithClazzAsFlow2_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_permission : Long = request.queryParam("permission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_personHasPermissionWithClazzEntities2 = personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.personHasPermissionWithClazzPairAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_firstPermission : Long = request.queryParam("firstPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_secondPermission : Long = request.queryParam("secondPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_personHasPermissionWithClazzEntities2 = personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.personHasPermissionWithClazzPairAsync_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_firstPermission : Long = request.queryParam("firstPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_secondPermission : Long = request.queryParam("secondPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_personHasPermissionWithClazzEntities2 = personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.personHasPermissionWithClazzTripleAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_firstPermission : Long = request.queryParam("firstPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_secondPermission : Long = request.queryParam("secondPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_thirdPermission : Long = request.queryParam("thirdPermission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_personHasPermissionWithClazzEntities2 = personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.personHasPermissionWithClazzAsync2_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_permission : Long = request.queryParam("permission")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_personHasPermissionWithClazzEntities2 = personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findAllByPersonUid =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    includeDeleted = true,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUid.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CoursePermissionDao.userPermissionsForAssignmentSubmitterUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_clazzUid : Long = request.queryParam("clazzUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_submitterUid : Long = request.queryParam("submitterUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_findByUidAndClazzUidAsync =
      request.db.doorWrapper.getDaoByClass(ClazzAssignmentDao::class).findByUidAndClazzUidAsync(
    assignmentUid = _arg_assignmentUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findByAccountPersonUidAndClazzUid =
      request.db.doorWrapper.getDaoByClass(ClazzEnrolmentDao::class).findByAccountPersonUidAndClazzUid(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_personHasPermissionWithClazzEntities2 = personHasPermissionWithClazzEntities2(
    accountPersonUid = _arg_accountPersonUid,
    clazzUid = _arg_clazzUid,
  )
  val _result_findAllByPersonUidEntities =
      request.db.doorWrapper.getDaoByClass(SystemPermissionDao::class).findAllByPersonUidEntities(
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findCourseGroupMembersByPersonUidAndAssignmentUid =
      request.db.doorWrapper.getDaoByClass(ClazzAssignmentDao::class).findCourseGroupMembersByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val _result_findPeerReviewerAllocationsByPersonUidAndAssignmentUid =
      request.db.doorWrapper.getDaoByClass(ClazzAssignmentDao::class).findPeerReviewerAllocationsByPersonUidAndAssignmentUid(
    assignmentUid = _arg_assignmentUid,
    accountPersonUid = _arg_accountPersonUid,
  )
  val replicationEntities = buildList<DoorReplicationEntity> {
    _result_findByUidAndClazzUidAsync?.also {
      _row -> 
      add(
        DoorReplicationEntity(tableId = 520,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzAssignment.serializer(), _row).jsonObject,
        )
      )
    }
    addAll(
      _result_findByAccountPersonUidAndClazzUid.map {
        _row ->
        DoorReplicationEntity(tableId = 65,
          orUid = 0,
          entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.coursePermission?.let {
          DoorReplicationEntity(tableId = 10_012,
            orUid = 0,
            entity = json.encodeToJsonElement(CoursePermission.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_personHasPermissionWithClazzEntities2.mapNotNull {
        _row ->
        _row.clazzEnrolment?.let {
          DoorReplicationEntity(tableId = 65,
            orUid = 0,
            entity = json.encodeToJsonElement(ClazzEnrolment.serializer(), it).jsonObject,
          )
        }

      }
    )
    addAll(
      _result_findAllByPersonUidEntities.map {
        _row ->
        DoorReplicationEntity(tableId = 10_011,
          orUid = 0,
          entity = json.encodeToJsonElement(SystemPermission.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findCourseGroupMembersByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 243,
          orUid = 0,
          entity = json.encodeToJsonElement(CourseGroupMember.serializer(), _row).jsonObject,
        )
      }
    )
    addAll(
      _result_findPeerReviewerAllocationsByPersonUidAndAssignmentUid.map {
        _row ->
        DoorReplicationEntity(tableId = 140,
          orUid = 0,
          entity = json.encodeToJsonElement(PeerReviewerAllocation.serializer(), _row).jsonObject,
        )
      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
