package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.DeletedItem
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class DeletedItemDao {
  @Query(`value` =
      "\n        INSERT INTO DeletedItem(delItemName, delItemIconUri, delItemLastModTime, delItemTimeDeleted, delItemEntityTable, delItemEntityUid, delItemDeletedByPersonUid, delItemStatus, delItemIsFolder)\n        SELECT (SELECT ContentEntry.title\n                  FROM ContentEntry\n                 WHERE ContentEntry.contentEntryUid = \n                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n                          FROM ContentEntryParentChildJoin\n                         WHERE ContentEntryParentChildJoin.cepcjUid = :cepcjUid)) AS delItemName,\n               NULL as delItemIconUri,\n               :time AS delItemLastModTime,\n               :time AS delItemTimeDeleted,\n               7 AS delItemEntityTable,\n               :cepcjUid AS delItemEntityUid,\n               :deletedByPersonUid AS delItemDeletedByPersonUid,\n               1 AS delItemStatus,\n               (SELECT NOT ContentEntry.leaf\n                  FROM ContentEntry\n                 WHERE ContentEntry.contentEntryUid = \n                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n                          FROM ContentEntryParentChildJoin\n                         WHERE ContentEntryParentChildJoin.cepcjUid = :cepcjUid)) AS delItemIsFolder\n    ")
  public actual abstract suspend fun insertDeletedItemForContentEntryParentChildJoin(
    cepcjUid: Long,
    time: Long,
    deletedByPersonUid: Long,
  )

  @Query(`value` =
      "\n        SELECT DeletedItem.*\n          FROM DeletedItem\n         WHERE DeletedItem.delItemEntityTable = :tableId\n           AND DeletedItem.delItemEntityUid = :entityUid\n    ")
  public actual abstract suspend fun findByTableIdAndEntityUid(tableId: Int, entityUid: Long):
      List<DeletedItem>

  @Query(`value` =
      "\n        SELECT DeletedItem.*\n          FROM DeletedItem\n         WHERE (  (CAST(:includeActionedItems AS INTEGER) = 1)\n                OR DeletedItem.delItemStatus = 1)\n           AND DeletedItem.delItemDeletedByPersonUid = :personUid       \n      ORDER BY DeletedItem.delItemTimeDeleted DESC            \n    ")
  public actual abstract fun findDeletedItemsForUser(personUid: Long,
      includeActionedItems: Boolean): PagingSource<Int, DeletedItem>

  @Query(`value` =
      "\n        UPDATE DeletedItem\n           SET delItemStatus = :newStatus,\n               delItemLastModTime = :updateTime\n         WHERE delItemUid IN (:uidList)\n    ")
  public actual abstract suspend fun updateStatusByUids(
    uidList: List<Long>,
    newStatus: Int,
    updateTime: Long,
  )
}
