package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.Language
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public class LanguageDao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: LanguageDao,
) : LanguageDao() {
  override suspend fun insertListAsync(languageList: List<Language>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    languageList.iterator().forEach  {
      if(it.langUid == 0L) {
        val _newPk = _pkManager.nextIdAsync(13)
        it.langUid = _newPk
        _generatedPks += _newPk
      }
      it.langLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertListAsync(languageList)
  }

  override fun findLanguagesAsSource(sortOrder: Int, searchText: String):
      PagingSource<Int, Language> = _dao.findLanguagesAsSource(sortOrder, searchText)

  override fun findLanguagesList(): List<Language> = _dao.findLanguagesList()

  override fun findByName(name: String): Language? = _dao.findByName(name)

  override fun findByTwoCode(langCode: String): Language? = _dao.findByTwoCode(langCode)

  override suspend fun findByTwoCodeAsync(langCode: String): Language? =
      _dao.findByTwoCodeAsync(langCode)

  override fun findByThreeCode(langCode: String): Language? = _dao.findByThreeCode(langCode)

  override fun totalLanguageCount(): Int = _dao.totalLanguageCount()

  override fun update(entity: Language) {
    entity.langLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }

  override fun findByUid(primaryLanguageUid: Long): Language? = _dao.findByUid(primaryLanguageUid)

  override suspend fun findByUidAsync(primaryLanguageUid: Long): Language? =
      _dao.findByUidAsync(primaryLanguageUid)

  override suspend fun updateAsync(entity: Language): Int {
    entity.langLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    return _dao.updateAsync(entity)
  }

  override fun findAllLanguageLive(): Flow<List<Language>> = _dao.findAllLanguageLive()

  override fun findByUidList(uidList: List<Long>): List<Long> = _dao.findByUidList(uidList)

  override suspend fun toggleVisibilityLanguage(
    toggleVisibility: Boolean,
    selectedItem: List<Long>,
    updateTime: Long,
  ) {
    _dao.toggleVisibilityLanguage(toggleVisibility, selectedItem, updateTime)
  }

  override fun replaceList(entityList: List<Language>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.langUid == 0L) {
        val _newPk = _pkManager.nextId(13)
        it.langUid = _newPk
        _generatedPks += _newPk
      }
      it.langLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.replaceList(entityList)
  }

  public override fun insert(entity: Language): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.langUid == 0L) {
      val _newPk = _pkManager.nextId(13)
      entity.langUid = _newPk
    }
    entity.langLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.langUid
  }

  public override suspend fun insertAsync(entity: Language): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.langUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(13)
      entity.langUid = _newPk
    }
    entity.langLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.langUid
  }

  public override fun insertList(entityList: List<Language>) {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.langUid == 0L) {
        val _newPk = _pkManager.nextId(13)
        it.langUid = _newPk
        _generatedPks += _newPk
      }
      it.langLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }
}
