package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import com.ustadmobile.lib.db.entities.ScopedGrant
import kotlin.Any
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class ScopedGrantDao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertAsync(scopedGrant: ScopedGrant): Long

  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertListAsync(scopedGrantList: List<ScopedGrant>)
}
