package com.ustadmobile.core.db.dao.xapi

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.xapi.ActivityInteractionEntity
import kotlin.Any
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class ActivityInteractionDao {
  @Insert(
    onConflict = 5,
    entity = Any::class,
  )
  public actual abstract suspend fun insertOrIgnoreAsync(entities: List<ActivityInteractionEntity>)

  @Query(`value` =
      "\n        SELECT DISTINCT ActivityInteractionEntity.aieActivityUid\n          FROM ActivityInteractionEntity\n         WHERE ActivityInteractionEntity.aieActivityUid IN (:activityUids)\n    ")
  public actual abstract suspend
      fun findActivityUidsWithInteractionEntitiesAsync(activityUids: List<Long>): List<Long>

  @Query(`value` =
      "\n        SELECT ActivityInteractionEntity.*\n          FROM ActivityInteractionEntity\n         WHERE ActivityInteractionEntity.aieActivityUid = :activityUid \n    ")
  public actual abstract suspend fun findAllByActivityUidAsync(activityUid: Long):
      List<ActivityInteractionEntity>
}
