package com.ustadmobile.core.db.dao.xapi

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.xapi.GroupMemberActorJoin
import kotlin.Any
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class GroupMemberActorJoinDao {
  @Insert(
    onConflict = 5,
    entity = Any::class,
  )
  public actual abstract suspend fun insertOrIgnoreListAsync(entities: List<GroupMemberActorJoin>)

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertListAsync(entities: List<GroupMemberActorJoin>)

  @Query(`value` =
      "\n        UPDATE GroupMemberActorJoin\n           SET gmajLastMod = :lastModTime\n         WHERE gmajGroupActorUid = :gmajGroupActorUid\n           AND gmajMemberActorUid = :gmajMemberActorUid\n           AND gmajLastMod != :lastModTime \n    ")
  public actual abstract suspend fun updateLastModifiedTimeIfNeededAsync(
    gmajGroupActorUid: Long,
    gmajMemberActorUid: Long,
    lastModTime: Long,
  )
}
