/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import io.ktor.utils.io.bits.Memory;
import io.ktor.utils.io.bits.MemoryJvmKt;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.internal.jvm.ErrorsKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0005\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0007\u001a1\u0010\u000b\u001a\u00020\u0007*\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u001a$\u0010\u000b\u001a\u00020\u0007*\u00020\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000\u001a\u001a\u0010\u000f\u001a\u00020\u000e*\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0007\u001a\u0014\u0010\u0010\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0003H\u0000\u001a;\u0010\u0012\u001a\u00020\u0007*\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u001a,\u0010\u0012\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"ChunkBuffer", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "pool", "Lio/ktor/utils/io/pool/ObjectPool;", "readAvailable", "", "Lio/ktor/utils/io/core/Buffer;", "dst", "length", "readDirect", "block", "Lkotlin/Function1;", "", "readFully", "resetFromContentToWrite", "child", "writeDirect", "size", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nBufferUtilsJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferUtilsJvm.kt\nio/ktor/utils/io/core/BufferUtilsJvmKt\n+ 2 MemoryFactoryJvm.kt\nio/ktor/utils/io/bits/MemoryFactoryJvmKt\n+ 3 Buffer.kt\nio/ktor/utils/io/core/Buffer\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BufferPrimitives.kt\nio/ktor/utils/io/core/BufferPrimitivesKt\n+ 6 Buffer.kt\nio/ktor/utils/io/core/BufferKt\n*L\n1#1,123:1\n36#2:124\n74#3:125\n69#3:149\n1#4:126\n762#5,7:127\n769#5,6:139\n777#5:147\n372#6,5:134\n377#6,2:145\n355#6:148\n372#6,7:150\n390#6,7:157\n*S KotlinDebug\n*F\n+ 1 BufferUtilsJvm.kt\nio/ktor/utils/io/core/BufferUtilsJvmKt\n*L\n12#1:124\n44#1:125\n87#1:149\n73#1:127,7\n73#1:139,6\n73#1:147\n73#1:134,5\n73#1:145,2\n86#1:148\n99#1:150,7\n115#1:157,7\n*E\n"})
public final class BufferUtilsJvmKt {
    @NotNull
    public static final ChunkBuffer ChunkBuffer(@NotNull ByteBuffer buffer, @Nullable ObjectPool<ChunkBuffer> pool) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Memory.Companion $this$of$iv = Memory.Companion;
        boolean $i$f$of = false;
        ByteBuffer byteBuffer = buffer.slice().order(ByteOrder.BIG_ENDIAN);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer.slice().order(ByteOrder.BIG_ENDIAN)");
        return new ChunkBuffer(Memory.constructor-impl(byteBuffer), null, pool, null);
    }

    public static /* synthetic */ ChunkBuffer ChunkBuffer$default(ByteBuffer byteBuffer, ObjectPool objectPool, int n, Object object) {
        if ((n & 2) != 0) {
            objectPool = null;
        }
        return BufferUtilsJvmKt.ChunkBuffer(byteBuffer, objectPool);
    }

    public static final int readDirect(@NotNull ChunkBuffer $this$readDirect, @NotNull Function1<? super ByteBuffer, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$readDirect, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$readDirect = false;
        int readPosition = $this$readDirect.getReadPosition();
        int writePosition = $this$readDirect.getWritePosition();
        ByteBuffer byteBuffer = $this$readDirect.getMemory-SK3TCg8().duplicate();
        Intrinsics.checkNotNull((Object)byteBuffer);
        ByteBuffer bb = byteBuffer;
        bb.limit(writePosition);
        bb.position(readPosition);
        block2.invoke((Object)bb);
        int delta = bb.position() - readPosition;
        if (delta < 0) {
            ErrorsKt.negativeShiftError(delta);
            throw new KotlinNothingValueException();
        }
        if (bb.limit() != writePosition) {
            ErrorsKt.limitChangeError();
            throw new KotlinNothingValueException();
        }
        $this$readDirect.discardExact(delta);
        return delta;
    }

    public static final int writeDirect(@NotNull ChunkBuffer $this$writeDirect, int size, @NotNull Function1<? super ByteBuffer, Unit> block2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDirect, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$writeDirect = false;
        Buffer this_$iv = $this$writeDirect;
        boolean $i$f$getWriteRemaining = false;
        int rem = this_$iv.getLimit() - this_$iv.getWritePosition();
        if (!(size <= rem)) {
            boolean $i$a$-require-BufferUtilsJvmKt$writeDirect$22 = false;
            String $i$a$-require-BufferUtilsJvmKt$writeDirect$22 = "size " + size + " is greater than buffer's remaining capacity " + rem;
            throw new IllegalArgumentException($i$a$-require-BufferUtilsJvmKt$writeDirect$22.toString());
        }
        ByteBuffer byteBuffer = $this$writeDirect.getMemory-SK3TCg8().duplicate();
        Intrinsics.checkNotNull((Object)byteBuffer);
        ByteBuffer buffer = byteBuffer;
        int writePosition = $this$writeDirect.getWritePosition();
        int limit = $this$writeDirect.getLimit();
        buffer.limit(limit);
        buffer.position(writePosition);
        block2.invoke((Object)buffer);
        int delta = buffer.position() - writePosition;
        if (delta < 0 || delta > rem) {
            ErrorsKt.wrongBufferPositionChangeError(delta, size);
            throw new KotlinNothingValueException();
        }
        $this$writeDirect.commitWritten(delta);
        return delta;
    }

    public static final void resetFromContentToWrite(@NotNull ChunkBuffer $this$resetFromContentToWrite, @NotNull ByteBuffer child) {
        Intrinsics.checkNotNullParameter((Object)$this$resetFromContentToWrite, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        $this$resetFromContentToWrite.resetForWrite(child.limit());
        $this$resetFromContentToWrite.commitWrittenUntilIndex(child.position());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void readFully(@NotNull Buffer $this$readFully, @NotNull ByteBuffer dst, int length) {
        void start$iv;
        void endExclusive$iv;
        void $this$readExact$iv;
        Intrinsics.checkNotNullParameter((Object)$this$readFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Buffer buffer = $this$readFully;
        String name$iv = "buffer content";
        boolean $i$f$readExact = false;
        Unit value$iv = null;
        void $this$read$iv$iv = $this$readExact$iv;
        boolean $i$f$read = false;
        int n = $this$read$iv$iv.getWritePosition();
        int n2 = $this$read$iv$iv.getReadPosition();
        ByteBuffer memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
        boolean bl = false;
        if (endExclusive$iv - start$iv < length) {
            throw new EOFException("Not enough bytes to read a " + name$iv + " of size " + length + '.');
        }
        void var13_13 = start$iv;
        ByteBuffer memory = memory$iv;
        boolean bl2 = false;
        int limit = dst.limit();
        try {
            void offset;
            dst.limit(dst.position() + length);
            MemoryJvmKt.copyTo-62zg_DM(memory, dst, (int)offset);
        }
        finally {
            dst.limit(limit);
        }
        value$iv = Unit.INSTANCE;
        int rc$iv$iv = length;
        $this$read$iv$iv.discardExact(rc$iv$iv);
    }

    public static final int readAvailable(@NotNull Buffer $this$readAvailable, @NotNull ByteBuffer dst, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$readAvailable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Buffer $this$canRead$iv = $this$readAvailable;
        boolean $i$f$canRead = false;
        if (!($this$canRead$iv.getWritePosition() > $this$canRead$iv.getReadPosition())) {
            return -1;
        }
        Buffer this_$iv = $this$readAvailable;
        boolean $i$f$getReadRemaining = false;
        int size = Math.min(this_$iv.getWritePosition() - this_$iv.getReadPosition(), length);
        BufferUtilsJvmKt.readFully($this$readAvailable, dst, size);
        return size;
    }

    public static /* synthetic */ int readAvailable$default(Buffer buffer, ByteBuffer byteBuffer, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = byteBuffer.remaining();
        }
        return BufferUtilsJvmKt.readAvailable(buffer, byteBuffer, n);
    }

    /*
     * WARNING - void declaration
     */
    public static final int readDirect(@NotNull Buffer $this$readDirect, @NotNull Function1<? super ByteBuffer, Unit> block2) {
        void endExclusive;
        void start;
        Intrinsics.checkNotNullParameter((Object)$this$readDirect, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$readDirect = false;
        Buffer $this$read$iv = $this$readDirect;
        boolean $i$f$read = false;
        int n = $this$read$iv.getWritePosition();
        int n2 = $this$read$iv.getReadPosition();
        ByteBuffer memory = $this$read$iv.getMemory-SK3TCg8();
        boolean bl = false;
        ByteBuffer nioBuffer = Memory.slice-87lwejk(memory, (int)start, (int)(endExclusive - start));
        block2.invoke((Object)nioBuffer);
        if (!(nioBuffer.limit() == endExclusive - start)) {
            boolean bl2 = false;
            String string = "Buffer's limit change is not allowed";
            throw new IllegalStateException(string.toString());
        }
        int rc$iv = nioBuffer.position();
        $this$read$iv.discardExact(rc$iv);
        return rc$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final int writeDirect(@NotNull Buffer $this$writeDirect, int size, @NotNull Function1<? super ByteBuffer, Unit> block2) {
        void endExclusive;
        void start;
        Intrinsics.checkNotNullParameter((Object)$this$writeDirect, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$writeDirect = false;
        Buffer $this$write$iv = $this$writeDirect;
        boolean $i$f$write = false;
        int n = $this$write$iv.getLimit();
        int n2 = $this$write$iv.getWritePosition();
        ByteBuffer memory = $this$write$iv.getMemory-SK3TCg8();
        boolean bl = false;
        ByteBuffer nioBuffer = Memory.slice-87lwejk(memory, (int)start, (int)(endExclusive - start));
        block2.invoke((Object)nioBuffer);
        if (!(nioBuffer.limit() == endExclusive - start)) {
            boolean bl2 = false;
            String string = "Buffer's limit change is not allowed";
            throw new IllegalStateException(string.toString());
        }
        int rc$iv = nioBuffer.position();
        $this$write$iv.commitWritten(rc$iv);
        return rc$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ int writeDirect$default(Buffer $this$writeDirect_u24default, int size, Function1 block2, int n, Object object) {
        void endExclusive;
        void start;
        if ((n & 1) != 0) {
            size = 1;
        }
        Intrinsics.checkNotNullParameter((Object)$this$writeDirect_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        boolean $i$f$writeDirect = false;
        Buffer $this$write$iv = $this$writeDirect_u24default;
        boolean $i$f$write = false;
        int n2 = $this$write$iv.getLimit();
        int n3 = $this$write$iv.getWritePosition();
        ByteBuffer memory = $this$write$iv.getMemory-SK3TCg8();
        boolean bl = false;
        ByteBuffer nioBuffer = Memory.slice-87lwejk(memory, (int)start, (int)(endExclusive - start));
        block2.invoke((Object)nioBuffer);
        if (!(nioBuffer.limit() == endExclusive - start)) {
            boolean bl2 = false;
            String string = "Buffer's limit change is not allowed";
            throw new IllegalStateException(string.toString());
        }
        int rc$iv = nioBuffer.position();
        $this$write$iv.commitWritten(rc$iv);
        return rc$iv;
    }
}

