/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Font;
import java.awt.color.ColorSpace;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.FontSlant;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.DependsOnJBR;
import org.jetbrains.skiko.DirectDataBuffer;
import org.jetbrains.skiko.SkikoInputEvent;
import org.jetbrains.skiko.SkikoInputModifiers;
import org.jetbrains.skiko.SkikoKey;
import org.jetbrains.skiko.SkikoKeyboardEvent;
import org.jetbrains.skiko.SkikoKeyboardEventKind;
import org.jetbrains.skiko.SkikoMouseButtons;
import org.jetbrains.skiko.SkikoPointerEvent;
import org.jetbrains.skiko.SkikoPointerEventKind;
import org.jetbrains.skiko.awt.font.AwtFontManager;
import org.jetbrains.skiko.awt.font.AwtFontUtils;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0015\u001a\u000e\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0015H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0015H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0013\u001a\u0018\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010\u0013\u001a\u0010\u0010'\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0007H\u0000\u001a\u0010\u0010(\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u001a\n\u0010)\u001a\u00020**\u00020+\u001a\n\u0010,\u001a\u00020+*\u00020*\u001a\n\u0010-\u001a\u00020.*\u00020+\u001a\u001f\u0010/\u001a\u0004\u0018\u000100*\u00020\t2\u0006\u00101\u001a\u000202H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\" \u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\" \u0010\f\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\" \u0010\u000e\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00064"}, d2={"MouseEventButton4", "", "getMouseEventButton4", "()I", "MouseEventButton5", "getMouseEventButton5", "posture", "", "kotlin.jvm.PlatformType", "Ljava/awt/Font;", "getPosture", "(Ljava/awt/Font;)Ljava/lang/Float;", "weight", "getWeight", "width", "getWidth", "toSkikoEvent", "Lorg/jetbrains/skiko/SkikoKeyboardEvent;", "event", "Ljava/awt/event/KeyEvent;", "Lorg/jetbrains/skiko/SkikoPointerEvent;", "Ljava/awt/event/MouseEvent;", "Ljava/awt/event/MouseWheelEvent;", "toSkikoKey", "toSkikoModifiers", "Lorg/jetbrains/skiko/SkikoInputModifiers;", "modifiers", "(I)I", "toSkikoMouseButton", "Lorg/jetbrains/skiko/SkikoMouseButtons;", "(Ljava/awt/event/MouseEvent;)I", "toSkikoPressedMouseButtons", "toSkikoSlant", "Lorg/jetbrains/skia/FontSlant;", "toSkikoTypeEvent", "Lorg/jetbrains/skiko/SkikoInputEvent;", "Ljava/awt/event/InputMethodEvent;", "keyEvent", "typeEvent", "toSkikoWeight", "toSkikoWidth", "toBitmap", "Lorg/jetbrains/skia/Bitmap;", "Ljava/awt/image/BufferedImage;", "toBufferedImage", "toImage", "Lorg/jetbrains/skia/Image;", "toSkikoTypefaceOrNull", "Lorg/jetbrains/skia/Typeface;", "fontManager", "Lorg/jetbrains/skiko/awt/font/AwtFontManager;", "(Ljava/awt/Font;Lorg/jetbrains/skiko/awt/font/AwtFontManager;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "skiko"})
public final class Convertors_jvmKt {
    @NotNull
    public static final BufferedImage toBufferedImage(@NotNull Bitmap $this$toBufferedImage) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)$this$toBufferedImage, (String)"<this>");
        Pixmap pixmap = $this$toBufferedImage.peekPixels();
        Intrinsics.checkNotNull((Object)pixmap);
        long pixelsNativePointer = pixmap.getAddr();
        ByteBuffer pixelsBuffer = BufferUtil.INSTANCE.getByteBufferFromPointer(pixelsNativePointer, $this$toBufferedImage.getRowBytes() * $this$toBufferedImage.getHeight());
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toBufferedImage.getColorInfo().getColorType().ordinal()]) {
            case 1: {
                int[] nArray2 = new int[]{0, 1, 2, 3};
                nArray = nArray2;
                break;
            }
            case 2: {
                int[] nArray2 = new int[]{2, 1, 0, 3};
                nArray = nArray2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported color type " + (Object)((Object)$this$toBufferedImage.getColorInfo().getColorType()));
            }
        }
        int[] order = nArray;
        WritableRaster raster = Raster.createInterleavedRaster(new DirectDataBuffer(pixelsBuffer), $this$toBufferedImage.getWidth(), $this$toBufferedImage.getHeight(), $this$toBufferedImage.getWidth() * 4, 4, order, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        ColorModel colorModel2 = colorModel;
        WritableRaster writableRaster = raster;
        Intrinsics.checkNotNull((Object)writableRaster);
        return new BufferedImage(colorModel2, writableRaster, false, null);
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull BufferedImage $this$toBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        int bytesPerPixel = 4;
        byte[] pixels = new byte[$this$toBitmap.getWidth() * $this$toBitmap.getHeight() * bytesPerPixel];
        int k = 0;
        int n = $this$toBitmap.getHeight();
        for (int y2 = 0; y2 < n; ++y2) {
            int n2 = $this$toBitmap.getWidth();
            for (int x2 = 0; x2 < n2; ++x2) {
                int argb = $this$toBitmap.getRGB(x2, y2);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                pixels[k++] = (byte)b;
                pixels[k++] = (byte)g;
                pixels[k++] = (byte)r;
                pixels[k++] = (byte)a;
            }
        }
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(ImageInfo.Companion.makeS32($this$toBitmap.getWidth(), $this$toBitmap.getHeight(), ColorAlphaType.UNPREMUL));
        bitmap.installPixels(pixels);
        return bitmap;
    }

    @NotNull
    public static final Image toImage(@NotNull BufferedImage $this$toImage) {
        Intrinsics.checkNotNullParameter((Object)$this$toImage, (String)"<this>");
        return Image.Companion.makeFromBitmap(Convertors_jvmKt.toBitmap($this$toImage));
    }

    private static final int getMouseEventButton4() {
        return 4;
    }

    private static final int getMouseEventButton5() {
        return 5;
    }

    @NotNull
    public static final SkikoPointerEvent toSkikoEvent(@NotNull MouseEvent event) {
        SkikoPointerEventKind skikoPointerEventKind;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        double d = event.getX();
        double d2 = event.getY();
        int n = Convertors_jvmKt.toSkikoPressedMouseButtons(event);
        int n2 = Convertors_jvmKt.toSkikoMouseButton(event);
        int n3 = Convertors_jvmKt.toSkikoModifiers(event.getModifiersEx());
        switch (event.getID()) {
            case 501: {
                skikoPointerEventKind = SkikoPointerEventKind.DOWN;
                break;
            }
            case 502: {
                skikoPointerEventKind = SkikoPointerEventKind.UP;
                break;
            }
            case 506: {
                skikoPointerEventKind = SkikoPointerEventKind.DRAG;
                break;
            }
            case 503: {
                skikoPointerEventKind = SkikoPointerEventKind.MOVE;
                break;
            }
            case 504: {
                skikoPointerEventKind = SkikoPointerEventKind.ENTER;
                break;
            }
            case 505: {
                skikoPointerEventKind = SkikoPointerEventKind.EXIT;
                break;
            }
            default: {
                skikoPointerEventKind = SkikoPointerEventKind.UNKNOWN;
            }
        }
        SkikoPointerEventKind skikoPointerEventKind2 = skikoPointerEventKind;
        long l = event.getWhen();
        return new SkikoPointerEvent(d, d2, skikoPointerEventKind2, 0.0, 0.0, n, n2, n3, l, null, event, 536, null);
    }

    @NotNull
    public static final SkikoPointerEvent toSkikoEvent(@NotNull MouseWheelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        double scrollAmount = event.getPreciseWheelRotation();
        int modifiers = Convertors_jvmKt.toSkikoModifiers(event.getModifiersEx());
        boolean isShiftPressed = SkikoInputModifiers.has-TH98kIg(modifiers, SkikoInputModifiers.Companion.getSHIFT-kKhcapQ());
        double deltaX = isShiftPressed ? scrollAmount : 0.0;
        double deltaY = isShiftPressed ? 0.0 : scrollAmount;
        double d = event.getX();
        double d2 = event.getY();
        int n = Convertors_jvmKt.toSkikoPressedMouseButtons(event);
        int n2 = Convertors_jvmKt.toSkikoMouseButton(event);
        SkikoPointerEventKind skikoPointerEventKind = event.getID() == 507 ? SkikoPointerEventKind.SCROLL : SkikoPointerEventKind.UNKNOWN;
        long l = event.getWhen();
        return new SkikoPointerEvent(d, d2, skikoPointerEventKind, deltaX, deltaY, n, n2, modifiers, l, null, event, 512, null);
    }

    @NotNull
    public static final SkikoKeyboardEvent toSkikoEvent(@NotNull KeyEvent event) {
        SkikoKeyboardEventKind skikoKeyboardEventKind;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SkikoKey skikoKey = SkikoKey.Companion.valueOf(Convertors_jvmKt.toSkikoKey(event));
        int n = Convertors_jvmKt.toSkikoModifiers(event.getModifiersEx());
        switch (event.getID()) {
            case 401: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.DOWN;
                break;
            }
            case 402: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UP;
                break;
            }
            default: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UNKNOWN;
            }
        }
        return new SkikoKeyboardEvent(skikoKey, n, skikoKeyboardEventKind, event.getWhen(), event, null);
    }

    @NotNull
    public static final SkikoInputEvent toSkikoTypeEvent(@NotNull KeyEvent typeEvent, @Nullable KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)typeEvent, (String)"typeEvent");
        int key = -1;
        int modifiers = SkikoInputModifiers.Companion.getEMPTY-kKhcapQ();
        if (keyEvent != null) {
            key = Convertors_jvmKt.toSkikoKey(keyEvent);
            modifiers = Convertors_jvmKt.toSkikoModifiers(keyEvent.getModifiersEx());
        }
        return new SkikoInputEvent(String.valueOf(typeEvent.getKeyChar()), SkikoKey.Companion.valueOf(key), modifiers, SkikoKeyboardEventKind.TYPE, typeEvent, null);
    }

    @NotNull
    public static final SkikoInputEvent toSkikoTypeEvent(@NotNull InputMethodEvent event, @Nullable KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int key = -1;
        int modifiers = SkikoInputModifiers.Companion.getEMPTY-kKhcapQ();
        if (keyEvent != null) {
            key = Convertors_jvmKt.toSkikoKey(keyEvent);
            modifiers = Convertors_jvmKt.toSkikoModifiers(keyEvent.getModifiersEx());
        }
        return new SkikoInputEvent("", SkikoKey.Companion.valueOf(key), modifiers, SkikoKeyboardEventKind.TYPE, event, null);
    }

    private static final int toSkikoPressedMouseButtons(MouseEvent event) {
        int mask = event.getModifiersEx();
        int result2 = 0;
        if ((mask & 0x400) != 0 || event.getID() == 501 && event.getButton() == 1) {
            result2 |= SkikoMouseButtons.Companion.getLEFT-CuO1FYg();
        }
        if ((mask & 0x800) != 0 || event.getID() == 501 && event.getButton() == 2) {
            result2 |= SkikoMouseButtons.Companion.getMIDDLE-CuO1FYg();
        }
        if ((mask & 0x1000) != 0 || event.getID() == 501 && event.getButton() == 3) {
            result2 |= SkikoMouseButtons.Companion.getRIGHT-CuO1FYg();
        }
        if ((mask & MouseEvent.getMaskForButton(Convertors_jvmKt.getMouseEventButton4())) != 0 || event.getID() == 501 && event.getButton() == Convertors_jvmKt.getMouseEventButton4()) {
            result2 |= SkikoMouseButtons.Companion.getBUTTON_4-CuO1FYg();
        }
        if ((mask & MouseEvent.getMaskForButton(Convertors_jvmKt.getMouseEventButton5())) != 0 || event.getID() == 501 && event.getButton() == Convertors_jvmKt.getMouseEventButton5()) {
            result2 |= SkikoMouseButtons.Companion.getBUTTON_5-CuO1FYg();
        }
        return SkikoMouseButtons.constructor-impl(result2);
    }

    private static final int toSkikoMouseButton(MouseEvent event) {
        int n = event.getButton();
        return n == 1 ? SkikoMouseButtons.Companion.getLEFT-CuO1FYg() : (n == 2 ? SkikoMouseButtons.Companion.getMIDDLE-CuO1FYg() : (n == 3 ? SkikoMouseButtons.Companion.getRIGHT-CuO1FYg() : (n == Convertors_jvmKt.getMouseEventButton4() ? SkikoMouseButtons.Companion.getBUTTON_4-CuO1FYg() : (n == Convertors_jvmKt.getMouseEventButton5() ? SkikoMouseButtons.Companion.getBUTTON_5-CuO1FYg() : SkikoMouseButtons.constructor-impl(event.getButton())))));
    }

    private static final int toSkikoModifiers(int modifiers) {
        int result2 = 0;
        if ((modifiers & 0x200) != 0) {
            result2 = SkikoInputModifiers.Companion.getALT-kKhcapQ();
        }
        if ((modifiers & 0x40) != 0) {
            result2 |= SkikoInputModifiers.Companion.getSHIFT-kKhcapQ();
        }
        if ((modifiers & 0x80) != 0) {
            result2 |= SkikoInputModifiers.Companion.getCONTROL-kKhcapQ();
        }
        if ((modifiers & 0x100) != 0) {
            result2 |= SkikoInputModifiers.Companion.getMETA-kKhcapQ();
        }
        return SkikoInputModifiers.constructor-impl(result2);
    }

    private static final int toSkikoKey(KeyEvent event) {
        int key = event.getKeyCode();
        int side = event.getKeyLocation();
        if (side == 3 && (key == SkikoKey.KEY_LEFT_CONTROL.getPlatformKeyCode() || key == SkikoKey.KEY_LEFT_SHIFT.getPlatformKeyCode() || key == SkikoKey.KEY_LEFT_META.getPlatformKeyCode())) {
            key |= Integer.MIN_VALUE;
        }
        if (side == 4 && key == SkikoKey.KEY_ENTER.getPlatformKeyCode()) {
            key |= Integer.MIN_VALUE;
        }
        return key;
    }

    @DependsOnJBR
    @Nullable
    public static final Object toSkikoTypefaceOrNull(@NotNull Font $this$toSkikoTypefaceOrNull, @NotNull AwtFontManager fontManager, @NotNull Continuation<? super Typeface> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Typeface>, Object>($this$toSkikoTypefaceOrNull, fontManager, null){
            int label;
            final /* synthetic */ Font $this_toSkikoTypefaceOrNull;
            final /* synthetic */ AwtFontManager $fontManager;
            {
                this.$this_toSkikoTypefaceOrNull = $receiver;
                this.$fontManager = $fontManager;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Float f = Convertors_jvmKt.getWeight(this.$this_toSkikoTypefaceOrNull);
                        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"weight");
                        int n = Convertors_jvmKt.toSkikoWeight(((Number)f).floatValue());
                        Float f2 = Convertors_jvmKt.getWidth(this.$this_toSkikoTypefaceOrNull);
                        Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"width");
                        int n2 = Convertors_jvmKt.toSkikoWidth(((Number)f2).floatValue());
                        Float f3 = Convertors_jvmKt.getPosture(this.$this_toSkikoTypefaceOrNull);
                        Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"posture");
                        FontStyle fontStyle = new FontStyle(n, n2, Convertors_jvmKt.toSkikoSlant(((Number)f3).floatValue()));
                        String string = AwtFontUtils.INSTANCE.getFontFamilyName(this.$this_toSkikoTypefaceOrNull);
                        if (string == null) {
                            return null;
                        }
                        String familyName = string;
                        this.label = 1;
                        Object object3 = this.$fontManager.getTypefaceOrNull(familyName, fontStyle, (Continuation<? super Typeface>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Typeface> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final int toSkikoWeight(float weight) {
        int n;
        if (weight <= 0.01f) {
            n = 0;
        } else {
            Float f = TextAttribute.WEIGHT_EXTRA_LIGHT;
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"WEIGHT_EXTRA_LIGHT");
            if (weight <= ((Number)f).floatValue()) {
                n = 100;
            } else {
                Float f2 = TextAttribute.WEIGHT_LIGHT;
                Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"WEIGHT_LIGHT");
                if (weight <= ((Number)f2).floatValue()) {
                    n = 200;
                } else {
                    Float f3 = TextAttribute.WEIGHT_DEMILIGHT;
                    Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"WEIGHT_DEMILIGHT");
                    if (weight <= ((Number)f3).floatValue()) {
                        n = 300;
                    } else {
                        Float f4 = TextAttribute.WEIGHT_REGULAR;
                        Intrinsics.checkNotNullExpressionValue((Object)f4, (String)"WEIGHT_REGULAR");
                        if (weight <= ((Number)f4).floatValue()) {
                            n = 400;
                        } else {
                            Float f5 = TextAttribute.WEIGHT_MEDIUM;
                            Intrinsics.checkNotNullExpressionValue((Object)f5, (String)"WEIGHT_MEDIUM");
                            if (weight <= ((Number)f5).floatValue()) {
                                n = 500;
                            } else {
                                Float f6 = TextAttribute.WEIGHT_DEMIBOLD;
                                Intrinsics.checkNotNullExpressionValue((Object)f6, (String)"WEIGHT_DEMIBOLD");
                                if (weight <= ((Number)f6).floatValue()) {
                                    n = 600;
                                } else {
                                    Float f7 = TextAttribute.WEIGHT_BOLD;
                                    Intrinsics.checkNotNullExpressionValue((Object)f7, (String)"WEIGHT_BOLD");
                                    if (weight <= ((Number)f7).floatValue()) {
                                        n = 700;
                                    } else {
                                        Float f8 = TextAttribute.WEIGHT_HEAVY;
                                        Intrinsics.checkNotNullExpressionValue((Object)f8, (String)"WEIGHT_HEAVY");
                                        if (weight <= ((Number)f8).floatValue()) {
                                            n = 800;
                                        } else {
                                            Float f9 = TextAttribute.WEIGHT_EXTRABOLD;
                                            Intrinsics.checkNotNullExpressionValue((Object)f9, (String)"WEIGHT_EXTRABOLD");
                                            n = weight <= ((Number)f9).floatValue() ? 900 : 1000;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    public static final int toSkikoWidth(float width2) {
        int n;
        Float f = TextAttribute.WIDTH_CONDENSED;
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"WIDTH_CONDENSED");
        if (width2 <= ((Number)f).floatValue()) {
            n = 3;
        } else {
            Float f2 = TextAttribute.WIDTH_SEMI_CONDENSED;
            Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"WIDTH_SEMI_CONDENSED");
            if (width2 <= ((Number)f2).floatValue()) {
                n = 4;
            } else {
                Float f3 = TextAttribute.WIDTH_REGULAR;
                Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"WIDTH_REGULAR");
                if (width2 <= ((Number)f3).floatValue()) {
                    n = 5;
                } else {
                    Float f4 = TextAttribute.WIDTH_SEMI_EXTENDED;
                    Intrinsics.checkNotNullExpressionValue((Object)f4, (String)"WIDTH_SEMI_EXTENDED");
                    n = width2 <= ((Number)f4).floatValue() ? 6 : 7;
                }
            }
        }
        return n;
    }

    @NotNull
    public static final FontSlant toSkikoSlant(float posture) {
        Float f = TextAttribute.POSTURE_REGULAR;
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"POSTURE_REGULAR");
        return posture <= ((Number)f).floatValue() ? FontSlant.UPRIGHT : FontSlant.ITALIC;
    }

    public static final Float getWeight(@NotNull Font $this$weight) {
        Intrinsics.checkNotNullParameter((Object)$this$weight, (String)"<this>");
        Object obj = $this$weight.getAttributes().get(TextAttribute.WEIGHT);
        Float f = obj instanceof Float ? (Float)obj : null;
        if (f == null) {
            f = TextAttribute.WEIGHT_REGULAR;
        }
        return f;
    }

    public static final Float getWidth(@NotNull Font $this$width) {
        Intrinsics.checkNotNullParameter((Object)$this$width, (String)"<this>");
        Object obj = $this$width.getAttributes().get(TextAttribute.WIDTH);
        Float f = obj instanceof Float ? (Float)obj : null;
        if (f == null) {
            f = TextAttribute.WIDTH_REGULAR;
        }
        return f;
    }

    public static final Float getPosture(@NotNull Font $this$posture) {
        Intrinsics.checkNotNullParameter((Object)$this$posture, (String)"<this>");
        Object obj = $this$posture.getAttributes().get(TextAttribute.POSTURE);
        Float f = obj instanceof Float ? (Float)obj : null;
        if (f == null) {
            f = TextAttribute.POSTURE_REGULAR;
        }
        return f;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            try {
                nArray[ColorType.RGB_888X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.BGRA_8888.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

