/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;

public class LoggingFilterReader
extends FilterReader {
    static final char LOG_CHAR = '\n';
    final Logger logger;
    final StringBuilder buffer = new StringBuilder();

    public LoggingFilterReader(Reader in, Logger logger) {
        super(in);
        this.logger = logger;
    }

    protected void log() {
        if (this.buffer.length() > 0) {
            this.logger.debug(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }

    private static int indexOf(char[] array, char c, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            if (array[i] != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ret = super.read(cbuf, off, len);
        if (ret != -1) {
            this.buffer.append(cbuf, off, ret);
        }
        if (ret == -1 || LoggingFilterReader.indexOf(cbuf, '\n', off, ret) != -1) {
            this.log();
        }
        return ret;
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        if (ret != -1) {
            this.buffer.append((char)ret);
        }
        if (ret == -1 || ret == 10) {
            this.log();
        }
        return ret;
    }
}

