/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.progress;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.CountDownLatch;
import net.bramp.ffmpeg.progress.StreamProgressParser;

class TcpProgressParserRunnable
implements Runnable {
    final StreamProgressParser parser;
    final ServerSocket server;
    final CountDownLatch startSignal;

    public TcpProgressParserRunnable(StreamProgressParser parser, ServerSocket server, CountDownLatch startSignal) {
        this.parser = (StreamProgressParser)Preconditions.checkNotNull((Object)parser);
        this.server = (ServerSocket)Preconditions.checkNotNull((Object)server);
        this.startSignal = (CountDownLatch)Preconditions.checkNotNull((Object)startSignal);
    }

    @Override
    public void run() {
        while (!this.server.isClosed() && !Thread.currentThread().isInterrupted()) {
            try {
                this.startSignal.countDown();
                Socket socket = this.server.accept();
                try {
                    InputStream stream = socket.getInputStream();
                    try {
                        this.parser.processStream(stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                }
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {}
        }
    }
}

