/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.progress;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.concurrent.CountDownLatch;
import net.bramp.ffmpeg.progress.StreamProgressParser;

class UdpProgressParserRunnable
implements Runnable {
    static final int MAX_PACKET_SIZE = 1500;
    final StreamProgressParser parser;
    final DatagramSocket socket;
    final CountDownLatch startSignal;

    public UdpProgressParserRunnable(StreamProgressParser parser, DatagramSocket socket, CountDownLatch startSignal) {
        this.parser = (StreamProgressParser)Preconditions.checkNotNull((Object)parser);
        this.socket = (DatagramSocket)Preconditions.checkNotNull((Object)socket);
        this.startSignal = (CountDownLatch)Preconditions.checkNotNull((Object)startSignal);
    }

    @Override
    public void run() {
        byte[] buf = new byte[1500];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        while (!this.socket.isClosed() && !Thread.currentThread().isInterrupted()) {
            this.startSignal.countDown();
            try {
                this.socket.receive(packet);
                if (packet.getLength() == 0) continue;
                ByteArrayInputStream in = new ByteArrayInputStream(packet.getData(), packet.getOffset(), packet.getLength());
                this.parser.processStream(in);
            }
            catch (SocketException socketException) {
            }
            catch (IOException iOException) {}
        }
    }
}

