/*
 * Decompiled with CFR 0.152.
 */
package com.github.doyaaaaaken.kotlincsv.client;

import com.github.doyaaaaaken.kotlincsv.client.BufferedLineReader;
import com.github.doyaaaaaken.kotlincsv.client.Reader;
import com.github.doyaaaaaken.kotlincsv.dsl.context.CsvReaderContext;
import com.github.doyaaaaaken.kotlincsv.dsl.context.ExcessFieldsRowBehaviour;
import com.github.doyaaaaaken.kotlincsv.dsl.context.InsufficientFieldsRowBehaviour;
import com.github.doyaaaaaken.kotlincsv.parser.CsvParser;
import com.github.doyaaaaaken.kotlincsv.util.CSVAutoRenameFailedException;
import com.github.doyaaaaaken.kotlincsv.util.CSVFieldNumDifferentException;
import com.github.doyaaaaaken.kotlincsv.util.MalformedCSVException;
import com.github.doyaaaaaken.kotlincsv.util.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J#\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001b0\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0007J\u001b\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\b\b\u0002\u0010\u001e\u001a\u00020\u0012H\u0082\u0010J(\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010#\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/doyaaaaaken/kotlincsv/client/CsvFileReader;", "", "ctx", "Lcom/github/doyaaaaaken/kotlincsv/dsl/context/CsvReaderContext;", "reader", "Lcom/github/doyaaaaaken/kotlincsv/client/Reader;", "logger", "Lcom/github/doyaaaaaken/kotlincsv/util/logger/Logger;", "(Lcom/github/doyaaaaaken/kotlincsv/dsl/context/CsvReaderContext;Lcom/github/doyaaaaaken/kotlincsv/client/Reader;Lcom/github/doyaaaaaken/kotlincsv/util/logger/Logger;)V", "parser", "Lcom/github/doyaaaaaken/kotlincsv/parser/CsvParser;", "Lcom/github/doyaaaaaken/kotlincsv/client/BufferedLineReader;", "rowNum", "", "close", "", "deduplicateHeaders", "", "", "headers", "findDuplicate", "readAllAsSequence", "Lkotlin/sequences/Sequence;", "fieldsNum", "", "(Ljava/lang/Integer;)Lkotlin/sequences/Sequence;", "readAllWithHeaderAsSequence", "", "readNext", "readUntilNextCsvRow", "leftOver", "skipMismatchedRow", "", "idx", "row", "numFieldsInRow", "kotlin-csv"})
public final class CsvFileReader {
    @NotNull
    private final CsvReaderContext ctx;
    @NotNull
    private final Logger logger;
    @NotNull
    private final BufferedLineReader reader;
    private long rowNum;
    @NotNull
    private final CsvParser parser;

    public CsvFileReader(@NotNull CsvReaderContext ctx, @NotNull Reader reader, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.ctx = ctx;
        this.logger = logger;
        this.reader = new BufferedLineReader(reader);
        this.parser = new CsvParser(this.ctx.getQuoteChar(), this.ctx.getDelimiter(), this.ctx.getEscapeChar());
    }

    @Deprecated(message="We are considering making it a private method. If you have feedback, please comment on Issue #100.")
    @Nullable
    public final List<String> readNext() {
        return this.readUntilNextCsvRow("");
    }

    @NotNull
    public final Sequence<List<String>> readAllAsSequence(@Nullable Integer fieldsNum) {
        Ref.ObjectRef expectedNumFieldsInRow = new Ref.ObjectRef();
        expectedNumFieldsInRow.element = fieldsNum;
        return SequencesKt.mapIndexedNotNull((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ CsvFileReader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final List<String> invoke() {
                return this.this$0.readNext();
            }
        })), (Function2)((Function2)new Function2<Integer, List<? extends String>, List<? extends String>>((Ref.ObjectRef<Integer>)expectedNumFieldsInRow, this){
            final /* synthetic */ Ref.ObjectRef<Integer> $expectedNumFieldsInRow;
            final /* synthetic */ CsvFileReader this$0;
            {
                this.$expectedNumFieldsInRow = $expectedNumFieldsInRow;
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final List<String> invoke(int idx, @NotNull List<String> row) {
                List list;
                int numFieldsInRow;
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                if (this.$expectedNumFieldsInRow.element == null) {
                    this.$expectedNumFieldsInRow.element = row.size();
                }
                Integer n = (Integer)this.$expectedNumFieldsInRow.element;
                int n2 = numFieldsInRow = n != null ? n.intValue() : row.size();
                if (row.size() > numFieldsInRow) {
                    if (CsvFileReader.access$getCtx$p(this.this$0).getExcessFieldsRowBehaviour() == ExcessFieldsRowBehaviour.TRIM) {
                        CsvFileReader.access$getLogger$p(this.this$0).info("trimming excess rows. [csv row num = " + (idx + 1) + ", fields num = " + row.size() + ", fields num of row = " + numFieldsInRow + ']');
                        list = row.subList(0, numFieldsInRow);
                        return list;
                    } else {
                        if (!CsvFileReader.access$getCtx$p(this.this$0).getSkipMissMatchedRow() && CsvFileReader.access$getCtx$p(this.this$0).getExcessFieldsRowBehaviour() != ExcessFieldsRowBehaviour.IGNORE) throw new CSVFieldNumDifferentException(numFieldsInRow, row.size(), idx + 1);
                        list = (List)((Object)CsvFileReader.access$skipMismatchedRow(this.this$0, idx, row, numFieldsInRow));
                    }
                    return list;
                } else if (numFieldsInRow != row.size()) {
                    if (CsvFileReader.access$getCtx$p(this.this$0).getSkipMissMatchedRow() || CsvFileReader.access$getCtx$p(this.this$0).getInsufficientFieldsRowBehaviour() == InsufficientFieldsRowBehaviour.IGNORE) {
                        list = (List)((Object)CsvFileReader.access$skipMismatchedRow(this.this$0, idx, row, numFieldsInRow));
                        return list;
                    } else {
                        if (CsvFileReader.access$getCtx$p(this.this$0).getInsufficientFieldsRowBehaviour() != InsufficientFieldsRowBehaviour.EMPTY_STRING) throw new CSVFieldNumDifferentException(numFieldsInRow, row.size(), idx + 1);
                        int numOfMissingFields = numFieldsInRow - row.size();
                        Collection collection = row;
                        ArrayList<String> arrayList = new ArrayList<String>(numOfMissingFields);
                        int n3 = 0;
                        while (n3 < numOfMissingFields) {
                            int n4;
                            int n5 = n4 = n3++;
                            ArrayList<String> arrayList2 = arrayList;
                            boolean bl = false;
                            arrayList2.add("");
                        }
                        list = CollectionsKt.plus((Collection)collection, (Iterable)arrayList);
                    }
                    return list;
                } else {
                    list = row;
                }
                return list;
            }
        }));
    }

    public static /* synthetic */ Sequence readAllAsSequence$default(CsvFileReader csvFileReader, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return csvFileReader.readAllAsSequence(n);
    }

    private final Void skipMismatchedRow(int idx, List<String> row, int numFieldsInRow) {
        this.logger.info("skip miss matched row. [csv row num = " + (idx + 1) + ", fields num = " + row.size() + ", fields num of first row = " + numFieldsInRow + ']');
        return null;
    }

    @NotNull
    public final Sequence<Map<String, String>> readAllWithHeaderAsSequence() {
        Ref.ObjectRef headers = new Ref.ObjectRef();
        List<String> list = this.readNext();
        if (list == null) {
            return SequencesKt.emptySequence();
        }
        headers.element = list;
        if (this.ctx.getAutoRenameDuplicateHeaders()) {
            headers.element = this.deduplicateHeaders((List)headers.element);
        } else {
            String duplicated = this.findDuplicate((List)headers.element);
            if (duplicated != null) {
                throw new MalformedCSVException("header '" + duplicated + "' is duplicated. please consider to use 'autoRenameDuplicateHeaders' option.");
            }
        }
        return SequencesKt.map(this.readAllAsSequence(((List)headers.element).size()), (Function1)((Function1)new Function1<List<? extends String>, Map<String, ? extends String>>((Ref.ObjectRef<List<String>>)headers){
            final /* synthetic */ Ref.ObjectRef<List<String>> $headers;
            {
                this.$headers = $headers;
                super(1);
            }

            @NotNull
            public final Map<String, String> invoke(@NotNull List<String> fields) {
                Intrinsics.checkNotNullParameter(fields, (String)"fields");
                return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((Iterable)this.$headers.element), (Iterable)fields));
            }
        }));
    }

    public final void close() {
        this.reader.close();
    }

    private final List<String> readUntilNextCsvRow(String leftOver) {
        List<String> list;
        CsvFileReader csvFileReader = this;
        String string = leftOver;
        while (true) {
            CsvFileReader csvFileReader2 = csvFileReader;
            String string2 = string;
            String nextLine = csvFileReader2.reader.readLineWithTerminator();
            long l = csvFileReader2.rowNum;
            csvFileReader2.rowNum = l + 1L;
            if (nextLine == null) {
                if (((CharSequence)string2).length() > 0) {
                    throw new MalformedCSVException('\"' + string2 + "\" on the tail of file is left on the way of parsing row");
                }
                list = (List<String>)((Object)((Void)null));
                break;
            }
            if (csvFileReader2.ctx.getSkipEmptyLine() && StringsKt.isBlank((CharSequence)nextLine) && StringsKt.isBlank((CharSequence)string2)) {
                csvFileReader = csvFileReader2;
                string = string2;
                continue;
            }
            String value = ((CharSequence)string2).length() == 0 ? String.valueOf(nextLine) : string2 + nextLine;
            list = csvFileReader2.parser.parseRow(value, csvFileReader2.rowNum);
            if (list != null) break;
            String string3 = string2 + nextLine;
            csvFileReader = csvFileReader2;
            string = string3;
        }
        return list;
    }

    static /* synthetic */ List readUntilNextCsvRow$default(CsvFileReader csvFileReader, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return csvFileReader.readUntilNextCsvRow(string);
    }

    private final String findDuplicate(List<String> headers) {
        Set set = new LinkedHashSet();
        Iterable $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String h = (String)element$iv;
            boolean bl = false;
            if (set.contains(h)) {
                return h;
            }
            set.add(h);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> deduplicateHeaders(List<String> headers) {
        List list;
        void $this$mapTo$iv$iv;
        Map occurrences = new LinkedHashMap();
        Iterable $this$map$iv = headers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void header;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map $this$getOrPut$iv = occurrences;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(header);
            if (value$iv == null) {
                boolean bl2 = false;
                Integer answer$iv = 0;
                $this$getOrPut$iv.put(header, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            int count = ((Number)object).intValue() + 1;
            Integer n = count;
            occurrences.put(header, n);
            collection.add(count > 1 ? (String)header + '_' + count : header);
        }
        List results = list = (List)destination$iv$iv;
        boolean bl = false;
        if (results.size() != CollectionsKt.distinct((Iterable)results).size()) {
            throw new CSVAutoRenameFailedException();
        }
        return list;
    }

    public static final /* synthetic */ CsvReaderContext access$getCtx$p(CsvFileReader $this) {
        return $this.ctx;
    }

    public static final /* synthetic */ Logger access$getLogger$p(CsvFileReader $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Void access$skipMismatchedRow(CsvFileReader $this, int idx, List row, int numFieldsInRow) {
        return $this.skipMismatchedRow(idx, row, numFieldsInRow);
    }
}

