/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache;

import android.content.Context;
import com.ustadmobile.door.DatabaseBuilder;
import com.ustadmobile.door.migration.DoorMigration;
import com.ustadmobile.libcache.CachePaths;
import com.ustadmobile.libcache.CachePathsProvider;
import com.ustadmobile.libcache.UstadCache;
import com.ustadmobile.libcache.UstadCacheImpl;
import com.ustadmobile.libcache.db.CacheDbMigration8_9Kt;
import com.ustadmobile.libcache.db.CacheDbMigrationsKt;
import com.ustadmobile.libcache.db.UstadCacheDb;
import com.ustadmobile.libcache.logging.UstadCacheLogger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010(\u001a\u00020)R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006+"}, d2={"Lcom/ustadmobile/libcache/UstadCacheBuilder;", "", "appContext", "Landroid/content/Context;", "storagePath", "Lkotlinx/io/files/Path;", "dbName", "", "logger", "Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "sizeLimit", "Lkotlin/Function0;", "", "cachePathsProvider", "Lcom/ustadmobile/libcache/CachePathsProvider;", "(Landroid/content/Context;Lkotlinx/io/files/Path;Ljava/lang/String;Lcom/ustadmobile/libcache/logging/UstadCacheLogger;Lkotlin/jvm/functions/Function0;Lcom/ustadmobile/libcache/CachePathsProvider;)V", "getAppContext", "()Landroid/content/Context;", "setAppContext", "(Landroid/content/Context;)V", "getCachePathsProvider", "()Lcom/ustadmobile/libcache/CachePathsProvider;", "setCachePathsProvider", "(Lcom/ustadmobile/libcache/CachePathsProvider;)V", "getDbName", "()Ljava/lang/String;", "setDbName", "(Ljava/lang/String;)V", "getLogger", "()Lcom/ustadmobile/libcache/logging/UstadCacheLogger;", "setLogger", "(Lcom/ustadmobile/libcache/logging/UstadCacheLogger;)V", "getSizeLimit", "()Lkotlin/jvm/functions/Function0;", "setSizeLimit", "(Lkotlin/jvm/functions/Function0;)V", "getStoragePath", "()Lkotlinx/io/files/Path;", "setStoragePath", "(Lkotlinx/io/files/Path;)V", "build", "Lcom/ustadmobile/libcache/UstadCache;", "Companion", "lib-cache_release"})
public final class UstadCacheBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Context appContext;
    @NotNull
    private Path storagePath;
    @NotNull
    private String dbName;
    @Nullable
    private UstadCacheLogger logger;
    @NotNull
    private Function0<Long> sizeLimit;
    @NotNull
    private CachePathsProvider cachePathsProvider;
    @NotNull
    public static final String DEFAULT_SUBPATH_WORK = "tmpwork";
    @NotNull
    public static final String DEFAULT_SUBPATH_PERSISTENT = "persistent";
    @NotNull
    public static final String DEFAULT_SUBPATH_CACHE = "ustad-cache";

    public UstadCacheBuilder(@NotNull Context appContext, @NotNull Path storagePath, @NotNull String dbName, @Nullable UstadCacheLogger logger, @NotNull Function0<Long> sizeLimit, @NotNull CachePathsProvider cachePathsProvider) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        Intrinsics.checkNotNullParameter(sizeLimit, (String)"sizeLimit");
        Intrinsics.checkNotNullParameter((Object)cachePathsProvider, (String)"cachePathsProvider");
        this.appContext = appContext;
        this.storagePath = storagePath;
        this.dbName = dbName;
        this.logger = logger;
        this.sizeLimit = sizeLimit;
        this.cachePathsProvider = cachePathsProvider;
    }

    public /* synthetic */ UstadCacheBuilder(Context context, Path path, String string, UstadCacheLogger ustadCacheLogger, Function0 function0, CachePathsProvider cachePathsProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "UstadCache";
        }
        if ((n & 8) != 0) {
            ustadCacheLogger = null;
        }
        if ((n & 0x20) != 0) {
            cachePathsProvider = () -> UstadCacheBuilder._init_$lambda$0(path, context);
        }
        this(context, path, string, ustadCacheLogger, (Function0<Long>)function0, cachePathsProvider);
    }

    @NotNull
    public final Context getAppContext() {
        return this.appContext;
    }

    public final void setAppContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.appContext = context;
    }

    @NotNull
    public final Path getStoragePath() {
        return this.storagePath;
    }

    public final void setStoragePath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.storagePath = path;
    }

    @NotNull
    public final String getDbName() {
        return this.dbName;
    }

    public final void setDbName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dbName = string;
    }

    @Nullable
    public final UstadCacheLogger getLogger() {
        return this.logger;
    }

    public final void setLogger(@Nullable UstadCacheLogger ustadCacheLogger) {
        this.logger = ustadCacheLogger;
    }

    @NotNull
    public final Function0<Long> getSizeLimit() {
        return this.sizeLimit;
    }

    public final void setSizeLimit(@NotNull Function0<Long> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.sizeLimit = function0;
    }

    @NotNull
    public final CachePathsProvider getCachePathsProvider() {
        return this.cachePathsProvider;
    }

    public final void setCachePathsProvider(@NotNull CachePathsProvider cachePathsProvider) {
        Intrinsics.checkNotNullParameter((Object)cachePathsProvider, (String)"<set-?>");
        this.cachePathsProvider = cachePathsProvider;
    }

    @NotNull
    public final UstadCache build() {
        FileSystem fileSystem = FileSystemJvmKt.SystemFileSystem;
        CachePathsProvider cachePathsProvider = this.cachePathsProvider;
        UstadCacheLogger ustadCacheLogger = this.logger;
        Function0<Long> function0 = this.sizeLimit;
        DoorMigration[] doorMigrationArray = new DoorMigration[]{CacheDbMigration8_9Kt.getMIGRATE_8_9()};
        UstadCacheDb ustadCacheDb = (UstadCacheDb)CacheDbMigrationsKt.addCacheDbMigrations((DatabaseBuilder<UstadCacheDb>)DatabaseBuilder.Companion.databaseBuilder(this.appContext, Reflection.getOrCreateKotlinClass(UstadCacheDb.class), this.dbName, 1L)).addMigrations(doorMigrationArray).build();
        return new UstadCacheImpl(fileSystem, null, cachePathsProvider, ustadCacheDb, function0, ustadCacheLogger, null, 0, 0, null, null, null, 4034, null);
    }

    private static final CachePaths _init_$lambda$0(Path $storagePath, Context $appContext) {
        Intrinsics.checkNotNullParameter((Object)$storagePath, (String)"$storagePath");
        Intrinsics.checkNotNullParameter((Object)$appContext, (String)"$appContext");
        String[] stringArray = new String[]{DEFAULT_SUBPATH_WORK};
        Path path = PathsKt.Path((Path)$storagePath, (String[])stringArray);
        stringArray = new String[]{DEFAULT_SUBPATH_PERSISTENT};
        Path path2 = PathsKt.Path((Path)$storagePath, (String[])stringArray);
        String string = $appContext.getCacheDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        stringArray = new String[]{DEFAULT_SUBPATH_CACHE};
        return new CachePaths(path, path2, PathsKt.Path((String)string, (String[])stringArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/libcache/UstadCacheBuilder$Companion;", "", "()V", "DEFAULT_SUBPATH_CACHE", "", "DEFAULT_SUBPATH_PERSISTENT", "DEFAULT_SUBPATH_WORK", "lib-cache_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

