/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.libcache.db.dao.CacheEntryDao;
import com.ustadmobile.libcache.db.entities.CacheEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.coroutines.Continuation;

public final class CacheEntryDao_Impl
extends CacheEntryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CacheEntry> __insertionAdapterOfCacheEntry;
    private final EntityInsertionAdapter<CacheEntry> __insertionAdapterOfCacheEntry_1;
    private final EntityDeletionOrUpdateAdapter<CacheEntry> __deletionAdapterOfCacheEntry;
    private final EntityDeletionOrUpdateAdapter<CacheEntry> __updateAdapterOfCacheEntry;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLastAccessedTime;
    private final SharedSQLiteStatement __preparedStmtOfUpdateValidation;

    public CacheEntryDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCacheEntry = new EntityInsertionAdapter<CacheEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `CacheEntry` (`key`,`url`,`message`,`statusCode`,`cacheFlags`,`method`,`lastAccessed`,`lastValidated`,`integrity`,`responseHeaders`,`storageUri`,`storageSize`,`uncompressedSize`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CacheEntry entity) {
                statement.bindString(1, entity.getKey());
                statement.bindString(2, entity.getUrl());
                statement.bindString(3, entity.getMessage());
                statement.bindLong(4, (long)entity.getStatusCode());
                statement.bindLong(5, (long)entity.getCacheFlags());
                statement.bindLong(6, (long)entity.getMethod());
                statement.bindLong(7, entity.getLastAccessed());
                statement.bindLong(8, entity.getLastValidated());
                if (entity.getIntegrity() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getIntegrity());
                }
                statement.bindString(10, entity.getResponseHeaders());
                statement.bindString(11, entity.getStorageUri());
                statement.bindLong(12, entity.getStorageSize());
                statement.bindLong(13, entity.getUncompressedSize());
            }
        };
        this.__insertionAdapterOfCacheEntry_1 = new EntityInsertionAdapter<CacheEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `CacheEntry` (`key`,`url`,`message`,`statusCode`,`cacheFlags`,`method`,`lastAccessed`,`lastValidated`,`integrity`,`responseHeaders`,`storageUri`,`storageSize`,`uncompressedSize`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CacheEntry entity) {
                statement.bindString(1, entity.getKey());
                statement.bindString(2, entity.getUrl());
                statement.bindString(3, entity.getMessage());
                statement.bindLong(4, (long)entity.getStatusCode());
                statement.bindLong(5, (long)entity.getCacheFlags());
                statement.bindLong(6, (long)entity.getMethod());
                statement.bindLong(7, entity.getLastAccessed());
                statement.bindLong(8, entity.getLastValidated());
                if (entity.getIntegrity() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getIntegrity());
                }
                statement.bindString(10, entity.getResponseHeaders());
                statement.bindString(11, entity.getStorageUri());
                statement.bindLong(12, entity.getStorageSize());
                statement.bindLong(13, entity.getUncompressedSize());
            }
        };
        this.__deletionAdapterOfCacheEntry = new EntityDeletionOrUpdateAdapter<CacheEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `CacheEntry` WHERE `key` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CacheEntry entity) {
                statement.bindString(1, entity.getKey());
            }
        };
        this.__updateAdapterOfCacheEntry = new EntityDeletionOrUpdateAdapter<CacheEntry>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `CacheEntry` SET `key` = ?,`url` = ?,`message` = ?,`statusCode` = ?,`cacheFlags` = ?,`method` = ?,`lastAccessed` = ?,`lastValidated` = ?,`integrity` = ?,`responseHeaders` = ?,`storageUri` = ?,`storageSize` = ?,`uncompressedSize` = ? WHERE `key` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull CacheEntry entity) {
                statement.bindString(1, entity.getKey());
                statement.bindString(2, entity.getUrl());
                statement.bindString(3, entity.getMessage());
                statement.bindLong(4, (long)entity.getStatusCode());
                statement.bindLong(5, (long)entity.getCacheFlags());
                statement.bindLong(6, (long)entity.getMethod());
                statement.bindLong(7, entity.getLastAccessed());
                statement.bindLong(8, entity.getLastValidated());
                if (entity.getIntegrity() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindString(9, entity.getIntegrity());
                }
                statement.bindString(10, entity.getResponseHeaders());
                statement.bindString(11, entity.getStorageUri());
                statement.bindLong(12, entity.getStorageSize());
                statement.bindLong(13, entity.getUncompressedSize());
                statement.bindString(14, entity.getKey());
            }
        };
        this.__preparedStmtOfUpdateLastAccessedTime = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE CacheEntry\n           SET lastAccessed = ?\n         WHERE key = ?  \n    ";
                return "\n        UPDATE CacheEntry\n           SET lastAccessed = ?\n         WHERE key = ?  \n    ";
            }
        };
        this.__preparedStmtOfUpdateValidation = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        UPDATE CacheEntry\n           SET responseHeaders = ?,\n               lastValidated = ?,\n               lastAccessed = ?\n         WHERE key = ?      \n    ";
                return "\n        UPDATE CacheEntry\n           SET responseHeaders = ?,\n               lastValidated = ?,\n               lastAccessed = ?\n         WHERE key = ?      \n    ";
            }
        };
    }

    @Override
    public Object insertAsync(final CacheEntry entry, Continuation<? super Long> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            @Override
            @NonNull
            public Long call() throws Exception {
                CacheEntryDao_Impl.this.__db.beginTransaction();
                try {
                    Long _result = CacheEntryDao_Impl.this.__insertionAdapterOfCacheEntry.insertAndReturnId((Object)entry);
                    CacheEntryDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result;
                    return l;
                }
                finally {
                    CacheEntryDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public void insertList(List<CacheEntry> entry) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCacheEntry.insert(entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void upsertList(List<CacheEntry> entry) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCacheEntry_1.insert(entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<CacheEntry> entries) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCacheEntry.handleMultiple(entries);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateList(List<CacheEntry> entry) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCacheEntry.handleMultiple(entry);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastAccessedTime(String key, long lastAccessTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLastAccessedTime.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, lastAccessTime);
        _argIndex = 2;
        _stmt.bindString(_argIndex, key);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateLastAccessedTime.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValidation(String key, String headers2, long lastValidated, long lastAccessed) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateValidation.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, headers2);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, lastValidated);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, lastAccessed);
        _argIndex = 4;
        _stmt.bindString(_argIndex, key);
        try {
            this.__db.beginTransaction();
            try {
                _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
            }
            finally {
                this.__db.endTransaction();
            }
        }
        finally {
            this.__preparedStmtOfUpdateValidation.release(_stmt);
        }
    }

    @Override
    public Object findByUrlAsync(String url, Continuation<? super CacheEntry> $completion) {
        String _sql = "\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.url = ? \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.url = ? \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, url);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<CacheEntry>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public CacheEntry call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CacheEntryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    CacheEntry _result;
                    int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"key");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
                    int _cursorIndexOfStatusCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statusCode");
                    int _cursorIndexOfCacheFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cacheFlags");
                    int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
                    int _cursorIndexOfLastAccessed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastAccessed");
                    int _cursorIndexOfLastValidated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastValidated");
                    int _cursorIndexOfIntegrity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"integrity");
                    int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
                    int _cursorIndexOfStorageUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storageUri");
                    int _cursorIndexOfStorageSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storageSize");
                    int _cursorIndexOfUncompressedSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uncompressedSize");
                    if (_cursor.moveToFirst()) {
                        String _tmpKey = _cursor.getString(_cursorIndexOfKey);
                        String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                        String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                        int _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
                        int _tmpCacheFlags = _cursor.getInt(_cursorIndexOfCacheFlags);
                        int _tmpMethod = _cursor.getInt(_cursorIndexOfMethod);
                        long _tmpLastAccessed = _cursor.getLong(_cursorIndexOfLastAccessed);
                        long _tmpLastValidated = _cursor.getLong(_cursorIndexOfLastValidated);
                        String _tmpIntegrity = _cursor.isNull(_cursorIndexOfIntegrity) ? null : _cursor.getString(_cursorIndexOfIntegrity);
                        String _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
                        String _tmpStorageUri = _cursor.getString(_cursorIndexOfStorageUri);
                        long _tmpStorageSize = _cursor.getLong(_cursorIndexOfStorageSize);
                        long _tmpUncompressedSize = _cursor.getLong(_cursorIndexOfUncompressedSize);
                        _result = new CacheEntry(_tmpKey, _tmpUrl, _tmpMessage, _tmpStatusCode, _tmpCacheFlags, _tmpMethod, _tmpLastAccessed, _tmpLastValidated, _tmpIntegrity, _tmpResponseHeaders, _tmpStorageUri, _tmpStorageSize, _tmpUncompressedSize);
                    } else {
                        _result = null;
                    }
                    CacheEntry cacheEntry = _result;
                    return cacheEntry;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry findEntryAndBodyByKey(String key) {
        String _sql = "\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.key = ?\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.key = ?\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, key);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            CacheEntry _result;
            int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"key");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
            int _cursorIndexOfStatusCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statusCode");
            int _cursorIndexOfCacheFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cacheFlags");
            int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
            int _cursorIndexOfLastAccessed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastAccessed");
            int _cursorIndexOfLastValidated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastValidated");
            int _cursorIndexOfIntegrity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"integrity");
            int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
            int _cursorIndexOfStorageUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storageUri");
            int _cursorIndexOfStorageSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storageSize");
            int _cursorIndexOfUncompressedSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uncompressedSize");
            if (_cursor.moveToFirst()) {
                String _tmpKey = _cursor.getString(_cursorIndexOfKey);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                int _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
                int _tmpCacheFlags = _cursor.getInt(_cursorIndexOfCacheFlags);
                int _tmpMethod = _cursor.getInt(_cursorIndexOfMethod);
                long _tmpLastAccessed = _cursor.getLong(_cursorIndexOfLastAccessed);
                long _tmpLastValidated = _cursor.getLong(_cursorIndexOfLastValidated);
                String _tmpIntegrity = _cursor.isNull(_cursorIndexOfIntegrity) ? null : _cursor.getString(_cursorIndexOfIntegrity);
                String _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
                String _tmpStorageUri = _cursor.getString(_cursorIndexOfStorageUri);
                long _tmpStorageSize = _cursor.getLong(_cursorIndexOfStorageSize);
                long _tmpUncompressedSize = _cursor.getLong(_cursorIndexOfUncompressedSize);
                _result = new CacheEntry(_tmpKey, _tmpUrl, _tmpMessage, _tmpStatusCode, _tmpCacheFlags, _tmpMethod, _tmpLastAccessed, _tmpLastValidated, _tmpIntegrity, _tmpResponseHeaders, _tmpStorageUri, _tmpStorageSize, _tmpUncompressedSize);
            } else {
                _result = null;
            }
            CacheEntry cacheEntry = _result;
            return cacheEntry;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CacheEntry> findByRequestBatchId(int batchId) {
        String _sql = "\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.key IN\n               (SELECT RequestedEntry.requestedKey\n                  FROM RequestedEntry\n                 WHERE RequestedEntry.batchId = ?)\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE CacheEntry.key IN\n               (SELECT RequestedEntry.requestedKey\n                  FROM RequestedEntry\n                 WHERE RequestedEntry.batchId = ?)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)batchId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"key");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
            int _cursorIndexOfStatusCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statusCode");
            int _cursorIndexOfCacheFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cacheFlags");
            int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
            int _cursorIndexOfLastAccessed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastAccessed");
            int _cursorIndexOfLastValidated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastValidated");
            int _cursorIndexOfIntegrity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"integrity");
            int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
            int _cursorIndexOfStorageUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storageUri");
            int _cursorIndexOfStorageSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storageSize");
            int _cursorIndexOfUncompressedSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uncompressedSize");
            ArrayList<CacheEntry> _result = new ArrayList<CacheEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_cursorIndexOfKey);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                int _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
                int _tmpCacheFlags = _cursor.getInt(_cursorIndexOfCacheFlags);
                int _tmpMethod = _cursor.getInt(_cursorIndexOfMethod);
                long _tmpLastAccessed = _cursor.getLong(_cursorIndexOfLastAccessed);
                long _tmpLastValidated = _cursor.getLong(_cursorIndexOfLastValidated);
                String _tmpIntegrity = _cursor.isNull(_cursorIndexOfIntegrity) ? null : _cursor.getString(_cursorIndexOfIntegrity);
                String _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
                String _tmpStorageUri = _cursor.getString(_cursorIndexOfStorageUri);
                long _tmpStorageSize = _cursor.getLong(_cursorIndexOfStorageSize);
                long _tmpUncompressedSize = _cursor.getLong(_cursorIndexOfUncompressedSize);
                CacheEntry _item = new CacheEntry(_tmpKey, _tmpUrl, _tmpMessage, _tmpStatusCode, _tmpCacheFlags, _tmpMethod, _tmpLastAccessed, _tmpLastValidated, _tmpIntegrity, _tmpResponseHeaders, _tmpStorageUri, _tmpStorageSize, _tmpUncompressedSize);
                _result.add(_item);
            }
            ArrayList<CacheEntry> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findEntriesWithLock(int batchId) {
        String _sql = "\n        SELECT RequestedEntry.requestedKey\n          FROM RequestedEntry\n         WHERE RequestedEntry.batchId = ?\n           AND EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = RequestedEntry.requestedKey)\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT RequestedEntry.requestedKey\n          FROM RequestedEntry\n         WHERE RequestedEntry.batchId = ?\n           AND EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = RequestedEntry.requestedKey)\n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)batchId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CacheEntry> findEvictableEntries(int batchSize) {
        String _sql = "\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE NOT EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = CacheEntry.key) \n      ORDER BY lastAccessed ASC           \n         LIMIT ?       \n      \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT CacheEntry.*\n          FROM CacheEntry\n         WHERE NOT EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = CacheEntry.key) \n      ORDER BY lastAccessed ASC           \n         LIMIT ?       \n      \n    ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)batchSize);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"key");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
            int _cursorIndexOfStatusCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"statusCode");
            int _cursorIndexOfCacheFlags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cacheFlags");
            int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
            int _cursorIndexOfLastAccessed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastAccessed");
            int _cursorIndexOfLastValidated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastValidated");
            int _cursorIndexOfIntegrity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"integrity");
            int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
            int _cursorIndexOfStorageUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storageUri");
            int _cursorIndexOfStorageSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"storageSize");
            int _cursorIndexOfUncompressedSize = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uncompressedSize");
            ArrayList<CacheEntry> _result = new ArrayList<CacheEntry>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpKey = _cursor.getString(_cursorIndexOfKey);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                int _tmpStatusCode = _cursor.getInt(_cursorIndexOfStatusCode);
                int _tmpCacheFlags = _cursor.getInt(_cursorIndexOfCacheFlags);
                int _tmpMethod = _cursor.getInt(_cursorIndexOfMethod);
                long _tmpLastAccessed = _cursor.getLong(_cursorIndexOfLastAccessed);
                long _tmpLastValidated = _cursor.getLong(_cursorIndexOfLastValidated);
                String _tmpIntegrity = _cursor.isNull(_cursorIndexOfIntegrity) ? null : _cursor.getString(_cursorIndexOfIntegrity);
                String _tmpResponseHeaders = _cursor.getString(_cursorIndexOfResponseHeaders);
                String _tmpStorageUri = _cursor.getString(_cursorIndexOfStorageUri);
                long _tmpStorageSize = _cursor.getLong(_cursorIndexOfStorageSize);
                long _tmpUncompressedSize = _cursor.getLong(_cursorIndexOfUncompressedSize);
                CacheEntry _item = new CacheEntry(_tmpKey, _tmpUrl, _tmpMessage, _tmpStatusCode, _tmpCacheFlags, _tmpMethod, _tmpLastAccessed, _tmpLastValidated, _tmpIntegrity, _tmpResponseHeaders, _tmpStorageUri, _tmpStorageSize, _tmpUncompressedSize);
                _result.add(_item);
            }
            ArrayList<CacheEntry> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long totalEvictableSize() {
        String _sql = "\n        SELECT SUM(CacheEntry.storageSize)\n          FROM CacheEntry\n         WHERE NOT EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = CacheEntry.key)  \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT SUM(CacheEntry.storageSize)\n          FROM CacheEntry\n         WHERE NOT EXISTS(\n               SELECT RetentionLock.lockId\n                 FROM RetentionLock\n                WHERE RetentionLock.lockKey = CacheEntry.key)  \n    ", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            long _result = _cursor.moveToFirst() ? _cursor.getLong(0) : 0L;
            long l = _result;
            return l;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

