/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.partial;

import com.ustadmobile.libcache.partial.RangeRequestNotSatisfiableException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/ustadmobile/libcache/partial/ContentRange;", "", "fromByte", "", "toByte", "totalBytes", "contentLength", "(JJJJ)V", "getContentLength", "()J", "contentRangeResponseHeader", "", "getContentRangeResponseHeader", "()Ljava/lang/String;", "getFromByte", "getToByte", "getTotalBytes", "Companion", "lib-cache_debug"})
public final class ContentRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long fromByte;
    private final long toByte;
    private final long totalBytes;
    private final long contentLength;

    public ContentRange(long fromByte, long toByte, long totalBytes, long contentLength) {
        this.fromByte = fromByte;
        this.toByte = toByte;
        this.totalBytes = totalBytes;
        this.contentLength = contentLength;
    }

    public final long getFromByte() {
        return this.fromByte;
    }

    public final long getToByte() {
        return this.toByte;
    }

    public final long getTotalBytes() {
        return this.totalBytes;
    }

    public final long getContentLength() {
        return this.contentLength;
    }

    @NotNull
    public final String getContentRangeResponseHeader() {
        return "bytes " + this.fromByte + "-" + this.toByte + "/" + this.totalBytes;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/libcache/partial/ContentRange$Companion;", "", "()V", "parseRangeHeader", "Lcom/ustadmobile/libcache/partial/ContentRange;", "header", "", "totalContentLength", "", "lib-cache_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContentRange parseRangeHeader(@NotNull String header, long totalContentLength) {
            ContentRange contentRange;
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            String headerTrimmed = ((Object)StringsKt.trim((CharSequence)header)).toString();
            if (StringsKt.indexOf$default((CharSequence)headerTrimmed, (String)",", (int)0, (boolean)false, (int)6, null) != -1) {
                throw new RangeRequestNotSatisfiableException("Multiple content-ranges are not supported");
            }
            int equalsPos = StringsKt.indexOf$default((CharSequence)headerTrimmed, (String)"=", (int)0, (boolean)false, (int)6, null);
            if (equalsPos < 0) {
                throw new IllegalArgumentException("Malformed Content-Range: must have unit followed = eg. bytes=");
            }
            String string = headerTrimmed.substring(0, equalsPos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String unit = string;
            if (!Intrinsics.areEqual((Object)unit, (Object)"bytes")) {
                throw new RangeRequestNotSatisfiableException("Content-Range: only supported unit is: bytes, " + unit + " is not supported");
            }
            int dashIndex = StringsKt.indexOf$default((CharSequence)headerTrimmed, (String)"-", (int)0, (boolean)false, (int)6, null);
            String string2 = headerTrimmed.substring(equalsPos + 1, dashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String it = string2;
            boolean bl = false;
            long firstBytePos = !StringsKt.isBlank((CharSequence)it) ? Long.parseLong(it) : -1L;
            String string3 = headerTrimmed.substring(dashIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String it2 = string3;
            boolean bl2 = false;
            long lastBytePos = !StringsKt.isBlank((CharSequence)it2) ? Long.parseLong(it2) : -1L;
            if (lastBytePos >= 0L && firstBytePos == -1L) {
                contentRange = new ContentRange(totalContentLength - lastBytePos + 1L, totalContentLength, totalContentLength, lastBytePos);
            } else {
                long lastByte;
                long l = lastByte = lastBytePos == -1L ? totalContentLength - 1L : lastBytePos;
                if (lastByte < firstBytePos) {
                    throw new RangeRequestNotSatisfiableException("Cannot satisfy range: last byte " + lastByte + " is before first byte " + firstBytePos);
                }
                if (lastBytePos >= totalContentLength) {
                    throw new RangeRequestNotSatisfiableException("Cannot satisfy range: last byte is " + lastByte + ", but totalSize is " + totalContentLength);
                }
                contentRange = new ContentRange(firstBytePos, lastByte, totalContentLength, lastByte - firstBytePos + 1L);
            }
            return contentRange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

