package com.ustadmobile.libcache.db

import com.ustadmobile.door.ext.DoorDatabaseMetadata
import com.ustadmobile.door.replication.ReplicationEntityMetaData
import kotlin.Boolean
import kotlin.Int
import kotlin.LazyThreadSafetyMode
import kotlin.String
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.reflect.KClass

public class UstadCacheDb_DoorMetadata : DoorDatabaseMetadata<UstadCacheDb>() {
  override val dbClass: KClass<UstadCacheDb>
    get() = UstadCacheDb::class

  override val hasReadOnlyWrapper: Boolean
    get() = false

  override val version: Int
    get() = 9

  override val allTables: List<String> = listOf("CacheEntry", "RequestedEntry", "RetentionLock")


  override val replicateEntities: Map<Int, ReplicationEntityMetaData> by
      lazy(LazyThreadSafetyMode.NONE) {
        mapOf<Int, ReplicationEntityMetaData>(
        )
      }

}
