/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import com.ustadmobile.lib.db.composites.EnrolmentRequestAndCoursePic;
import com.ustadmobile.lib.db.composites.EnrolmentRequestAndPersonDetails;
import com.ustadmobile.lib.db.entities.EnrolmentRequest;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u00a7@\u00a2\u0006\u0002\u0010\u000bJ<\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH'J$\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00040\u00152\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH'J\u001e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u0010\u001dJ&\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"Lcom/ustadmobile/core/db/dao/EnrolmentRequestDao;", "", "()V", "findByClazzAndPerson", "", "Lcom/ustadmobile/lib/db/entities/EnrolmentRequest;", "personUid", "", "clazzUid", "statusFilter", "", "(JJILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findPendingEnrolmentsForCourse", "Landroidx/paging/PagingSource;", "Lcom/ustadmobile/lib/db/composites/EnrolmentRequestAndPersonDetails;", "includeDeleted", "", "searchText", "", "sortOrder", "findRequestsForUserAsFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/ustadmobile/lib/db/composites/EnrolmentRequestAndCoursePic;", "accountPersonUid", "hasPendingRequests", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insert", "", "enrolmentRequest", "(Lcom/ustadmobile/lib/db/entities/EnrolmentRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateStatus", "uid", "status", "updateTime", "(JIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database_debug"})
@Dao
public abstract class EnrolmentRequestDao {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insert(@NotNull EnrolmentRequest var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="\n        SELECT EnrolmentRequest.*\n          FROM EnrolmentRequest\n         WHERE EnrolmentRequest.erPersonUid = :personUid\n           AND EnrolmentRequest.erClazzUid = :clazzUid\n           AND (:statusFilter = 0 OR EnrolmentRequest.erStatus = :statusFilter)\n    ")
    @Nullable
    public abstract Object findByClazzAndPerson(long var1, long var3, int var5, @NotNull Continuation<? super List<EnrolmentRequest>> var6);

    @Query(value="\n        SELECT EXISTS(\n               SELECT EnrolmentRequest.erUid\n                 FROM EnrolmentRequest\n                WHERE EnrolmentRequest.erPersonUid = :personUid\n                  AND EnrolmentRequest.erClazzUid = :clazzUid\n                  AND EnrolmentRequest.erStatus = 1)\n    ")
    @Nullable
    public abstract Object hasPendingRequests(long var1, long var3, @NotNull Continuation<? super Boolean> var5);

    @Query(value="\n        SELECT EnrolmentRequest.*, CoursePicture.*\n          FROM EnrolmentRequest\n               LEFT JOIN CoursePicture\n                         ON CoursePicture.coursePictureUid = EnrolmentRequest.erClazzUid\n         WHERE EnrolmentRequest.erPersonUid = :accountPersonUid \n           AND (:statusFilter = 0 OR EnrolmentRequest.erStatus = :statusFilter)\n    ")
    @NotNull
    public abstract Flow<List<EnrolmentRequestAndCoursePic>> findRequestsForUserAsFlow(long var1, int var3);

    @Query(value="\n        UPDATE EnrolmentRequest\n           SET erStatus = :status,\n               erLastModified = :updateTime\n         WHERE erUid = :uid      \n    ")
    @Nullable
    public abstract Object updateStatus(long var1, int var3, long var4, @NotNull Continuation<? super Unit> var6);

    @Query(value="\n        SELECT EnrolmentRequest.*, PersonPicture.*, Person.*\n          FROM EnrolmentRequest\n               JOIN Person\n                    ON Person.personUid = EnrolmentRequest.erPersonUid\n               LEFT JOIN PersonPicture\n                         ON PersonPicture.personPictureUid = EnrolmentRequest.erPersonUid\n         WHERE EnrolmentRequest.erClazzUid = :clazzUid\n           AND (:statusFilter = 0 OR EnrolmentRequest.erStatus = :statusFilter)\n           AND (CAST(:includeDeleted AS INTEGER) = 1 OR NOT EnrolmentRequest.erDeleted)\n           AND (:searchText = '%' OR EnrolmentRequest.erPersonFullname LIKE :searchText)\n      ORDER BY CASE(:sortOrder)\n                WHEN 1 THEN EnrolmentRequest.erPersonFullname\n                WHEN 3 THEN EnrolmentRequest.erPersonFullname\n                ELSE ''\n                END ASC,\n                CASE(:sortOrder)\n                WHEN 2 THEN EnrolmentRequest.erPersonFullname\n                WHEN 4 THEN EnrolmentRequest.erPersonFullname\n                ELSE ''\n            END DESC,\n            CASE(:sortOrder)\n                WHEN 7 THEN EnrolmentRequest.erRequestTime\n                ELSE 0\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 8 THEN EnrolmentRequest.erRequestTime\n                ELSE 0\n            END DESC     \n    ")
    @NotNull
    public abstract PagingSource<Integer, EnrolmentRequestAndPersonDetails> findPendingEnrolmentsForCourse(long var1, boolean var3, int var4, @NotNull String var5, int var6);
}

