/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.xapi.StatementEntityJsonDao;
import com.ustadmobile.lib.db.entities.xapi.StatementEntityJson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class StatementEntityJsonDao_Impl
extends StatementEntityJsonDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<StatementEntityJson> __insertionAdapterOfStatementEntityJson;

    public StatementEntityJsonDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfStatementEntityJson = new EntityInsertionAdapter<StatementEntityJson>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `StatementEntityJson` (`stmtJsonIdHi`,`stmtJsonIdLo`,`stmtEtag`,`fullStatement`) VALUES (?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull StatementEntityJson entity) {
                statement.bindLong(1, entity.getStmtJsonIdHi());
                statement.bindLong(2, entity.getStmtJsonIdLo());
                statement.bindLong(3, entity.getStmtEtag());
                if (entity.getFullStatement() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getFullStatement());
                }
            }
        };
    }

    @Override
    public Object insertOrIgnoreListAsync(final List<StatementEntityJson> entityList, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                StatementEntityJsonDao_Impl.this.__db.beginTransaction();
                try {
                    StatementEntityJsonDao_Impl.this.__insertionAdapterOfStatementEntityJson.insert((Iterable)entityList);
                    StatementEntityJsonDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    StatementEntityJsonDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public Object getStatements(long stmtJsonIdHi, long stmtJsonIdLo, Continuation<? super List<StatementEntityJson>> $completion) {
        String _sql = "\n        SELECT StatementEntityJson.*\n          FROM StatementEntityJson\n         WHERE (    (? = 0 AND ? = 0) \n                 OR (stmtJsonIdHi = ? AND stmtJsonIdLo = ?))\n                  \n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT StatementEntityJson.*\n          FROM StatementEntityJson\n         WHERE (    (? = 0 AND ? = 0) \n                 OR (stmtJsonIdHi = ? AND stmtJsonIdLo = ?))\n                  \n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, stmtJsonIdHi);
        _argIndex = 2;
        _statement.bindLong(_argIndex, stmtJsonIdLo);
        _argIndex = 3;
        _statement.bindLong(_argIndex, stmtJsonIdHi);
        _argIndex = 4;
        _statement.bindLong(_argIndex, stmtJsonIdLo);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<StatementEntityJson>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<StatementEntityJson> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)StatementEntityJsonDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfStmtJsonIdHi = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stmtJsonIdHi");
                    int _cursorIndexOfStmtJsonIdLo = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stmtJsonIdLo");
                    int _cursorIndexOfStmtEtag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"stmtEtag");
                    int _cursorIndexOfFullStatement = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"fullStatement");
                    ArrayList<StatementEntityJson> _result2 = new ArrayList<StatementEntityJson>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpStmtJsonIdHi = _cursor.getLong(_cursorIndexOfStmtJsonIdHi);
                        long _tmpStmtJsonIdLo = _cursor.getLong(_cursorIndexOfStmtJsonIdLo);
                        long _tmpStmtEtag = _cursor.getLong(_cursorIndexOfStmtEtag);
                        String _tmpFullStatement = _cursor.isNull(_cursorIndexOfFullStatement) ? null : _cursor.getString(_cursorIndexOfFullStatement);
                        StatementEntityJson _item = new StatementEntityJson(_tmpStmtJsonIdHi, _tmpStmtJsonIdLo, _tmpStmtEtag, _tmpFullStatement);
                        _result2.add(_item);
                    }
                    ArrayList<StatementEntityJson> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

