/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.DeletedItemDao;
import com.ustadmobile.lib.db.entities.DeletedItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class DeletedItemDao_Impl
extends DeletedItemDao {
    private final RoomDatabase __db;
    private final SharedSQLiteStatement __preparedStmtOfInsertDeletedItemForContentEntryParentChildJoin;

    public DeletedItemDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__preparedStmtOfInsertDeletedItemForContentEntryParentChildJoin = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "\n        INSERT INTO DeletedItem(delItemName, delItemIconUri, delItemLastModTime, delItemTimeDeleted, delItemEntityTable, delItemEntityUid, delItemDeletedByPersonUid, delItemStatus, delItemIsFolder)\n        SELECT (SELECT ContentEntry.title\n                  FROM ContentEntry\n                 WHERE ContentEntry.contentEntryUid = \n                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n                          FROM ContentEntryParentChildJoin\n                         WHERE ContentEntryParentChildJoin.cepcjUid = ?)) AS delItemName,\n               NULL as delItemIconUri,\n               ? AS delItemLastModTime,\n               ? AS delItemTimeDeleted,\n               7 AS delItemEntityTable,\n               ? AS delItemEntityUid,\n               ? AS delItemDeletedByPersonUid,\n               1 AS delItemStatus,\n               (SELECT NOT ContentEntry.leaf\n                  FROM ContentEntry\n                 WHERE ContentEntry.contentEntryUid = \n                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n                          FROM ContentEntryParentChildJoin\n                         WHERE ContentEntryParentChildJoin.cepcjUid = ?)) AS delItemIsFolder\n    ";
                return "\n        INSERT INTO DeletedItem(delItemName, delItemIconUri, delItemLastModTime, delItemTimeDeleted, delItemEntityTable, delItemEntityUid, delItemDeletedByPersonUid, delItemStatus, delItemIsFolder)\n        SELECT (SELECT ContentEntry.title\n                  FROM ContentEntry\n                 WHERE ContentEntry.contentEntryUid = \n                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n                          FROM ContentEntryParentChildJoin\n                         WHERE ContentEntryParentChildJoin.cepcjUid = ?)) AS delItemName,\n               NULL as delItemIconUri,\n               ? AS delItemLastModTime,\n               ? AS delItemTimeDeleted,\n               7 AS delItemEntityTable,\n               ? AS delItemEntityUid,\n               ? AS delItemDeletedByPersonUid,\n               1 AS delItemStatus,\n               (SELECT NOT ContentEntry.leaf\n                  FROM ContentEntry\n                 WHERE ContentEntry.contentEntryUid = \n                       (SELECT ContentEntryParentChildJoin.cepcjChildContentEntryUid\n                          FROM ContentEntryParentChildJoin\n                         WHERE ContentEntryParentChildJoin.cepcjUid = ?)) AS delItemIsFolder\n    ";
            }
        };
    }

    @Override
    public Object insertDeletedItemForContentEntryParentChildJoin(final long cepcjUid, final long time, final long deletedByPersonUid, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = DeletedItemDao_Impl.this.__preparedStmtOfInsertDeletedItemForContentEntryParentChildJoin.acquire();
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, cepcjUid);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, time);
                _argIndex = 3;
                _stmt.bindLong(_argIndex, time);
                _argIndex = 4;
                _stmt.bindLong(_argIndex, cepcjUid);
                _argIndex = 5;
                _stmt.bindLong(_argIndex, deletedByPersonUid);
                _argIndex = 6;
                _stmt.bindLong(_argIndex, cepcjUid);
                try {
                    Unit unit;
                    DeletedItemDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeInsert();
                        DeletedItemDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        DeletedItemDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    DeletedItemDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    DeletedItemDao_Impl.this.__preparedStmtOfInsertDeletedItemForContentEntryParentChildJoin.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object findByTableIdAndEntityUid(int tableId, long entityUid, Continuation<? super List<DeletedItem>> $completion) {
        String _sql = "\n        SELECT DeletedItem.*\n          FROM DeletedItem\n         WHERE DeletedItem.delItemEntityTable = ?\n           AND DeletedItem.delItemEntityUid = ?\n    ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT DeletedItem.*\n          FROM DeletedItem\n         WHERE DeletedItem.delItemEntityTable = ?\n           AND DeletedItem.delItemEntityUid = ?\n    ", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)tableId);
        _argIndex = 2;
        _statement.bindLong(_argIndex, entityUid);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<DeletedItem>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<DeletedItem> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)DeletedItemDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfDelItemUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemUid");
                    int _cursorIndexOfDelItemName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemName");
                    int _cursorIndexOfDelItemIconUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemIconUri");
                    int _cursorIndexOfDelItemLastModTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemLastModTime");
                    int _cursorIndexOfDelItemTimeDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemTimeDeleted");
                    int _cursorIndexOfDelItemEntityTable = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemEntityTable");
                    int _cursorIndexOfDelItemEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemEntityUid");
                    int _cursorIndexOfDelItemDeletedByPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemDeletedByPersonUid");
                    int _cursorIndexOfDelItemStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemStatus");
                    int _cursorIndexOfDelItemIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"delItemIsFolder");
                    ArrayList<DeletedItem> _result2 = new ArrayList<DeletedItem>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpDelItemUid = _cursor.getLong(_cursorIndexOfDelItemUid);
                        String _tmpDelItemName = _cursor.isNull(_cursorIndexOfDelItemName) ? null : _cursor.getString(_cursorIndexOfDelItemName);
                        String _tmpDelItemIconUri = _cursor.isNull(_cursorIndexOfDelItemIconUri) ? null : _cursor.getString(_cursorIndexOfDelItemIconUri);
                        long _tmpDelItemLastModTime = _cursor.getLong(_cursorIndexOfDelItemLastModTime);
                        long _tmpDelItemTimeDeleted = _cursor.getLong(_cursorIndexOfDelItemTimeDeleted);
                        int _tmpDelItemEntityTable = _cursor.getInt(_cursorIndexOfDelItemEntityTable);
                        long _tmpDelItemEntityUid = _cursor.getLong(_cursorIndexOfDelItemEntityUid);
                        long _tmpDelItemDeletedByPersonUid = _cursor.getLong(_cursorIndexOfDelItemDeletedByPersonUid);
                        int _tmpDelItemStatus = _cursor.getInt(_cursorIndexOfDelItemStatus);
                        int _tmp = _cursor.getInt(_cursorIndexOfDelItemIsFolder);
                        boolean _tmpDelItemIsFolder = _tmp != 0;
                        DeletedItem _item = new DeletedItem(_tmpDelItemUid, _tmpDelItemName, _tmpDelItemIconUri, _tmpDelItemLastModTime, _tmpDelItemTimeDeleted, _tmpDelItemEntityTable, _tmpDelItemEntityUid, _tmpDelItemDeletedByPersonUid, _tmpDelItemStatus, _tmpDelItemIsFolder);
                        _result2.add(_item);
                    }
                    ArrayList<DeletedItem> arrayList = _result2;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, DeletedItem> findDeletedItemsForUser(long personUid, boolean includeActionedItems) {
        String _sql = "\n        SELECT DeletedItem.*\n          FROM DeletedItem\n         WHERE (  (CAST(? AS INTEGER) = 1)\n                OR DeletedItem.delItemStatus = 1)\n           AND DeletedItem.delItemDeletedByPersonUid = ?       \n      ORDER BY DeletedItem.delItemTimeDeleted DESC            \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT DeletedItem.*\n          FROM DeletedItem\n         WHERE (  (CAST(? AS INTEGER) = 1)\n                OR DeletedItem.delItemStatus = 1)\n           AND DeletedItem.delItemDeletedByPersonUid = ?       \n      ORDER BY DeletedItem.delItemTimeDeleted DESC            \n    ", (int)2);
        int _argIndex = 1;
        int _tmp = includeActionedItems ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        _statement.bindLong(_argIndex, personUid);
        return new LimitOffsetPagingSource<DeletedItem>(_statement, this.__db, new String[]{"DeletedItem"}){

            @NonNull
            protected List<DeletedItem> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfDelItemUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemUid");
                int _cursorIndexOfDelItemName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemName");
                int _cursorIndexOfDelItemIconUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemIconUri");
                int _cursorIndexOfDelItemLastModTime = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemLastModTime");
                int _cursorIndexOfDelItemTimeDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemTimeDeleted");
                int _cursorIndexOfDelItemEntityTable = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemEntityTable");
                int _cursorIndexOfDelItemEntityUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemEntityUid");
                int _cursorIndexOfDelItemDeletedByPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemDeletedByPersonUid");
                int _cursorIndexOfDelItemStatus = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemStatus");
                int _cursorIndexOfDelItemIsFolder = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"delItemIsFolder");
                ArrayList<DeletedItem> _result2 = new ArrayList<DeletedItem>(cursor.getCount());
                while (cursor.moveToNext()) {
                    long _tmpDelItemUid = cursor.getLong(_cursorIndexOfDelItemUid);
                    String _tmpDelItemName = cursor.isNull(_cursorIndexOfDelItemName) ? null : cursor.getString(_cursorIndexOfDelItemName);
                    String _tmpDelItemIconUri = cursor.isNull(_cursorIndexOfDelItemIconUri) ? null : cursor.getString(_cursorIndexOfDelItemIconUri);
                    long _tmpDelItemLastModTime = cursor.getLong(_cursorIndexOfDelItemLastModTime);
                    long _tmpDelItemTimeDeleted = cursor.getLong(_cursorIndexOfDelItemTimeDeleted);
                    int _tmpDelItemEntityTable = cursor.getInt(_cursorIndexOfDelItemEntityTable);
                    long _tmpDelItemEntityUid = cursor.getLong(_cursorIndexOfDelItemEntityUid);
                    long _tmpDelItemDeletedByPersonUid = cursor.getLong(_cursorIndexOfDelItemDeletedByPersonUid);
                    int _tmpDelItemStatus = cursor.getInt(_cursorIndexOfDelItemStatus);
                    int _tmp_1 = cursor.getInt(_cursorIndexOfDelItemIsFolder);
                    boolean _tmpDelItemIsFolder = _tmp_1 != 0;
                    DeletedItem _item = new DeletedItem(_tmpDelItemUid, _tmpDelItemName, _tmpDelItemIconUri, _tmpDelItemLastModTime, _tmpDelItemTimeDeleted, _tmpDelItemEntityTable, _tmpDelItemEntityUid, _tmpDelItemDeletedByPersonUid, _tmpDelItemStatus, _tmpDelItemIsFolder);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public Object updateStatusByUids(final List<Long> uidList, final int newStatus, final long updateTime, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Unit call() throws Exception {
                StringBuilder _stringBuilder = StringUtil.newStringBuilder();
                _stringBuilder.append("\n");
                _stringBuilder.append("        UPDATE DeletedItem");
                _stringBuilder.append("\n");
                _stringBuilder.append("           SET delItemStatus = ");
                _stringBuilder.append("?");
                _stringBuilder.append(",");
                _stringBuilder.append("\n");
                _stringBuilder.append("               delItemLastModTime = ");
                _stringBuilder.append("?");
                _stringBuilder.append("\n");
                _stringBuilder.append("         WHERE delItemUid IN (");
                int _inputSize = uidList.size();
                StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
                _stringBuilder.append(")");
                _stringBuilder.append("\n");
                _stringBuilder.append("    ");
                String _sql = _stringBuilder.toString();
                SupportSQLiteStatement _stmt = DeletedItemDao_Impl.this.__db.compileStatement(_sql);
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)newStatus);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, updateTime);
                _argIndex = 3;
                Unit unit = uidList.iterator();
                while (unit.hasNext()) {
                    long _item = (Long)unit.next();
                    _stmt.bindLong(_argIndex, _item);
                    ++_argIndex;
                }
                DeletedItemDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    DeletedItemDao_Impl.this.__db.setTransactionSuccessful();
                    unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    DeletedItemDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

