/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.core.db.dao.MessageDao;
import com.ustadmobile.lib.db.composites.MessageAndOtherPerson;
import com.ustadmobile.lib.db.entities.Message;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class MessageDao_Impl
extends MessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Message> __insertionAdapterOfMessage;

    public MessageDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMessage = new EntityInsertionAdapter<Message>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `Message` (`messageUid`,`messageSenderPersonUid`,`messageToPersonUid`,`messageText`,`messageTimestamp`,`messageLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Message entity) {
                statement.bindLong(1, entity.getMessageUid());
                statement.bindLong(2, entity.getMessageSenderPersonUid());
                statement.bindLong(3, entity.getMessageToPersonUid());
                if (entity.getMessageText() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getMessageText());
                }
                statement.bindLong(5, entity.getMessageTimestamp());
                statement.bindLong(6, entity.getMessageLct());
            }
        };
    }

    @Override
    public Object insert(final Message message, Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                MessageDao_Impl.this.__db.beginTransaction();
                try {
                    MessageDao_Impl.this.__insertionAdapterOfMessage.insert((Object)message);
                    MessageDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    MessageDao_Impl.this.__db.endTransaction();
                }
            }
        }, $completion);
    }

    @Override
    public PagingSource<Integer, Message> messagesFromOtherUserAsPagingSource(long accountPersonUid, long otherPersonUid) {
        String _sql = "\n        SELECT Message.*\n          FROM Message\n         WHERE (Message.messageSenderPersonUid = ?\n                AND Message.messageToPersonUid = ?)\n            OR (Message.messageSenderPersonUid = ?\n                AND Message.messageToPersonUid = ?) \n      ORDER BY Message.messageTimestamp DESC          \n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Message.*\n          FROM Message\n         WHERE (Message.messageSenderPersonUid = ?\n                AND Message.messageToPersonUid = ?)\n            OR (Message.messageSenderPersonUid = ?\n                AND Message.messageToPersonUid = ?) \n      ORDER BY Message.messageTimestamp DESC          \n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 3;
        _statement.bindLong(_argIndex, otherPersonUid);
        _argIndex = 4;
        _statement.bindLong(_argIndex, accountPersonUid);
        return new LimitOffsetPagingSource<Message>(_statement, this.__db, new String[]{"Message"}){

            @NonNull
            protected List<Message> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfMessageUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageUid");
                int _cursorIndexOfMessageSenderPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageSenderPersonUid");
                int _cursorIndexOfMessageToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageToPersonUid");
                int _cursorIndexOfMessageText = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageText");
                int _cursorIndexOfMessageTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageTimestamp");
                int _cursorIndexOfMessageLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageLct");
                ArrayList<Message> _result2 = new ArrayList<Message>(cursor.getCount());
                while (cursor.moveToNext()) {
                    long _tmpMessageUid = cursor.getLong(_cursorIndexOfMessageUid);
                    long _tmpMessageSenderPersonUid = cursor.getLong(_cursorIndexOfMessageSenderPersonUid);
                    long _tmpMessageToPersonUid = cursor.getLong(_cursorIndexOfMessageToPersonUid);
                    String _tmpMessageText = cursor.isNull(_cursorIndexOfMessageText) ? null : cursor.getString(_cursorIndexOfMessageText);
                    long _tmpMessageTimestamp = cursor.getLong(_cursorIndexOfMessageTimestamp);
                    long _tmpMessageLct = cursor.getLong(_cursorIndexOfMessageLct);
                    Message _item = new Message(_tmpMessageUid, _tmpMessageSenderPersonUid, _tmpMessageToPersonUid, _tmpMessageText, _tmpMessageTimestamp, _tmpMessageLct);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @Override
    public PagingSource<Integer, MessageAndOtherPerson> conversationsForUserAsPagingSource(String searchQuery, long accountPersonUid) {
        String _sql = "\n        SELECT Person.*, LatestMessage.*, PersonPicture.*\n          FROM Person\n               JOIN Message LatestMessage\n                    ON LatestMessage.messageUid = \n                       (SELECT Message.messageUid\n                          FROM Message\n                         WHERE (Message.messageSenderPersonUid = ?\n                                AND Message.messageToPersonUid = Person.personUid)\n                            OR (Message.messageSenderPersonUid = Person.personUid\n                                AND Message.messageToPersonUid = ?)\n                       ORDER BY Message.messageTimestamp DESC\n                          LIMIT 1)\n                          \n                LEFT JOIN PersonPicture\n                          ON PersonPicture.personPictureUid = Person.personUid\n         WHERE ? = '%' \n               OR (Person.firstNames || ' ' || Person.lastName) LIKE ?\n      ORDER BY LatestMessage.messageTimestamp DESC\n    ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"\n        SELECT Person.*, LatestMessage.*, PersonPicture.*\n          FROM Person\n               JOIN Message LatestMessage\n                    ON LatestMessage.messageUid = \n                       (SELECT Message.messageUid\n                          FROM Message\n                         WHERE (Message.messageSenderPersonUid = ?\n                                AND Message.messageToPersonUid = Person.personUid)\n                            OR (Message.messageSenderPersonUid = Person.personUid\n                                AND Message.messageToPersonUid = ?)\n                       ORDER BY Message.messageTimestamp DESC\n                          LIMIT 1)\n                          \n                LEFT JOIN PersonPicture\n                          ON PersonPicture.personPictureUid = Person.personUid\n         WHERE ? = '%' \n               OR (Person.firstNames || ' ' || Person.lastName) LIKE ?\n      ORDER BY LatestMessage.messageTimestamp DESC\n    ", (int)4);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 2;
        _statement.bindLong(_argIndex, accountPersonUid);
        _argIndex = 3;
        _statement.bindString(_argIndex, searchQuery);
        _argIndex = 4;
        _statement.bindString(_argIndex, searchQuery);
        return new LimitOffsetPagingSource<MessageAndOtherPerson>(_statement, this.__db, new String[]{"Person", "Message", "PersonPicture"}){

            @NonNull
            protected List<MessageAndOtherPerson> convertRows(@NonNull Cursor cursor) {
                int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personUid");
                int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"username");
                int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"firstNames");
                int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastName");
                int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"emailAddr");
                int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"phoneNum");
                int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"gender");
                int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"active");
                int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isPersonalAccount");
                int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"dateOfBirth");
                int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personAddress");
                int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personOrgId");
                int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personGroupUid");
                int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLct");
                int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personCountry");
                int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personType");
                int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personMasterChangeSeqNum");
                int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLocalChangeSeqNum");
                int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personLastChangedBy");
                int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"admin");
                int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personNotes");
                int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherName");
                int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fatherNumber");
                int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherName");
                int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"motherNum");
                int _cursorIndexOfMessageUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageUid");
                int _cursorIndexOfMessageSenderPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageSenderPersonUid");
                int _cursorIndexOfMessageToPersonUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageToPersonUid");
                int _cursorIndexOfMessageText = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageText");
                int _cursorIndexOfMessageTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageTimestamp");
                int _cursorIndexOfMessageLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageLct");
                int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUid");
                int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureLct");
                int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureUri");
                int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureThumbnailUri");
                int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"fileSize");
                int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"personPictureActive");
                ArrayList<MessageAndOtherPerson> _result2 = new ArrayList<MessageAndOtherPerson>(cursor.getCount());
                while (cursor.moveToNext()) {
                    PersonPicture _tmpPersonPicture;
                    Message _tmpMessage;
                    Person _tmpOtherPerson;
                    if (!(cursor.isNull(_cursorIndexOfPersonUid) && cursor.isNull(_cursorIndexOfUsername) && cursor.isNull(_cursorIndexOfFirstNames) && cursor.isNull(_cursorIndexOfLastName) && cursor.isNull(_cursorIndexOfEmailAddr) && cursor.isNull(_cursorIndexOfPhoneNum) && cursor.isNull(_cursorIndexOfGender) && cursor.isNull(_cursorIndexOfActive) && cursor.isNull(_cursorIndexOfIsPersonalAccount) && cursor.isNull(_cursorIndexOfDateOfBirth) && cursor.isNull(_cursorIndexOfPersonAddress) && cursor.isNull(_cursorIndexOfPersonOrgId) && cursor.isNull(_cursorIndexOfPersonGroupUid) && cursor.isNull(_cursorIndexOfPersonLct) && cursor.isNull(_cursorIndexOfPersonCountry) && cursor.isNull(_cursorIndexOfPersonType) && cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfPersonLastChangedBy) && cursor.isNull(_cursorIndexOfAdmin) && cursor.isNull(_cursorIndexOfPersonNotes) && cursor.isNull(_cursorIndexOfFatherName) && cursor.isNull(_cursorIndexOfFatherNumber) && cursor.isNull(_cursorIndexOfMotherName) && cursor.isNull(_cursorIndexOfMotherNum))) {
                        long _tmpPersonUid = cursor.getLong(_cursorIndexOfPersonUid);
                        String _tmpUsername = cursor.isNull(_cursorIndexOfUsername) ? null : cursor.getString(_cursorIndexOfUsername);
                        String _tmpFirstNames = cursor.isNull(_cursorIndexOfFirstNames) ? null : cursor.getString(_cursorIndexOfFirstNames);
                        String _tmpLastName = cursor.isNull(_cursorIndexOfLastName) ? null : cursor.getString(_cursorIndexOfLastName);
                        String _tmpEmailAddr = cursor.isNull(_cursorIndexOfEmailAddr) ? null : cursor.getString(_cursorIndexOfEmailAddr);
                        String _tmpPhoneNum = cursor.isNull(_cursorIndexOfPhoneNum) ? null : cursor.getString(_cursorIndexOfPhoneNum);
                        int _tmpGender = cursor.getInt(_cursorIndexOfGender);
                        int _tmp = cursor.getInt(_cursorIndexOfActive);
                        boolean _tmpActive = _tmp != 0;
                        int _tmp_1 = cursor.getInt(_cursorIndexOfIsPersonalAccount);
                        boolean _tmpIsPersonalAccount = _tmp_1 != 0;
                        long _tmpDateOfBirth = cursor.getLong(_cursorIndexOfDateOfBirth);
                        String _tmpPersonAddress = cursor.isNull(_cursorIndexOfPersonAddress) ? null : cursor.getString(_cursorIndexOfPersonAddress);
                        String _tmpPersonOrgId = cursor.isNull(_cursorIndexOfPersonOrgId) ? null : cursor.getString(_cursorIndexOfPersonOrgId);
                        long _tmpPersonGroupUid = cursor.getLong(_cursorIndexOfPersonGroupUid);
                        long _tmpPersonLct = cursor.getLong(_cursorIndexOfPersonLct);
                        String _tmpPersonCountry = cursor.isNull(_cursorIndexOfPersonCountry) ? null : cursor.getString(_cursorIndexOfPersonCountry);
                        int _tmpPersonType = cursor.getInt(_cursorIndexOfPersonType);
                        long _tmpPersonMasterChangeSeqNum = cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
                        long _tmpPersonLocalChangeSeqNum = cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
                        int _tmpPersonLastChangedBy = cursor.getInt(_cursorIndexOfPersonLastChangedBy);
                        int _tmp_2 = cursor.getInt(_cursorIndexOfAdmin);
                        boolean _tmpAdmin = _tmp_2 != 0;
                        String _tmpPersonNotes = cursor.isNull(_cursorIndexOfPersonNotes) ? null : cursor.getString(_cursorIndexOfPersonNotes);
                        String _tmpFatherName = cursor.isNull(_cursorIndexOfFatherName) ? null : cursor.getString(_cursorIndexOfFatherName);
                        String _tmpFatherNumber = cursor.isNull(_cursorIndexOfFatherNumber) ? null : cursor.getString(_cursorIndexOfFatherNumber);
                        String _tmpMotherName = cursor.isNull(_cursorIndexOfMotherName) ? null : cursor.getString(_cursorIndexOfMotherName);
                        String _tmpMotherNum = cursor.isNull(_cursorIndexOfMotherNum) ? null : cursor.getString(_cursorIndexOfMotherNum);
                        _tmpOtherPerson = new Person(_tmpPersonUid, _tmpUsername, _tmpFirstNames, _tmpLastName, _tmpEmailAddr, _tmpPhoneNum, _tmpGender, _tmpActive, _tmpIsPersonalAccount, _tmpDateOfBirth, _tmpPersonAddress, _tmpPersonOrgId, _tmpPersonGroupUid, _tmpPersonLct, _tmpPersonCountry, _tmpPersonType, _tmpPersonMasterChangeSeqNum, _tmpPersonLocalChangeSeqNum, _tmpPersonLastChangedBy, _tmpAdmin, _tmpPersonNotes, _tmpFatherName, _tmpFatherNumber, _tmpMotherName, _tmpMotherNum);
                    } else {
                        _tmpOtherPerson = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfMessageUid) && cursor.isNull(_cursorIndexOfMessageSenderPersonUid) && cursor.isNull(_cursorIndexOfMessageToPersonUid) && cursor.isNull(_cursorIndexOfMessageText) && cursor.isNull(_cursorIndexOfMessageTimestamp) && cursor.isNull(_cursorIndexOfMessageLct))) {
                        long _tmpMessageUid = cursor.getLong(_cursorIndexOfMessageUid);
                        long _tmpMessageSenderPersonUid = cursor.getLong(_cursorIndexOfMessageSenderPersonUid);
                        long _tmpMessageToPersonUid = cursor.getLong(_cursorIndexOfMessageToPersonUid);
                        String _tmpMessageText = cursor.isNull(_cursorIndexOfMessageText) ? null : cursor.getString(_cursorIndexOfMessageText);
                        long _tmpMessageTimestamp = cursor.getLong(_cursorIndexOfMessageTimestamp);
                        long _tmpMessageLct = cursor.getLong(_cursorIndexOfMessageLct);
                        _tmpMessage = new Message(_tmpMessageUid, _tmpMessageSenderPersonUid, _tmpMessageToPersonUid, _tmpMessageText, _tmpMessageTimestamp, _tmpMessageLct);
                    } else {
                        _tmpMessage = null;
                    }
                    if (!(cursor.isNull(_cursorIndexOfPersonPictureUid) && cursor.isNull(_cursorIndexOfPersonPictureLct) && cursor.isNull(_cursorIndexOfPersonPictureUri) && cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfPersonPictureActive))) {
                        long _tmpPersonPictureUid = cursor.getLong(_cursorIndexOfPersonPictureUid);
                        long _tmpPersonPictureLct = cursor.getLong(_cursorIndexOfPersonPictureLct);
                        String _tmpPersonPictureUri = cursor.isNull(_cursorIndexOfPersonPictureUri) ? null : cursor.getString(_cursorIndexOfPersonPictureUri);
                        String _tmpPersonPictureThumbnailUri = cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) ? null : cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
                        int _tmpFileSize = cursor.getInt(_cursorIndexOfFileSize);
                        int _tmp_3 = cursor.getInt(_cursorIndexOfPersonPictureActive);
                        boolean _tmpPersonPictureActive = _tmp_3 != 0;
                        _tmpPersonPicture = new PersonPicture(_tmpPersonPictureUid, _tmpPersonPictureLct, _tmpPersonPictureUri, _tmpPersonPictureThumbnailUri, _tmpFileSize, _tmpPersonPictureActive);
                    } else {
                        _tmpPersonPicture = null;
                    }
                    MessageAndOtherPerson _item = new MessageAndOtherPerson(_tmpMessage, _tmpOtherPerson, _tmpPersonPicture);
                    _result2.add(_item);
                }
                return _result2;
            }
        };
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

