package com.ustadmobile.core.db.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Update
import com.ustadmobile.lib.db.entities.LeavingReason
import com.ustadmobile.lib.db.entities.UidAndLabel
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

@Dao
public actual abstract class LeavingReasonDao : BaseDao<LeavingReason> {
  @Query(`value` = "SELECT * FROM LeavingReason")
  public actual abstract fun findAllReasons(): PagingSource<Int, LeavingReason>

  @Query(`value` = "SELECT * FROM LeavingReason")
  public actual abstract fun findAllReasonsLive(): List<LeavingReason>

  @Query(`value` = "SELECT * FROM LeavingReason")
  public actual abstract suspend fun findAllReasonsAsync(): List<LeavingReason>

  @Query(`value` = "SELECT * FROM LeavingReason WHERE leavingReasonUid = :uid")
  public actual abstract suspend fun findByUidAsync(uid: Long): LeavingReason?

  @Query(`value` =
      "SELECT leavingReasonUid FROM LeavingReason WHERE leavingReasonUid IN (:uidList)")
  public actual abstract suspend fun findByUidList(uidList: List<Long>): List<Long>

  @Query(`value` = "SELECT * FROM LeavingReason WHERE leavingReasonUid = :uid")
  public actual abstract fun findByUidLive(uid: Long): Flow<LeavingReason?>

  @Query(`value` =
      "SELECT LeavingReason.leavingReasonUid AS uid, \n            LeavingReason.leavingReasonTitle As labelName  \n            FROM LeavingReason WHERE leavingReasonUid IN (:uidList)")
  public actual abstract suspend fun getReasonsFromUids(uidList: List<Long>): List<UidAndLabel>

  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun replaceList(entityList: List<LeavingReason>)

  @Update(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun updateAsync(entity: LeavingReason): Int
}
