package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.ext.doorNodeIdHeader
import com.ustadmobile.door.ext.setRepoUrl
import com.ustadmobile.door.http.RepoDaoFlowHelper
import com.ustadmobile.door.http.RepositoryDaoWithFlowHelper
import com.ustadmobile.door.http.replicateHttpRequestCatchAndLog
import com.ustadmobile.door.replication.onClientRepoDoorMessageHttpResponse
import com.ustadmobile.door.replication.withRepoChangeMonitorAsync
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.PersonAuth2
import io.ktor.client.HttpClient
import io.ktor.client.request.`get`
import io.ktor.client.request.`header`
import io.ktor.client.request.parameter
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow
import kotlinx.serialization.builtins.serializer

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class PersonAuth2Dao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: PersonAuth2Dao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : PersonAuth2Dao(), RepositoryDaoWithFlowHelper {
  override val repoDaoFlowHelper: RepoDaoFlowHelper = RepoDaoFlowHelper(_repo)


  override suspend fun insertListAsync(auths: List<PersonAuth2>) {
    _repo.withRepoChangeMonitorAsync("PersonAuth2") {
      _dao.insertListAsync(auths)
    }
  }

  override suspend fun insertAsync(auth: PersonAuth2): Long {
    val _result = _repo.withRepoChangeMonitorAsync("PersonAuth2") {
      _dao.insertAsync(auth)
    }
    return _result
  }

  override suspend fun findByPersonUid(personUid: Long): PersonAuth2? {
    val _result = _dao.findByPersonUid(personUid)
    return _result
  }

  override fun findByPersonUidFlow(personUid: Long): Flow<PersonAuth2?> =
      repoDaoFlowHelper.asRepoFlow(
    dbFlow = _dao.findByPersonUidFlow(personUid),
    onMakeHttpRequest =  {
      _repo.replicateHttpRequestCatchAndLog(repoPath = "PersonAuth2Dao/findByPersonUidFlow") {
        val _response = _httpClient.`get` {
          setRepoUrl(_repo.config, "PersonAuth2Dao/findByPersonUidFlow")
          doorNodeIdHeader(_repo)
          `header`("cache-control", "no-store")
          parameter("personUid", _repo.config.json.encodeToString(Long.serializer(), personUid))
        }

        _db.onClientRepoDoorMessageHttpResponse(_response, _repo.config.json)
      }
    },
  )

  override suspend fun findByUsername(username: String): PersonAuth2? {
    val _result = _dao.findByUsername(username)
    return _result
  }

  override fun findByUsernames(username: String): Flow<PersonAuth2?> {
    val _result = _dao.findByUsernames(username)
    return _result
  }
}
