package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorConstants
import com.ustadmobile.door.ext.doorWrapperNodeId
import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.http.DoorJsonRequest
import com.ustadmobile.door.http.DoorJsonResponse
import com.ustadmobile.door.message.DoorMessage
import com.ustadmobile.door.replication.DoorReplicationEntity
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionFile
import kotlin.Long
import kotlin.Suppress
import kotlin.collections.buildList
import kotlinx.coroutines.flow.first
import kotlinx.serialization.builtins.serializer
import kotlinx.serialization.json.jsonObject

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseAssignmentSubmissionFileDao.getByAssignmentUidAndPersonUid_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_accountPersonUid : Long = request.queryParam("accountPersonUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_getByAssignmentUidAndPersonUid = getByAssignmentUidAndPersonUid(
    accountPersonUid = _arg_accountPersonUid,
    assignmentUid = _arg_assignmentUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_getByAssignmentUidAndPersonUid.mapNotNull {
        _row ->
        _row.submissionFile?.let {
          DoorReplicationEntity(tableId = 90,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseAssignmentSubmissionFile.serializer(),
                it).jsonObject,
          )
        }

      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public suspend
    fun CourseAssignmentSubmissionFileDao.getAllSubmissionFilesFromSubmitterAsFlow_DoorHttp(serverConfig: DoorHttpServerConfig,
    request: DoorJsonRequest): DoorJsonResponse {
  val json = serverConfig.json
  val _arg_submitterUid : Long = request.queryParam("submitterUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _arg_assignmentUid : Long = request.queryParam("assignmentUid")?.let {
    json.decodeFromString(Long.serializer(), it)
  } ?: 0L
  val _result_getAllSubmissionFilesFromSubmitterAsFlow = getAllSubmissionFilesFromSubmitterAsFlow(
    submitterUid = _arg_submitterUid,
    assignmentUid = _arg_assignmentUid,
  ).first()
  val replicationEntities = buildList<DoorReplicationEntity> {
    addAll(
      _result_getAllSubmissionFilesFromSubmitterAsFlow.mapNotNull {
        _row ->
        _row.submissionFile?.let {
          DoorReplicationEntity(tableId = 90,
            orUid = 0,
            entity = json.encodeToJsonElement(CourseAssignmentSubmissionFile.serializer(),
                it).jsonObject,
          )
        }

      }
    )
  }
  val _thisNodeId = request.db.doorWrapperNodeId
  return DoorJsonResponse(
    headers = buildList {
      add(Pair(DoorConstants.HEADER_NODE_ID, _thisNodeId.toString()))
    }
    ,
    bodyText = json.encodeToString(
      DoorMessage.serializer(),
      DoorMessage(
        what = DoorMessage.WHAT_REPLICATION_PULL,
        fromNode = _thisNodeId,
        toNode = request.requireNodeId(),
        replications = replicationEntities,
      )
    )
  )
}
