package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.ErrorReport
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.collections.List

@Dao
public actual abstract class ErrorReportDao {
  @Insert(
    entity = Any::class,
    onConflict = 3,
  )
  public actual abstract suspend fun insertAsync(errorReport: ErrorReport): Long

  @Query(`value` =
      "\n        SELECT ErrorReport.* \n          FROM ErrorReport\n         WHERE errUid = :errUid\n    ")
  public actual abstract suspend fun findByUidAsync(errUid: Long): ErrorReport?

  @Query(`value` =
      "\n        SELECT ErrorReport.*\n          FROM ErrorReport\n         WHERE errorCode = :errCode  \n    ")
  public actual abstract suspend fun findByErrorCode(errCode: Int): List<ErrorReport>
}
