package com.ustadmobile.core.db.dao

import com.ustadmobile.door.http.DoorHttpServerConfig
import com.ustadmobile.door.ktor.KtorCallDaoAdapter
import com.ustadmobile.door.ktor.respondDoorJson
import com.ustadmobile.door.ktor.toDoorRequest
import io.ktor.server.application.call
import io.ktor.server.routing.Route
import io.ktor.server.routing.`get`
import kotlin.Suppress

@Suppress("LocalVariableName", "RedundantSuppression", "FunctionName",
    "RedundantVisibilityModifier")
public fun Route.PersonPasskeyDao_KtorRoute(serverConfig: DoorHttpServerConfig,
    daoCallAdapter: KtorCallDaoAdapter<PersonPasskeyDao>) {
  `get`("getAllActivePasskeys") {
    val _daoAndDb = daoCallAdapter(call)
    call.respondDoorJson(
      _daoAndDb.dao.getAllActivePasskeys_DoorHttp(serverConfig, call.toDoorRequest(_daoAndDb.db))
    )
  }
}
