/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.builder;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import net.bramp.ffmpeg.FFmpegUtils;
import net.bramp.ffmpeg.Preconditions;
import net.bramp.ffmpeg.builder.FFmpegOutputBuilder;
import net.bramp.ffmpeg.probe.FFmpegFormat;
import net.bramp.ffmpeg.probe.FFmpegProbeResult;

public class FFmpegBuilder {
    boolean override = true;
    int pass = 0;
    String pass_directory = "";
    String pass_prefix;
    Verbosity verbosity = Verbosity.ERROR;
    URI progress;
    String user_agent;
    String format;
    Long startOffset;
    boolean read_at_native_frame_rate = false;
    final List<String> inputs = new ArrayList<String>();
    final Map<String, FFmpegProbeResult> inputProbes = new TreeMap<String, FFmpegProbeResult>();
    final List<String> extra_args = new ArrayList<String>();
    final List<FFmpegOutputBuilder> outputs = new ArrayList<FFmpegOutputBuilder>();
    String audioFilter;
    String videoFilter;
    String complexFilter;

    public FFmpegBuilder overrideOutputFiles(boolean override) {
        this.override = override;
        return this;
    }

    public boolean getOverrideOutputFiles() {
        return this.override;
    }

    public FFmpegBuilder setPass(int pass) {
        this.pass = pass;
        return this;
    }

    public FFmpegBuilder setPassDirectory(String directory) {
        this.pass_directory = (String)com.google.common.base.Preconditions.checkNotNull((Object)directory);
        return this;
    }

    public FFmpegBuilder setPassPrefix(String prefix) {
        this.pass_prefix = (String)com.google.common.base.Preconditions.checkNotNull((Object)prefix);
        return this;
    }

    public FFmpegBuilder setVerbosity(Verbosity verbosity) {
        com.google.common.base.Preconditions.checkNotNull((Object)((Object)verbosity));
        this.verbosity = verbosity;
        return this;
    }

    public FFmpegBuilder setUserAgent(String userAgent) {
        this.user_agent = (String)com.google.common.base.Preconditions.checkNotNull((Object)userAgent);
        return this;
    }

    public FFmpegBuilder readAtNativeFrameRate() {
        this.read_at_native_frame_rate = true;
        return this;
    }

    public FFmpegBuilder addInput(FFmpegProbeResult result) {
        com.google.common.base.Preconditions.checkNotNull((Object)result);
        String filename = ((FFmpegFormat)com.google.common.base.Preconditions.checkNotNull((Object)result.format)).filename;
        this.inputProbes.put(filename, result);
        return this.addInput(filename);
    }

    public FFmpegBuilder addInput(String filename) {
        com.google.common.base.Preconditions.checkNotNull((Object)filename);
        this.inputs.add(filename);
        return this;
    }

    protected void clearInputs() {
        this.inputs.clear();
        this.inputProbes.clear();
    }

    public FFmpegBuilder setInput(FFmpegProbeResult result) {
        this.clearInputs();
        return this.addInput(result);
    }

    public FFmpegBuilder setInput(String filename) {
        this.clearInputs();
        return this.addInput(filename);
    }

    public FFmpegBuilder setFormat(String format) {
        this.format = (String)com.google.common.base.Preconditions.checkNotNull((Object)format);
        return this;
    }

    public FFmpegBuilder setStartOffset(long duration, TimeUnit units) {
        com.google.common.base.Preconditions.checkNotNull((Object)((Object)units));
        this.startOffset = units.toMillis(duration);
        return this;
    }

    public FFmpegBuilder addProgress(URI uri) {
        this.progress = (URI)com.google.common.base.Preconditions.checkNotNull((Object)uri);
        return this;
    }

    public FFmpegBuilder setComplexFilter(String filter) {
        this.complexFilter = Preconditions.checkNotEmpty(filter, "filter must not be empty");
        return this;
    }

    public FFmpegBuilder setAudioFilter(String filter) {
        this.audioFilter = Preconditions.checkNotEmpty(filter, "filter must not be empty");
        return this;
    }

    public FFmpegBuilder setVideoFilter(String filter) {
        this.videoFilter = Preconditions.checkNotEmpty(filter, "filter must not be empty");
        return this;
    }

    public FFmpegBuilder addExtraArgs(String ... values) {
        com.google.common.base.Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"one or more values must be supplied");
        Preconditions.checkNotEmpty(values[0], "first extra arg may not be empty");
        for (String value : values) {
            this.extra_args.add((String)com.google.common.base.Preconditions.checkNotNull((Object)value));
        }
        return this;
    }

    public FFmpegOutputBuilder addOutput(String filename) {
        FFmpegOutputBuilder output = new FFmpegOutputBuilder(this, filename);
        this.outputs.add(output);
        return output;
    }

    public FFmpegOutputBuilder addOutput(URI uri) {
        FFmpegOutputBuilder output = new FFmpegOutputBuilder(this, uri);
        this.outputs.add(output);
        return output;
    }

    public FFmpegBuilder addOutput(FFmpegOutputBuilder output) {
        this.outputs.add(output);
        return this;
    }

    public FFmpegOutputBuilder addStdoutOutput() {
        return this.addOutput("-");
    }

    @CheckReturnValue
    public List<String> build() {
        ImmutableList.Builder args = new ImmutableList.Builder();
        com.google.common.base.Preconditions.checkArgument((!this.inputs.isEmpty() ? 1 : 0) != 0, (Object)"At least one input must be specified");
        com.google.common.base.Preconditions.checkArgument((!this.outputs.isEmpty() ? 1 : 0) != 0, (Object)"At least one output must be specified");
        args.add((Object)(this.override ? "-y" : "-n"));
        args.add((Object[])new String[]{"-v", this.verbosity.toString()});
        if (this.user_agent != null) {
            args.add((Object[])new String[]{"-user_agent", this.user_agent});
        }
        if (this.startOffset != null) {
            args.add((Object[])new String[]{"-ss", FFmpegUtils.toTimecode(this.startOffset, TimeUnit.MILLISECONDS)});
        }
        if (this.format != null) {
            args.add((Object[])new String[]{"-f", this.format});
        }
        if (this.read_at_native_frame_rate) {
            args.add((Object)"-re");
        }
        if (this.progress != null) {
            args.add((Object[])new String[]{"-progress", this.progress.toString()});
        }
        args.addAll(this.extra_args);
        for (String input : this.inputs) {
            args.add((Object[])new String[]{"-i", input});
        }
        if (this.pass > 0) {
            args.add((Object[])new String[]{"-pass", Integer.toString(this.pass)});
            if (this.pass_prefix != null) {
                args.add((Object[])new String[]{"-passlogfile", this.pass_directory + this.pass_prefix});
            }
        }
        if (!Strings.isNullOrEmpty((String)this.audioFilter)) {
            args.add((Object[])new String[]{"-af", this.audioFilter});
        }
        if (!Strings.isNullOrEmpty((String)this.videoFilter)) {
            args.add((Object[])new String[]{"-vf", this.videoFilter});
        }
        if (!Strings.isNullOrEmpty((String)this.complexFilter)) {
            args.add((Object[])new String[]{"-filter_complex", this.complexFilter});
        }
        for (FFmpegOutputBuilder output : this.outputs) {
            args.addAll(output.build(this, this.pass));
        }
        return args.build();
    }

    public static enum Verbosity {
        QUIET,
        PANIC,
        FATAL,
        ERROR,
        WARNING,
        INFO,
        VERBOSE,
        DEBUG;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Strict {
        VERY,
        STRICT,
        NORMAL,
        UNOFFICIAL,
        EXPERIMENTAL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

