/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRC32InputStream
extends FilterInputStream {
    final CRC32 crc = new CRC32();

    public CRC32InputStream(InputStream in) {
        super(in);
    }

    public void resetCrc() {
        this.crc.reset();
    }

    public long getValue() {
        return this.crc.getValue();
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b >= 0) {
            this.crc.update(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int len = this.in.read(b);
        this.crc.update(b, 0, len);
        return len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int actual = this.in.read(b, off, len);
        this.crc.update(b, off, actual);
        return actual;
    }

    @Override
    public long skip(long n) throws IOException {
        long i;
        for (i = 0L; i < n; ++i) {
            this.read();
        }
        return i;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

