/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.job;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.bramp.ffmpeg.FFmpeg;
import net.bramp.ffmpeg.builder.FFmpegBuilder;
import net.bramp.ffmpeg.job.FFmpegJob;
import net.bramp.ffmpeg.progress.ProgressListener;

public class TwoPassFFmpegJob
extends FFmpegJob {
    final String passlogPrefix = UUID.randomUUID().toString();
    final FFmpegBuilder builder;

    public TwoPassFFmpegJob(FFmpeg ffmpeg, FFmpegBuilder builder) {
        this(ffmpeg, builder, null);
    }

    public TwoPassFFmpegJob(FFmpeg ffmpeg, FFmpegBuilder builder, @Nullable ProgressListener listener) {
        super(ffmpeg, listener);
        this.builder = ((FFmpegBuilder)Preconditions.checkNotNull((Object)builder)).setPassPrefix(this.passlogPrefix);
        List<String> unused = this.builder.setPass(1).build();
    }

    protected void deletePassLog() throws IOException {
        Path cwd = Paths.get("", new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(cwd, this.passlogPrefix + "*.log*");){
            for (Path p : stream) {
                Files.deleteIfExists(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.state = FFmpegJob.State.RUNNING;
        try {
            try {
                boolean override = this.builder.getOverrideOutputFiles();
                FFmpegBuilder b1 = this.builder.setPass(1).overrideOutputFiles(true);
                this.ffmpeg.run(b1, this.listener);
                FFmpegBuilder b2 = this.builder.setPass(2).overrideOutputFiles(override);
                this.ffmpeg.run(b2, this.listener);
            }
            finally {
                this.deletePassLog();
            }
            this.state = FFmpegJob.State.FINISHED;
        }
        catch (Throwable t) {
            this.state = FFmpegJob.State.FAILED;
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }
}

