/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.datasource;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PoolSetup {
    static void setupConnection(String name, String url, String username, String password, Properties properties) throws SQLException {
        GenericObjectPool connectionPool = new GenericObjectPool(null, NumberUtils.toInt((String)properties.getProperty("dbcpMaxActive"), (int)8), (byte)NumberUtils.toInt((String)properties.getProperty("dbcpWhenExhaustedAction"), (int)1), NumberUtils.toLong((String)properties.getProperty("dbcpMaxWait"), (long)-1L), NumberUtils.toInt((String)properties.getProperty("dbcpMaxIdle"), (int)8), NumberUtils.toInt((String)properties.getProperty("dbcpMinIdle"), (int)0), BooleanUtils.toBoolean((String)properties.getProperty("dbcpTestOnBorrow")), BooleanUtils.toBoolean((String)properties.getProperty("dbcpTestOnReturn")), NumberUtils.toLong((String)properties.getProperty("dbcpTimeBetweenEvictionRunsMillis"), (long)-1L), NumberUtils.toInt((String)properties.getProperty("dbcpNumTestsPerEvictionRun"), (int)3), NumberUtils.toLong((String)properties.getProperty("dbcpMinEvictableIdleTimeMillis"), (long)1800000L), BooleanUtils.toBoolean((String)properties.getProperty("dbcpTestWhileIdle")), NumberUtils.toLong((String)properties.getProperty("dbcpSoftMinEvictableIdleTimeMillis"), (long)-1L));
        DriverManagerConnectionFactory connectionFactory = username == null || password == null ? new DriverManagerConnectionFactory(url, null) : new DriverManagerConnectionFactory(url, username, password);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, properties.getProperty("dbcpValidationQuery"), BooleanUtils.toBoolean((String)properties.getProperty("dbcpDefaultReadOnly")), BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)properties.getProperty("dbcpDefaultAutoCommit")), (boolean)true));
        try {
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("WARNING: DBCP needed but not in the classpath. ");
        }
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(name, (ObjectPool)connectionPool);
    }

    static String getUrl(String poolName) {
        return "jdbc:apache:commons:dbcp:" + poolName;
    }
}

