/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.BooleanUtils;
import org.osjava.sj.loader.CustomSJProperties;
import org.osjava.sj.loader.IniSJProperties;
import org.osjava.sj.loader.JndiLoader;
import org.osjava.sj.loader.SJProperties;
import org.osjava.sj.loader.XmlSJProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedJndiLoader
extends JndiLoader {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public FileBasedJndiLoader(Hashtable env) {
        super(env);
    }

    public void load(File fileOrDirectory, Context ctxt) throws NamingException, IOException {
        if ((fileOrDirectory = new File(fileOrDirectory.getAbsolutePath())).isDirectory()) {
            this.loadDirectory(fileOrDirectory, ctxt, null, "");
        } else if (fileOrDirectory.isFile()) {
            boolean preserveFileNameAsContextName = BooleanUtils.toBoolean((String)((String)this.environment.get("org.osjava.sj.filenameToContext")));
            if (this.isSupportedFile(fileOrDirectory)) {
                this.loadFile(fileOrDirectory, ctxt, null, "", preserveFileNameAsContextName);
            }
        } else {
            this.LOGGER.warn("Not found: {}", (Object)fileOrDirectory.getAbsolutePath());
        }
    }

    public void load(File fileOrDirectory, Context ctxt, boolean preserveFileNameAsContextName) throws NamingException, IOException {
        if ((fileOrDirectory = new File(fileOrDirectory.getAbsolutePath())).isDirectory()) {
            this.loadDirectory(fileOrDirectory, ctxt, null, "");
        } else if (fileOrDirectory.isFile()) {
            this.loadFile(fileOrDirectory, ctxt, null, "", preserveFileNameAsContextName);
        } else {
            this.LOGGER.warn("Not found: {}", (Object)fileOrDirectory.getAbsolutePath());
        }
    }

    private void loadDirectory(File directory, Context ctxt, Context parentCtxt, String subName) throws NamingException, IOException {
        this.LOGGER.debug("Loading {}", (Object)directory.getAbsolutePath());
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean preserveFileNameAsContextName;
                if (file.isDirectory()) {
                    String dirName = file.getName();
                    if (dirName.equals(".svn") || dirName.equals("CVS")) continue;
                    dirName = this.handleColonReplacement(dirName);
                    Context tmpCtxt = ctxt.createSubcontext(dirName);
                    this.loadDirectory(file, tmpCtxt, ctxt, dirName);
                    continue;
                }
                String baseName = FilenameUtils.getBaseName((String)file.getName());
                boolean bl = preserveFileNameAsContextName = !baseName.equals("default");
                if (!this.isSupportedFile(file)) continue;
                this.loadFile(file, ctxt, parentCtxt, subName, preserveFileNameAsContextName);
            }
        }
    }

    private void loadFile(File file, Context ctxt, Context parentCtxt, String subName, boolean preserveFileNameAsContextName) throws NamingException, IOException {
        this.LOGGER.debug("Loading {}", (Object)file.getAbsolutePath());
        String parentName = file.getName();
        parentName = this.handleColonReplacement(parentName);
        Context subContext = ctxt;
        Properties properties = this.toProperties(file);
        if (this.isNotNamespacedTypeDefinition(properties)) {
            subName = FilenameUtils.getBaseName((String)parentName);
            parentCtxt = subContext;
        } else if (!FilenameUtils.getBaseName((String)parentName).equals("default")) {
            parentName = FilenameUtils.getBaseName((String)parentName);
            if (preserveFileNameAsContextName) {
                subContext = ctxt.createSubcontext(parentName);
                parentCtxt = ctxt;
            }
            subName = parentName;
        }
        this.load(properties, subContext, parentCtxt, subName);
    }

    public Properties toProperties(File file) throws IOException {
        SJProperties properties = file.getName().endsWith(".xml") ? new XmlSJProperties() : (file.getName().endsWith(".ini") ? new IniSJProperties() : new CustomSJProperties());
        properties.setDelimiter((String)this.environment.get("org.osjava.sj.delimiter"));
        try (FileInputStream stream = new FileInputStream(file);){
            properties.load(stream);
            SJProperties sJProperties = properties;
            return sJProperties;
        }
    }
}

