/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.progress;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CountDownLatch;
import javax.annotation.CheckReturnValue;
import net.bramp.ffmpeg.progress.ProgressListener;
import net.bramp.ffmpeg.progress.ProgressParser;
import net.bramp.ffmpeg.progress.StreamProgressParser;

public abstract class AbstractSocketProgressParser
implements ProgressParser {
    final StreamProgressParser parser;
    Thread thread;

    public AbstractSocketProgressParser(ProgressListener listener) {
        this.parser = new StreamProgressParser(listener);
    }

    @CheckReturnValue
    static URI createUri(String scheme, InetAddress address, int port) throws URISyntaxException {
        Preconditions.checkNotNull((Object)address);
        return new URI(scheme, null, InetAddresses.toUriString((InetAddress)address), port, null, null, null);
    }

    @CheckReturnValue
    protected abstract String getThreadName();

    protected abstract Runnable getRunnable(CountDownLatch var1);

    @Override
    public synchronized void start() {
        if (this.thread != null) {
            throw new IllegalThreadStateException("Parser already started");
        }
        String name = this.getThreadName() + "(" + this.getUri().toString() + ")";
        CountDownLatch startSignal = new CountDownLatch(1);
        Runnable runnable = this.getRunnable(startSignal);
        this.thread = new Thread(runnable, name);
        this.thread.start();
        try {
            startSignal.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void stop() throws IOException {
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }
}

