/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.rest.domain.systemconfig.verifyauth;

import com.ustadmobile.centralappconfigdb.db.SystemConfigAuth;
import com.ustadmobile.centralappconfigdb.sqlite.CentralAppConfigDb;
import com.ustadmobile.core.domain.interop.HttpApiException;
import com.ustadmobile.core.domain.pbkdf2.Pbkdf2AuthenticateUseCase;
import com.ustadmobile.core.util.ext.StringExtActualKt;
import io.ktor.server.application.ApplicationCall;
import io.ktor.util.Base64Kt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086B\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/lib/rest/domain/systemconfig/verifyauth/VerifySystemConfigAuthUseCase;", "", "centralAppConfigDb", "Lcom/ustadmobile/centralappconfigdb/sqlite/CentralAppConfigDb;", "pbkdf2AuthenticateUseCase", "Lcom/ustadmobile/core/domain/pbkdf2/Pbkdf2AuthenticateUseCase;", "(Lcom/ustadmobile/centralappconfigdb/sqlite/CentralAppConfigDb;Lcom/ustadmobile/core/domain/pbkdf2/Pbkdf2AuthenticateUseCase;)V", "invoke", "", "call", "Lio/ktor/server/application/ApplicationCall;", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app-ktor-server"})
public final class VerifySystemConfigAuthUseCase {
    @NotNull
    private final CentralAppConfigDb centralAppConfigDb;
    @NotNull
    private final Pbkdf2AuthenticateUseCase pbkdf2AuthenticateUseCase;

    public VerifySystemConfigAuthUseCase(@NotNull CentralAppConfigDb centralAppConfigDb, @NotNull Pbkdf2AuthenticateUseCase pbkdf2AuthenticateUseCase) {
        Intrinsics.checkNotNullParameter((Object)centralAppConfigDb, (String)"centralAppConfigDb");
        Intrinsics.checkNotNullParameter((Object)pbkdf2AuthenticateUseCase, (String)"pbkdf2AuthenticateUseCase");
        this.centralAppConfigDb = centralAppConfigDb;
        this.pbkdf2AuthenticateUseCase = pbkdf2AuthenticateUseCase;
    }

    @Nullable
    public final Object invoke(@NotNull ApplicationCall call, @NotNull Continuation<? super Unit> $completion) {
        String string = call.getRequest().getHeaders().get("Authorization");
        if (string == null) {
            throw new HttpApiException(401, "Missing Authorization header", null, 4, null);
        }
        String authHeader = string;
        List list = new Regex("\\s+").split((CharSequence)authHeader, 2);
        String authScheme = (String)list.get(0);
        String authData = (String)list.get(1);
        if (!StringsKt.equals((String)authScheme, (String)"Basic", (boolean)true)) {
            throw new HttpApiException(400, "Only basic auth supported", null, 4, null);
        }
        String authUser = StringsKt.decodeToString((byte[])Base64Kt.decodeBase64Bytes((String)authData));
        String[] stringArray = new String[]{":"};
        List list2 = StringsKt.split$default((CharSequence)authUser, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String username = (String)list2.get(0);
        String password = (String)list2.get(1);
        SystemConfigAuth systemConfigAuth = (SystemConfigAuth)this.centralAppConfigDb.getSystemConfigAuthQueries().selectByAuthId(username).executeAsOneOrNull();
        if (systemConfigAuth == null) {
            throw new HttpApiException(401, "Invalid username", null, 4, null);
        }
        SystemConfigAuth sysConfigAuth = systemConfigAuth;
        byte[] byArray = StringExtActualKt.base64StringToByteArray((String)sysConfigAuth.getScaAuthCredential());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"base64StringToByteArray(...)");
        if (!Pbkdf2AuthenticateUseCase.invoke$default((Pbkdf2AuthenticateUseCase)this.pbkdf2AuthenticateUseCase, (String)password, (byte[])byArray, (String)sysConfigAuth.getScaAuthSalt(), (int)0, (int)0, (int)24, null)) {
            throw new HttpApiException(401, "Invalid password", null, 4, null);
        }
        return Unit.INSTANCE;
    }
}

