/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.collection.MutableVectorKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00060\u0002j\u0002`\u0003:\u0003pqrB\u001f\b\u0001\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001b\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u0017\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\bJ\u0019\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010$J\u001c\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001c\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J\u001c\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000&J\u0014\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J\u0017\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0086\bJ+\u0010'\u001a\u00020\u001c2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0006\u0010+\u001a\u00020\u001fJ\u0016\u0010,\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010-\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010-\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J\u0014\u0010-\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000&J\u0014\u0010.\u001a\u00020\u001c2\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u000e\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u0007J\u000b\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J0\u00102\u001a\u00028\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u0004\u0018\u00018\u0000H\u0086\b\u00a2\u0006\u0002\u00103J2\u00105\u001a\u0004\u0018\u00018\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00104JS\u00106\u001a\u0002H7\"\u0004\b\u0001\u001072\u0006\u00108\u001a\u0002H72'\u00109\u001a#\u0012\u0013\u0012\u0011H7\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H70:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010>Jh\u0010?\u001a\u0002H7\"\u0004\b\u0001\u001072\u0006\u00108\u001a\u0002H72<\u00109\u001a8\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b( \u0012\u0013\u0012\u0011H7\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H70@H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010AJS\u0010B\u001a\u0002H7\"\u0004\b\u0001\u001072\u0006\u00108\u001a\u0002H72'\u00109\u001a#\u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u0011H7\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u0002H70:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010>Jh\u0010C\u001a\u0002H7\"\u0004\b\u0001\u001072\u0006\u00108\u001a\u0002H72<\u00109\u001a8\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b( \u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u0011H7\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u0002H70@H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010AJ+\u0010D\u001a\u00020\u001f2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001f0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J1\u0010F\u001a\u00020\u001f2\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001f0:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J+\u0010G\u001a\u00020\u001f2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001f0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J1\u0010H\u001a\u00020\u001f2\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001f0:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0016\u0010I\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u0007H\u0086\n\u00a2\u0006\u0002\u0010JJ\u0013\u0010K\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010LJ+\u0010M\u001a\u00020\u00072\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J+\u0010N\u001a\u00020\u00072\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0006\u0010O\u001a\u00020\u001cJ\u0006\u0010P\u001a\u00020\u001cJ\u000b\u0010Q\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J0\u0010Q\u001a\u00028\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00104J\u0013\u0010R\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010LJ\u0010\u0010S\u001a\u0004\u0018\u00018\u0000H\u0086\b\u00a2\u0006\u0002\u00103J2\u0010S\u001a\u0004\u0018\u00018\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00104J>\u0010T\u001a\b\u0012\u0004\u0012\u0002H70\u0005\"\u0006\b\u0001\u00107\u0018\u00012\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H70)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u0010VJS\u0010W\u001a\b\u0012\u0004\u0012\u0002H70\u0005\"\u0006\b\u0001\u00107\u0018\u00012'\u0010U\u001a#\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b( \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H70:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u0010XJP\u0010Y\u001a\b\u0012\u0004\u0012\u0002H70\u0000\"\u0006\b\u0001\u00107\u0018\u00012)\u0010U\u001a%\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b( \u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H70:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J;\u0010Z\u001a\b\u0012\u0004\u0012\u0002H70\u0000\"\u0006\b\u0001\u00107\u0018\u00012\u0014\u0010U\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H70)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0016\u0010[\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010\\J\u0016\u0010]\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010\\J\u0013\u0010^\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010_\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010_\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J\u0014\u0010_\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000&J\u0013\u0010`\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u0007\u00a2\u0006\u0002\u0010JJ\u0016\u0010a\u001a\u00020\u001f2\u0006\u0010b\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\u0007J\u0014\u0010d\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J+\u0010e\u001a\u00020\u001c2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u001e\u0010f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010gJ\u001e\u0010h\u001a\u00020\u001f2\u0016\u0010i\u001a\u0012\u0012\u0004\u0012\u00028\u00000jj\b\u0012\u0004\u0012\u00028\u0000`kJ+\u0010l\u001a\u00020\u00072\u0012\u0010m\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\b\u0010n\u001a\u00020oH\u0001R.\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0016\n\u0002\u0010\u000f\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u0010\u001a\u00020\u00118\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u00078\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006s"}, d2={"Landroidx/compose/runtime/collection/MutableVector;", "T", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "content", "", "size", "", "([Ljava/lang/Object;I)V", "getContent$annotations", "()V", "getContent", "()[Ljava/lang/Object;", "setContent", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "lastIndex", "getLastIndex", "()I", "list", "", "<set-?>", "getSize", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "([Ljava/lang/Object;)Z", "", "", "any", "predicate", "Lkotlin/Function1;", "asMutableList", "clear", "contains", "containsAll", "contentEquals", "other", "ensureCapacity", "capacity", "first", "()Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "firstOrNull", "fold", "R", "initial", "operation", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "acc", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "foldIndexed", "Lkotlin/Function3;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "foldRight", "foldRightIndexed", "forEach", "block", "forEachIndexed", "forEachReversed", "forEachReversedIndexed", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "indexOfFirst", "indexOfLast", "isEmpty", "isNotEmpty", "last", "lastIndexOf", "lastOrNull", "map", "transform", "(Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "mapIndexed", "(Lkotlin/jvm/functions/Function2;)[Ljava/lang/Object;", "mapIndexedNotNull", "mapNotNull", "minusAssign", "(Ljava/lang/Object;)V", "plusAssign", "remove", "removeAll", "removeAt", "removeRange", "start", "end", "retainAll", "reversedAny", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "sortWith", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "sumBy", "selector", "throwNoSuchElementException", "", "MutableVectorList", "SubList", "VectorListIterator", "runtime"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1194:1\n48#1:1198\n48#1:1199\n523#1:1200\n53#1:1203\n523#1:1204\n48#1:1205\n523#1:1206\n523#1:1207\n523#1:1208\n48#1:1209\n523#1:1210\n48#1:1211\n523#1:1212\n523#1:1213\n523#1:1214\n48#1:1215\n523#1:1216\n48#1:1219\n48#1:1220\n48#1:1221\n523#1:1222\n1864#2,3:1195\n1855#2,2:1201\n1855#2,2:1217\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n249#1:1198\n259#1:1199\n260#1:1200\n292#1:1203\n293#1:1204\n307#1:1205\n308#1:1206\n334#1:1207\n359#1:1208\n595#1:1209\n595#1:1210\n637#1:1211\n637#1:1212\n665#1:1213\n675#1:1214\n768#1:1215\n769#1:1216\n794#1:1219\n821#1:1220\n833#1:1221\n834#1:1222\n185#1:1195,3\n281#1:1201,2\n782#1:1217,2\n*E\n"})
public final class MutableVector<T>
implements RandomAccess {
    @NotNull
    private T[] content;
    @Nullable
    private List<T> list;
    private int size;
    public static final int $stable = 8;

    @PublishedApi
    public MutableVector(@NotNull T[] content, int size) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.content = content;
        this.size = size;
    }

    @NotNull
    public final T[] getContent() {
        return this.content;
    }

    public final void setContent(@NotNull T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, (String)"<set-?>");
        this.content = TArray;
    }

    @PublishedApi
    public static /* synthetic */ void getContent$annotations() {
    }

    public final int getSize() {
        return this.size;
    }

    public final int getLastIndex() {
        boolean $i$f$getLastIndex = false;
        return this.getSize() - 1;
    }

    @NotNull
    public final IntRange getIndices() {
        boolean $i$f$getIndices = false;
        return new IntRange(0, this.getSize() - 1);
    }

    public final boolean add(T element) {
        this.ensureCapacity(this.size + 1);
        this.content[this.size] = element;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    public final void add(int index, T element) {
        this.ensureCapacity(this.size + 1);
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + 1), (int)index, (int)this.size);
        }
        content[index] = element;
        int n = this.size;
        this.size = n + 1;
    }

    public final boolean addAll(int index, @NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this.size + elements.size());
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.size()), (int)index, (int)this.size);
        }
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            content[index + i] = elements.get(i);
        }
        this.size += elements.size();
        return true;
    }

    public final boolean addAll(int index, @NotNull MutableVector<T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this.size + elements.size);
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.size), (int)index, (int)this.size);
        }
        ArraysKt.copyInto((Object[])elements.content, (Object[])content, (int)index, (int)0, (int)elements.size);
        this.size += elements.size;
        return true;
    }

    public final boolean addAll(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean $i$f$addAll = false;
        return this.addAll(this.getSize(), elements);
    }

    public final boolean addAll(@NotNull MutableVector<T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean $i$f$addAll = false;
        return this.addAll(this.getSize(), elements);
    }

    public final boolean addAll(@NotNull T[] elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.length == 0) {
            return false;
        }
        this.ensureCapacity(this.size + elements.length);
        ArraysKt.copyInto$default((Object[])elements, (Object[])this.content, (int)this.size, (int)0, (int)0, (int)12, null);
        this.size += elements.length;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        this.ensureCapacity(this.size + elements.size());
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.size()), (int)index, (int)this.size);
        }
        Iterable $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int i = n;
            boolean bl = false;
            content[index + i] = item;
        }
        this.size += elements.size();
        return true;
    }

    public final boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.addAll(this.size, elements);
    }

    public final boolean any(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$any = false;
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
                return true;
            } while (++i < size);
        }
        return false;
    }

    public final boolean reversedAny(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$reversedAny = false;
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
                return true;
            } while (--i >= 0);
        }
        return false;
    }

    @NotNull
    public final List<T> asMutableList() {
        List list = this.list;
        if (list == null) {
            MutableVectorList mutableVectorList;
            MutableVectorList it = mutableVectorList = new MutableVectorList(this);
            boolean bl = false;
            this.list = it;
            list = mutableVectorList;
        }
        return list;
    }

    public final void clear() {
        T[] content = this.content;
        MutableVector this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv.getSize() - 1; -1 < i; --i) {
            content[i] = null;
        }
        this.size = 0;
    }

    public final boolean contains(T element) {
        int i = 0;
        MutableVector this_$iv = this;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv.getSize() - 1;
        if (i <= n) {
            while (true) {
                this_$iv = this;
                boolean $i$f$get = false;
                if (Intrinsics.areEqual(this_$iv.getContent()[i], element)) {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    public final boolean containsAll(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            if (this.contains(elements.get(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            if (this.contains(it)) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAll(@NotNull MutableVector<T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        MutableVector<T> this_$iv = elements;
        boolean $i$f$getIndices = false;
        IntRange intRange = new IntRange(0, this_$iv.getSize() - 1);
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            while (true) {
                MutableVector<T> this_$iv2 = elements;
                boolean $i$f$get = false;
                if (!this.contains(this_$iv2.getContent()[i])) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    public final boolean contentEquals(@NotNull MutableVector<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.size != this.size) {
            return false;
        }
        int i = 0;
        MutableVector<T> this_$iv = this;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv.getSize() - 1;
        if (i <= n) {
            while (true) {
                this_$iv = other;
                boolean $i$f$get = false;
                T t = this_$iv.getContent()[i];
                this_$iv = this;
                $i$f$get = false;
                if (!Intrinsics.areEqual(t, this_$iv.getContent()[i])) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    public final void ensureCapacity(int capacity) {
        T[] oldContent = this.content;
        if (oldContent.length < capacity) {
            int newSize = Math.max(capacity, oldContent.length * 2);
            T[] TArray = Arrays.copyOf(oldContent, newSize);
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(this, newSize)");
            this.content = TArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final T first() {
        void this_$iv;
        if (this.isEmpty()) {
            throw new NoSuchElementException("MutableVector is empty.");
        }
        MutableVector mutableVector = this;
        int index$iv = 0;
        boolean $i$f$get = false;
        return this_$iv.getContent()[index$iv];
    }

    public final T first(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$first = false;
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                T item;
                if (!((Boolean)predicate.invoke(item = content[i])).booleanValue()) continue;
                return item;
            } while (++i < size);
        }
        this.throwNoSuchElementException();
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final T firstOrNull() {
        T t;
        boolean $i$f$firstOrNull = false;
        if (this.isEmpty()) {
            t = null;
        } else {
            void this_$iv;
            MutableVector mutableVector = this;
            int index$iv = 0;
            boolean $i$f$get = false;
            t = this_$iv.getContent()[index$iv];
        }
        return t;
    }

    @Nullable
    public final T firstOrNull(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$firstOrNull = false;
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                T item;
                if (!((Boolean)predicate.invoke(item = content[i])).booleanValue()) continue;
                return item;
            } while (++i < size);
        }
        return null;
    }

    public final <R> R fold(R initial, @NotNull Function2<? super R, ? super T, ? extends R> operation2) {
        Intrinsics.checkNotNullParameter(operation2, (String)"operation");
        boolean $i$f$fold = false;
        Object acc = initial;
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                acc = operation2.invoke(acc, content[i]);
            } while (++i < size);
        }
        return acc;
    }

    public final <R> R foldIndexed(R initial, @NotNull Function3<? super Integer, ? super R, ? super T, ? extends R> operation2) {
        Intrinsics.checkNotNullParameter(operation2, (String)"operation");
        boolean $i$f$foldIndexed = false;
        Object acc = initial;
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                acc = operation2.invoke((Object)i, acc, content[i]);
            } while (++i < size);
        }
        return acc;
    }

    public final <R> R foldRight(R initial, @NotNull Function2<? super T, ? super R, ? extends R> operation2) {
        Intrinsics.checkNotNullParameter(operation2, (String)"operation");
        boolean $i$f$foldRight = false;
        Object acc = initial;
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                acc = operation2.invoke(content[i], acc);
            } while (--i >= 0);
        }
        return acc;
    }

    public final <R> R foldRightIndexed(R initial, @NotNull Function3<? super Integer, ? super T, ? super R, ? extends R> operation2) {
        Intrinsics.checkNotNullParameter(operation2, (String)"operation");
        boolean $i$f$foldRightIndexed = false;
        Object acc = initial;
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                acc = operation2.invoke((Object)i, content[i], acc);
            } while (--i >= 0);
        }
        return acc;
    }

    public final void forEach(@NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEach = false;
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                block.invoke(content[i]);
            } while (++i < size);
        }
    }

    public final void forEachIndexed(@NotNull Function2<? super Integer, ? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEachIndexed = false;
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                block.invoke((Object)i, content[i]);
            } while (++i < size);
        }
    }

    public final void forEachReversed(@NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEachReversed = false;
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                block.invoke(content[i]);
            } while (--i >= 0);
        }
    }

    public final void forEachReversedIndexed(@NotNull Function2<? super Integer, ? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEachReversedIndexed = false;
        if (this.getSize() > 0) {
            int i = this.getSize() - 1;
            T[] content = this.getContent();
            do {
                block.invoke((Object)i, content[i]);
            } while (--i >= 0);
        }
    }

    public final T get(int index) {
        boolean $i$f$get = false;
        return this.getContent()[index];
    }

    public final int indexOf(T element) {
        int size = this.size;
        if (size > 0) {
            int i = 0;
            T[] content = this.content;
            do {
                if (!Intrinsics.areEqual(element, content[i])) continue;
                return i;
            } while (++i < size);
        }
        return -1;
    }

    public final int indexOfFirst(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$indexOfFirst = false;
        int size = this.getSize();
        if (size > 0) {
            int i = 0;
            T[] content = this.getContent();
            do {
                if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
                return i;
            } while (++i < size);
        }
        return -1;
    }

    public final int indexOfLast(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$indexOfLast = false;
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                if (!((Boolean)predicate.invoke(content[i])).booleanValue()) continue;
                return i;
            } while (--i >= 0);
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isNotEmpty() {
        return this.size != 0;
    }

    /*
     * WARNING - void declaration
     */
    public final T last() {
        void this_$iv;
        if (this.isEmpty()) {
            throw new NoSuchElementException("MutableVector is empty.");
        }
        MutableVector mutableVector = this;
        MutableVector this_$iv2 = this;
        boolean $i$f$getLastIndex = false;
        int index$iv = this_$iv2.getSize() - 1;
        boolean $i$f$get = false;
        return this_$iv.getContent()[index$iv];
    }

    public final T last(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$last = false;
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                T item;
                if (!((Boolean)predicate.invoke(item = content[i])).booleanValue()) continue;
                return item;
            } while (--i >= 0);
        }
        this.throwNoSuchElementException();
        throw new KotlinNothingValueException();
    }

    public final int lastIndexOf(T element) {
        int size = this.size;
        if (size > 0) {
            int i = size - 1;
            T[] content = this.content;
            do {
                if (!Intrinsics.areEqual(element, content[i])) continue;
                return i;
            } while (--i >= 0);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final T lastOrNull() {
        T t;
        boolean $i$f$lastOrNull = false;
        if (this.isEmpty()) {
            t = null;
        } else {
            void this_$iv;
            MutableVector mutableVector = this;
            MutableVector this_$iv2 = this;
            boolean $i$f$getLastIndex = false;
            int index$iv = this_$iv2.getSize() - 1;
            boolean $i$f$get = false;
            t = this_$iv.getContent()[index$iv];
        }
        return t;
    }

    @Nullable
    public final T lastOrNull(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$lastOrNull = false;
        int size = this.getSize();
        if (size > 0) {
            int i = size - 1;
            T[] content = this.getContent();
            do {
                T item;
                if (!((Boolean)predicate.invoke(item = content[i])).booleanValue()) continue;
                return item;
            } while (--i >= 0);
        }
        return null;
    }

    public final /* synthetic */ <R> R[] map(Function1<? super T, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$map = false;
        int n = 0;
        int n2 = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R");
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            MutableVector this_$iv = this;
            boolean $i$f$get = false;
            objectArray[n3] = transform.invoke(this_$iv.getContent()[n3]);
        }
        return objectArray;
    }

    public final /* synthetic */ <R> R[] mapIndexed(Function2<? super Integer, ? super T, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$mapIndexed = false;
        int n = 0;
        int n2 = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R");
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            MutableVector this_$iv = this;
            boolean $i$f$get = false;
            objectArray[n3] = transform.invoke((Object)n3, this_$iv.getContent()[n3]);
        }
        return objectArray;
    }

    public final /* synthetic */ <R> MutableVector<R> mapIndexedNotNull(Function2<? super Integer, ? super T, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$mapIndexedNotNull = false;
        int size = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R?");
        Object[] arr = new Object[size];
        int targetSize = 0;
        if (size > 0) {
            T[] content = this.getContent();
            int i = 0;
            do {
                Object target;
                if ((target = transform.invoke((Object)i, content[i])) == null) continue;
                arr[targetSize++] = target;
            } while (++i < size);
        }
        return new MutableVector<Object>(arr, targetSize);
    }

    public final /* synthetic */ <R> MutableVector<R> mapNotNull(Function1<? super T, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$mapNotNull = false;
        int size = this.getSize();
        Intrinsics.reifiedOperationMarker((int)0, (String)"R?");
        Object[] arr = new Object[size];
        int targetSize = 0;
        if (size > 0) {
            T[] content = this.getContent();
            int i = 0;
            do {
                Object target;
                if ((target = transform.invoke(content[i])) == null) continue;
                arr[targetSize++] = target;
            } while (++i < size);
        }
        return new MutableVector<Object>(arr, targetSize);
    }

    public final void plusAssign(T element) {
        boolean $i$f$plusAssign = false;
        this.add(element);
    }

    public final void minusAssign(T element) {
        boolean $i$f$minusAssign = false;
        this.remove(element);
    }

    public final boolean remove(T element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public final boolean removeAll(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            this.remove(elements.get(i));
        }
        return initialSize != this.size;
    }

    public final boolean removeAll(@NotNull MutableVector<T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        int i = 0;
        MutableVector<T> this_$iv = elements;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv.getSize() - 1;
        if (i <= n) {
            while (true) {
                this_$iv = elements;
                boolean $i$f$get = false;
                this.remove(this_$iv.getContent()[i]);
                if (i == n) break;
                ++i;
            }
        }
        return initialSize != this.size;
    }

    public final boolean removeAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        int initialSize = this.size;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            this.remove(it);
        }
        return initialSize != this.size;
    }

    public final T removeAt(int index) {
        Object[] content = this.content;
        T item = content[index];
        MutableVector this_$iv = this;
        boolean $i$f$getLastIndex = false;
        if (index != this_$iv.getSize() - 1) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)index, (int)(index + 1), (int)this.size);
        }
        int n = this.size;
        this.size = n + -1;
        content[this.size] = null;
        return item;
    }

    public final void removeRange(int start2, int end2) {
        if (end2 > start2) {
            int newSize;
            if (end2 < this.size) {
                ArraysKt.copyInto((Object[])this.content, (Object[])this.content, (int)start2, (int)end2, (int)this.size);
            }
            int i = newSize = this.size - (end2 - start2);
            MutableVector this_$iv = this;
            boolean $i$f$getLastIndex = false;
            int n = this_$iv.getSize() - 1;
            if (i <= n) {
                while (true) {
                    this.content[i] = null;
                    if (i == n) break;
                    ++i;
                }
            }
            this.size = newSize;
        }
    }

    public final boolean retainAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        MutableVector this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv.getSize() - 1; -1 < i; --i) {
            MutableVector this_$iv2 = this;
            boolean $i$f$get = false;
            T item = this_$iv2.getContent()[i];
            if (elements.contains(item)) continue;
            this.removeAt(i);
        }
        return initialSize != this.size;
    }

    public final T set(int index, T element) {
        T[] content = this.content;
        T old = content[index];
        content[index] = element;
        return old;
    }

    public final void sortWith(@NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        ArraysKt.sortWith((Object[])this.content, comparator, (int)0, (int)this.size);
    }

    public final int sumBy(@NotNull Function1<? super T, Integer> selector) {
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        boolean $i$f$sumBy = false;
        int sum = 0;
        int size = this.getSize();
        if (size > 0) {
            T[] content = this.getContent();
            int i = 0;
            do {
                sum += ((Number)selector.invoke(content[i])).intValue();
            } while (++i < size);
        }
        return sum;
    }

    @PublishedApi
    @NotNull
    public final Void throwNoSuchElementException() {
        throw new NoSuchElementException("MutableVector contains no element matching the predicate.");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000bH\u0016J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u001dH\u0096\u0002J\u0015\u0010\u001e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0015\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\"\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0015\u0010#\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010$\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u001e\u0010%\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/compose/runtime/collection/MutableVector$MutableVectorList;", "T", "", "vector", "Landroidx/compose/runtime/collection/MutableVector;", "(Landroidx/compose/runtime/collection/MutableVector;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "runtime"})
    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,1194:1\n523#2:1195\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n*L\n941#1:1195\n*E\n"})
    private static final class MutableVectorList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final MutableVector<T> vector;

        public MutableVectorList(@NotNull MutableVector<T> vector) {
            Intrinsics.checkNotNullParameter(vector, (String)"vector");
            this.vector = vector;
        }

        public int getSize() {
            return this.vector.getSize();
        }

        @Override
        public boolean contains(Object element) {
            return this.vector.contains(element);
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.containsAll(elements);
        }

        @Override
        public T get(int index) {
            MutableVectorKt.access$checkIndex(this, index);
            MutableVector<T> this_$iv = this.vector;
            boolean $i$f$get = false;
            return this_$iv.getContent()[index];
        }

        @Override
        public int indexOf(Object element) {
            return this.vector.indexOf(element);
        }

        @Override
        public boolean isEmpty() {
            return this.vector.isEmpty();
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            return this.vector.lastIndexOf(element);
        }

        @Override
        public boolean add(T element) {
            return this.vector.add(element);
        }

        @Override
        public void add(int index, T element) {
            this.vector.add(index, element);
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll(index, elements);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll(elements);
        }

        @Override
        public void clear() {
            this.vector.clear();
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index) {
            return new VectorListIterator(this, index);
        }

        @Override
        public boolean remove(Object element) {
            return this.vector.remove(element);
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.removeAll(elements);
        }

        public T removeAt(int index) {
            MutableVectorKt.access$checkIndex(this, index);
            return this.vector.removeAt(index);
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.retainAll(elements);
        }

        @Override
        public T set(int index, T element) {
            MutableVectorKt.access$checkIndex(this, index);
            return this.vector.set(index, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            MutableVectorKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0017\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\fH\u0016J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0096\u0002J\u0015\u0010\u001f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0015\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010#\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0015\u0010$\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u001e\u0010&\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroidx/compose/runtime/collection/MutableVector$SubList;", "T", "", "list", "start", "", "end", "(Ljava/util/List;II)V", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "runtime"})
    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1194:1\n1855#2,2:1195\n1855#2,2:1197\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n*L\n1013#1:1195,2\n1095#1:1197,2\n*E\n"})
    private static final class SubList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final List<T> list;
        private final int start;
        private int end;

        public SubList(@NotNull List<T> list, int start2, int end2) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = list;
            this.start = start2;
            this.end = end2;
        }

        public int getSize() {
            return this.end - this.start;
        }

        @Override
        public boolean contains(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                if (this.contains(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public T get(int index) {
            MutableVectorKt.access$checkIndex(this, index);
            return this.list.get(index + this.start);
        }

        @Override
        public int indexOf(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return i - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.end == this.start;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    if (Intrinsics.areEqual(this.list.get(i), (Object)element)) {
                        return i - this.start;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return -1;
        }

        @Override
        public boolean add(T element) {
            int n = this.end;
            this.end = n + 1;
            this.list.add(n, element);
            return true;
        }

        @Override
        public void add(int index, T element) {
            this.list.add(index + this.start, element);
            int n = this.end;
            this.end = n + 1;
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(index + this.start, elements);
            this.end += elements.size();
            return elements.size() > 0;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(this.end, elements);
            this.end += elements.size();
            return elements.size() > 0;
        }

        @Override
        public void clear() {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    this.list.remove(i);
                    if (i == n) break;
                    --i;
                }
            }
            this.end = this.start;
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index) {
            return new VectorListIterator(this, index);
        }

        @Override
        public boolean remove(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                this.list.remove(i);
                int n2 = this.end;
                this.end = n2 + -1;
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                this.remove(it);
            }
            return originalEnd != this.end;
        }

        public T removeAt(int index) {
            MutableVectorKt.access$checkIndex(this, index);
            T item = this.list.remove(index + this.start);
            int n = this.end;
            this.end = n + -1;
            return item;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            int i = this.end - 1;
            int n = this.start;
            if (n <= i) {
                while (true) {
                    T item;
                    if (!elements.contains(item = this.list.get(i))) {
                        this.list.remove(i);
                        int n2 = this.end;
                        this.end = n2 + -1;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return originalEnd != this.end;
        }

        @Override
        public T set(int index, T element) {
            MutableVectorKt.access$checkIndex(this, index);
            return this.list.set(index + this.start, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            MutableVectorKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList<T>(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\f\u001a\u00020\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016J\u000e\u0010\u000f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\r\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\u0015\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/runtime/collection/MutableVector$VectorListIterator;", "T", "", "list", "", "index", "", "(Ljava/util/List;I)V", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "remove", "set", "runtime"})
    private static final class VectorListIterator<T>
    implements ListIterator<T>,
    KMutableListIterator {
        @NotNull
        private final List<T> list;
        private int index;

        public VectorListIterator(@NotNull List<T> list, int index) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = list;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public T next() {
            int n = this.index;
            this.index = n + 1;
            return this.list.get(n);
        }

        @Override
        public void remove() {
            int n = this.index;
            this.index = n + -1;
            this.list.remove(this.index);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public T previous() {
            int n = this.index;
            this.index = n + -1;
            return this.list.get(this.index);
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void add(T element) {
            this.list.add(this.index, element);
            int n = this.index;
            this.index = n + 1;
        }

        @Override
        public void set(T element) {
            this.list.set(this.index, element);
        }
    }
}

