/*
 * Decompiled with CFR 0.152.
 */
package dev.icerock.moko.resources;

import dev.icerock.moko.resources.ClassLoaderExtKt;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0010\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u0018J)\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001a\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001bJ\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Ldev/icerock/moko/resources/StringResource;", "", "resourcesClassLoader", "Ljava/lang/ClassLoader;", "bundleName", "", "key", "(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/lang/String;)V", "getBundleName", "()Ljava/lang/String;", "getKey", "getResourcesClassLoader", "()Ljava/lang/ClassLoader;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "localized", "locale", "Ljava/util/Locale;", "args", "", "(Ljava/util/Locale;[Ljava/lang/Object;)Ljava/lang/String;", "toString", "resources"})
public final class StringResource {
    @NotNull
    private final ClassLoader resourcesClassLoader;
    @NotNull
    private final String bundleName;
    @NotNull
    private final String key;

    public StringResource(@NotNull ClassLoader resourcesClassLoader, @NotNull String bundleName, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)resourcesClassLoader, (String)"resourcesClassLoader");
        Intrinsics.checkNotNullParameter((Object)bundleName, (String)"bundleName");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.resourcesClassLoader = resourcesClassLoader;
        this.bundleName = bundleName;
        this.key = key;
    }

    @NotNull
    public final ClassLoader getResourcesClassLoader() {
        return this.resourcesClassLoader;
    }

    @NotNull
    public final String getBundleName() {
        return this.bundleName;
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    @NotNull
    public final String localized(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ResourceBundle resourceBundle = ClassLoaderExtKt.getResourceBundle(this.resourcesClassLoader, this.bundleName, locale);
        String string = resourceBundle.getString(this.key);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resourceBundle.getString(key)");
        return string;
    }

    public static /* synthetic */ String localized$default(StringResource stringResource, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return stringResource.localized(locale);
    }

    @NotNull
    public final String localized(@NotNull Locale locale, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ResourceBundle resourceBundle = ClassLoaderExtKt.getResourceBundle(this.resourcesClassLoader, this.bundleName, locale);
        String string = resourceBundle.getString(this.key);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"string");
        String string2 = string;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        return string3;
    }

    public static /* synthetic */ String localized$default(StringResource stringResource, Locale locale, Object[] objectArray, int n, Object object) {
        if ((n & 1) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return stringResource.localized(locale, objectArray);
    }

    @NotNull
    public final ClassLoader component1() {
        return this.resourcesClassLoader;
    }

    @NotNull
    public final String component2() {
        return this.bundleName;
    }

    @NotNull
    public final String component3() {
        return this.key;
    }

    @NotNull
    public final StringResource copy(@NotNull ClassLoader resourcesClassLoader, @NotNull String bundleName, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)resourcesClassLoader, (String)"resourcesClassLoader");
        Intrinsics.checkNotNullParameter((Object)bundleName, (String)"bundleName");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new StringResource(resourcesClassLoader, bundleName, key);
    }

    public static /* synthetic */ StringResource copy$default(StringResource stringResource, ClassLoader classLoader, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            classLoader = stringResource.resourcesClassLoader;
        }
        if ((n & 2) != 0) {
            string = stringResource.bundleName;
        }
        if ((n & 4) != 0) {
            string2 = stringResource.key;
        }
        return stringResource.copy(classLoader, string, string2);
    }

    @NotNull
    public String toString() {
        return "StringResource(resourcesClassLoader=" + this.resourcesClassLoader + ", bundleName=" + this.bundleName + ", key=" + this.key + ")";
    }

    public int hashCode() {
        int result = this.resourcesClassLoader.hashCode();
        result = result * 31 + this.bundleName.hashCode();
        result = result * 31 + this.key.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringResource)) {
            return false;
        }
        StringResource stringResource = (StringResource)other;
        if (!Intrinsics.areEqual((Object)this.resourcesClassLoader, (Object)stringResource.resourcesClassLoader)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bundleName, (Object)stringResource.bundleName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.key, (Object)stringResource.key);
    }
}

