/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.backup;

import com.ustadmobile.core.domain.backup.CommonJvmUnzipFileUseCase;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0014\u00a8\u0006\b"}, d2={"Lcom/ustadmobile/core/domain/backup/JvmUnzipFileUseCase;", "Lcom/ustadmobile/core/domain/backup/CommonJvmUnzipFileUseCase;", "()V", "getOutputDirectory", "", "openInputStream", "Ljava/io/InputStream;", "path", "core"})
public final class JvmUnzipFileUseCase
extends CommonJvmUnzipFileUseCase {
    @Override
    @NotNull
    protected InputStream openInputStream(@NotNull String path) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            path2 = Paths.get(new URI(path));
        }
        catch (Exception e) {
            path2 = Paths.get(path, new String[0]);
        }
        Path filePath = path2;
        InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    @Override
    @NotNull
    protected String getOutputDirectory() {
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return string;
    }
}

