/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.credentials.passkey.request;

import com.ustadmobile.core.MR;
import com.ustadmobile.core.account.LearningSpace;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.domain.credentials.passkey.EncodeUserHandleUseCase;
import com.ustadmobile.core.domain.credentials.passkey.model.AuthenticatorSelectionCriteria;
import com.ustadmobile.core.domain.credentials.passkey.model.PublicKeyCredentialCreationOptionsJSON;
import com.ustadmobile.core.domain.credentials.passkey.model.PublicKeyCredentialParameters;
import com.ustadmobile.core.domain.credentials.passkey.model.PublicKeyCredentialRpEntity;
import com.ustadmobile.core.domain.credentials.passkey.model.PublicKeyCredentialUserEntityJSON;
import com.ustadmobile.core.domain.credentials.username.CreateCredentialUsernameUseCase;
import com.ustadmobile.core.impl.UstadMobileSystemImpl;
import com.ustadmobile.core.impl.config.SystemUrlConfig;
import com.ustadmobile.door.ext.DoorDatabaseExtJvmJsKt;
import com.ustadmobile.door.room.RoomDatabase;
import com.ustadmobile.lib.util.RandomStringKt;
import io.ktor.http.URLUtilsKt;
import io.ktor.util.Base64Kt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/ustadmobile/core/domain/credentials/passkey/request/CreatePublicKeyCredentialCreationOptionsJsonUseCase;", "", "systemUrlConfig", "Lcom/ustadmobile/core/impl/config/SystemUrlConfig;", "systemImpl", "Lcom/ustadmobile/core/impl/UstadMobileSystemImpl;", "createCredentialUsernameUseCase", "Lcom/ustadmobile/core/domain/credentials/username/CreateCredentialUsernameUseCase;", "learningSpace", "Lcom/ustadmobile/core/account/LearningSpace;", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "encodeUserHandleUseCase", "Lcom/ustadmobile/core/domain/credentials/passkey/EncodeUserHandleUseCase;", "(Lcom/ustadmobile/core/impl/config/SystemUrlConfig;Lcom/ustadmobile/core/impl/UstadMobileSystemImpl;Lcom/ustadmobile/core/domain/credentials/username/CreateCredentialUsernameUseCase;Lcom/ustadmobile/core/account/LearningSpace;Lcom/ustadmobile/core/db/UmAppDatabase;Lcom/ustadmobile/core/domain/credentials/passkey/EncodeUserHandleUseCase;)V", "invoke", "Lcom/ustadmobile/core/domain/credentials/passkey/model/PublicKeyCredentialCreationOptionsJSON;", "username", "", "core"})
public final class CreatePublicKeyCredentialCreationOptionsJsonUseCase {
    @NotNull
    private final SystemUrlConfig systemUrlConfig;
    @NotNull
    private final UstadMobileSystemImpl systemImpl;
    @NotNull
    private final CreateCredentialUsernameUseCase createCredentialUsernameUseCase;
    @NotNull
    private final LearningSpace learningSpace;
    @NotNull
    private final UmAppDatabase db;
    @NotNull
    private final EncodeUserHandleUseCase encodeUserHandleUseCase;

    public CreatePublicKeyCredentialCreationOptionsJsonUseCase(@NotNull SystemUrlConfig systemUrlConfig, @NotNull UstadMobileSystemImpl systemImpl, @NotNull CreateCredentialUsernameUseCase createCredentialUsernameUseCase, @NotNull LearningSpace learningSpace, @NotNull UmAppDatabase db, @NotNull EncodeUserHandleUseCase encodeUserHandleUseCase) {
        Intrinsics.checkNotNullParameter((Object)systemUrlConfig, (String)"systemUrlConfig");
        Intrinsics.checkNotNullParameter((Object)systemImpl, (String)"systemImpl");
        Intrinsics.checkNotNullParameter((Object)createCredentialUsernameUseCase, (String)"createCredentialUsernameUseCase");
        Intrinsics.checkNotNullParameter((Object)learningSpace, (String)"learningSpace");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)encodeUserHandleUseCase, (String)"encodeUserHandleUseCase");
        this.systemUrlConfig = systemUrlConfig;
        this.systemImpl = systemImpl;
        this.createCredentialUsernameUseCase = createCredentialUsernameUseCase;
        this.learningSpace = learningSpace;
        this.db = db;
        this.encodeUserHandleUseCase = encodeUserHandleUseCase;
    }

    @NotNull
    public final PublicKeyCredentialCreationOptionsJSON invoke(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        String challenge = RandomStringKt.randomString$default((int)16, null, (int)2, null);
        String credentialUsername = this.createCredentialUsernameUseCase.invoke(username);
        long personPasskeyUid = DoorDatabaseExtJvmJsKt.getDoorPrimaryKeyManager((RoomDatabase)((RoomDatabase)this.db)).nextId(892);
        String encodeUserHandle = this.encodeUserHandleUseCase.invoke(personPasskeyUid);
        Object[] objectArray = URLUtilsKt.Url((String)this.systemUrlConfig.getSystemBaseUrl()).getHost();
        String string = this.systemImpl.getString(MR.strings.INSTANCE.getApp_name());
        PublicKeyCredentialRpEntity publicKeyCredentialRpEntity = new PublicKeyCredentialRpEntity(string, (String)objectArray, null);
        objectArray = new PublicKeyCredentialParameters[]{new PublicKeyCredentialParameters("public-key", -7), new PublicKeyCredentialParameters("public-key", -257)};
        return new PublicKeyCredentialCreationOptionsJSON(publicKeyCredentialRpEntity, new PublicKeyCredentialUserEntityJSON(encodeUserHandle, credentialUsername, credentialUsername), Base64Kt.encodeBase64((String)challenge), CollectionsKt.listOf((Object[])objectArray), null, null, new AuthenticatorSelectionCriteria("platform", "required", false, null, 12, null), null, null, null, null, 1968, null);
    }
}

