/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.door.nodeevent;

import com.ustadmobile.door.RepositoryConfig;
import com.ustadmobile.door.ext.StringExpectExtKt;
import com.ustadmobile.door.message.DoorMessage;
import com.ustadmobile.door.nodeevent.NodeEventManager;
import com.ustadmobile.door.sse.DoorEventListener;
import com.ustadmobile.door.sse.DoorEventSource;
import com.ustadmobile.door.sse.DoorServerSentEvent;
import io.github.aakira.napier.Napier;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u00132\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/ustadmobile/door/nodeevent/NodeEventSseClient;", "Lcom/ustadmobile/door/sse/DoorEventListener;", "repoConfig", "Lcom/ustadmobile/door/RepositoryConfig;", "nodeEventManager", "Lcom/ustadmobile/door/nodeevent/NodeEventManager;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/ustadmobile/door/RepositoryConfig;Lcom/ustadmobile/door/nodeevent/NodeEventManager;Lkotlinx/coroutines/CoroutineScope;)V", "eventSource", "Lcom/ustadmobile/door/sse/DoorEventSource;", "isClosed", "", "logPrefix", "", "remoteNodeId", "", "url", "close", "", "onError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMessage", "message", "Lcom/ustadmobile/door/sse/DoorServerSentEvent;", "onOpen", "door-runtime"})
public final class NodeEventSseClient
implements DoorEventListener {
    @NotNull
    private final RepositoryConfig repoConfig;
    @NotNull
    private final NodeEventManager<?> nodeEventManager;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final DoorEventSource eventSource;
    @NotNull
    private final String url;
    @NotNull
    private final String logPrefix;
    private volatile long remoteNodeId;
    private volatile boolean isClosed;

    public NodeEventSseClient(@NotNull RepositoryConfig repoConfig, @NotNull NodeEventManager<?> nodeEventManager, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)repoConfig, (String)"repoConfig");
        Intrinsics.checkNotNullParameter(nodeEventManager, (String)"nodeEventManager");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.repoConfig = repoConfig;
        this.nodeEventManager = nodeEventManager;
        this.scope = scope;
        this.url = this.repoConfig.getEndpoint() + "replication/sse?door-node=" + StringExpectExtKt.urlEncode(this.repoConfig.getNodeId() + "/" + this.repoConfig.getAuth());
        this.logPrefix = "[NodeEventSseClient localNodeId=" + this.repoConfig.getNodeId() + " remoteEndpoint=" + this.repoConfig.getEndpoint() + "]";
        this.eventSource = new DoorEventSource(this.repoConfig, this.url, this, 0, 8, null);
    }

    @Override
    public void onOpen() {
        Napier.v$default((Napier)Napier.INSTANCE, null, (String)"DoorLog", (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NodeEventSseClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NodeEventSseClient.access$getLogPrefix$p(this.this$0) + " : open";
            }
        }), (int)1, null);
    }

    @Override
    public void onMessage(@NotNull DoorServerSentEvent message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = message.getEvent();
        if (Intrinsics.areEqual((Object)string, (Object)"init")) {
            this.remoteNodeId = Long.parseLong(message.getData());
            Napier.v$default((Napier)Napier.INSTANCE, null, (String)"DoorLog", (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ NodeEventSseClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return NodeEventSseClient.access$getLogPrefix$p(this.this$0) + " : onMessage : INIT: remoteNodeId = " + NodeEventSseClient.access$getRemoteNodeId$p(this.this$0);
                }
            }), (int)1, null);
        } else if (Intrinsics.areEqual((Object)string, (Object)"pending-replication")) {
            Napier.v$default((Napier)Napier.INSTANCE, null, (String)"DoorLog", (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ NodeEventSseClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return NodeEventSseClient.access$getLogPrefix$p(this.this$0) + " : onMessage : pending replication";
                }
            }), (int)1, null);
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ NodeEventSseClient this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = NodeEventSseClient.access$getNodeEventManager$p(this.this$0).onIncomingMessageReceived(new DoorMessage(1, NodeEventSseClient.access$getRemoteNodeId$p(this.this$0), NodeEventSseClient.access$getRepoConfig$p(this.this$0).getNodeId(), CollectionsKt.emptyList()), (Continuation<Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    public void onError(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isClosed) {
            Napier.INSTANCE.w((Throwable)e, "DoorLog", (Function0)new Function0<String>(this){
                final /* synthetic */ NodeEventSseClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return NodeEventSseClient.access$getLogPrefix$p(this.this$0) + " : onError";
                }
            });
        }
    }

    public final void close() {
        Napier.v$default((Napier)Napier.INSTANCE, null, (String)"DoorLog", (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ NodeEventSseClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return NodeEventSseClient.access$getLogPrefix$p(this.this$0) + " : close";
            }
        }), (int)1, null);
        try {
            this.isClosed = true;
            this.eventSource.close();
        }
        catch (Exception e) {
            Napier.INSTANCE.w((Throwable)e, "DoorLog", (Function0)new Function0<String>(this){
                final /* synthetic */ NodeEventSseClient this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return NodeEventSseClient.access$getLogPrefix$p(this.this$0) + " : exception closing";
                }
            });
        }
    }

    public static final /* synthetic */ String access$getLogPrefix$p(NodeEventSseClient $this) {
        return $this.logPrefix;
    }

    public static final /* synthetic */ long access$getRemoteNodeId$p(NodeEventSseClient $this) {
        return $this.remoteNodeId;
    }

    public static final /* synthetic */ NodeEventManager access$getNodeEventManager$p(NodeEventSseClient $this) {
        return $this.nodeEventManager;
    }

    public static final /* synthetic */ RepositoryConfig access$getRepoConfig$p(NodeEventSseClient $this) {
        return $this.repoConfig;
    }
}

