/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.awt.geom.GeneralPath;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.cff.CFFCIDFont$PrivateType1CharStringReader;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CIDKeyedType2CharString;
import org.apache.fontbox.cff.FDSelect;
import org.apache.fontbox.cff.Type2CharStringParser;
import org.apache.fontbox.type1.Type1CharStringReader;

public class CFFCIDFont
extends CFFFont {
    private String registry;
    private String ordering;
    private int supplement;
    private List<Map<String, Object>> fontDictionaries = Collections.emptyList();
    private List<Map<String, Object>> privateDictionaries = Collections.emptyList();
    private FDSelect fdSelect;
    private final Map<Integer, CIDKeyedType2CharString> charStringCache = new ConcurrentHashMap<Integer, CIDKeyedType2CharString>();
    private Type2CharStringParser charStringParser = null;
    private final CFFCIDFont$PrivateType1CharStringReader reader = new CFFCIDFont$PrivateType1CharStringReader(this, null);

    public String getRegistry() {
        return this.registry;
    }

    void setRegistry(String string) {
        this.registry = string;
    }

    public String getOrdering() {
        return this.ordering;
    }

    void setOrdering(String string) {
        this.ordering = string;
    }

    public int getSupplement() {
        return this.supplement;
    }

    void setSupplement(int n) {
        this.supplement = n;
    }

    public List<Map<String, Object>> getFontDicts() {
        return this.fontDictionaries;
    }

    void setFontDict(List<Map<String, Object>> list) {
        this.fontDictionaries = list;
    }

    public List<Map<String, Object>> getPrivDicts() {
        return this.privateDictionaries;
    }

    void setPrivDict(List<Map<String, Object>> list) {
        this.privateDictionaries = list;
    }

    public FDSelect getFdSelect() {
        return this.fdSelect;
    }

    void setFdSelect(FDSelect fDSelect) {
        this.fdSelect = fDSelect;
    }

    private int getDefaultWidthX(int n) {
        if ((n = this.fdSelect.getFDIndex(n)) == -1 || n >= this.privateDictionaries.size()) {
            return 1000;
        }
        Map<String, Object> map = this.privateDictionaries.get(n);
        if (map.containsKey("defaultWidthX")) {
            return ((Number)map.get("defaultWidthX")).intValue();
        }
        return 1000;
    }

    private int getNominalWidthX(int n) {
        if ((n = this.fdSelect.getFDIndex(n)) == -1 || n >= this.privateDictionaries.size()) {
            return 0;
        }
        Map<String, Object> map = this.privateDictionaries.get(n);
        if (map.containsKey("nominalWidthX")) {
            return ((Number)map.get("nominalWidthX")).intValue();
        }
        return 0;
    }

    private byte[][] getLocalSubrIndex(int n) {
        if ((n = this.fdSelect.getFDIndex(n)) == -1 || n >= this.privateDictionaries.size()) {
            return null;
        }
        Map<String, Object> map = this.privateDictionaries.get(n);
        return (byte[][])map.get("Subrs");
    }

    @Override
    public CIDKeyedType2CharString getType2CharString(int n) {
        CIDKeyedType2CharString cIDKeyedType2CharString = this.charStringCache.get(n);
        if (cIDKeyedType2CharString == null) {
            int n2 = this.getCharset().getGIDForCID(n);
            Object object = this.charStrings[n2];
            if (object == null) {
                object = this.charStrings[0];
            }
            object = this.getParser().parse((byte[])object, this.globalSubrIndex, this.getLocalSubrIndex(n2), String.format(Locale.US, "%04x", n));
            cIDKeyedType2CharString = new CIDKeyedType2CharString((Type1CharStringReader)this.reader, this.getName(), n, n2, (List<Object>)object, this.getDefaultWidthX(n2), this.getNominalWidthX(n2));
            this.charStringCache.put(n, cIDKeyedType2CharString);
        }
        return cIDKeyedType2CharString;
    }

    private Type2CharStringParser getParser() {
        if (this.charStringParser == null) {
            this.charStringParser = new Type2CharStringParser(this.getName());
        }
        return this.charStringParser;
    }

    @Override
    public GeneralPath getPath(String string) {
        int n = this.selectorToCID(string);
        return this.getType2CharString(n).getPath();
    }

    @Override
    public float getWidth(String string) {
        int n = this.selectorToCID(string);
        return this.getType2CharString(n).getWidth();
    }

    @Override
    public boolean hasGlyph(String string) {
        int n = this.selectorToCID(string);
        return n != 0;
    }

    private int selectorToCID(String string) {
        if (!string.startsWith("\\")) {
            throw new IllegalArgumentException("Invalid selector");
        }
        return Integer.parseInt(string.substring(1));
    }
}

