/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.a.d.e;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFCharset;
import org.apache.fontbox.cff.CFFEncoding;
import org.apache.fontbox.cff.CFFExpertCharset;
import org.apache.fontbox.cff.CFFExpertEncoding;
import org.apache.fontbox.cff.CFFExpertSubsetCharset;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFISOAdobeCharset;
import org.apache.fontbox.cff.CFFOperator;
import org.apache.fontbox.cff.CFFParser$ByteSource;
import org.apache.fontbox.cff.CFFParser$CFFBuiltInEncoding;
import org.apache.fontbox.cff.CFFParser$CFFBuiltInEncoding$Supplement;
import org.apache.fontbox.cff.CFFParser$CFFBytesource;
import org.apache.fontbox.cff.CFFParser$DictData;
import org.apache.fontbox.cff.CFFParser$DictData$Entry;
import org.apache.fontbox.cff.CFFParser$EmptyCharsetCID;
import org.apache.fontbox.cff.CFFParser$EmptyCharsetType1;
import org.apache.fontbox.cff.CFFParser$Format0Charset;
import org.apache.fontbox.cff.CFFParser$Format0Encoding;
import org.apache.fontbox.cff.CFFParser$Format0FDSelect;
import org.apache.fontbox.cff.CFFParser$Format1Charset;
import org.apache.fontbox.cff.CFFParser$Format1Encoding;
import org.apache.fontbox.cff.CFFParser$Format2Charset;
import org.apache.fontbox.cff.CFFParser$Format3FDSelect;
import org.apache.fontbox.cff.CFFParser$Header;
import org.apache.fontbox.cff.CFFParser$Range3;
import org.apache.fontbox.cff.CFFParser$RangeMapping;
import org.apache.fontbox.cff.CFFStandardEncoding;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.cff.DataInput;
import org.apache.fontbox.cff.DataInputByteArray;
import org.apache.fontbox.cff.DataInputRandomAccessRead;
import org.apache.fontbox.cff.FDSelect;

public class CFFParser {
    private static final Log LOG = LogFactory.getLog(CFFParser.class);
    private static final String TAG_OTTO = "OTTO";
    private static final String TAG_TTCF = "ttcf";
    private static final String TAG_TTFONLY = "\u0000\u0001\u0000\u0000";
    private String[] stringIndex = null;
    private CFFParser$ByteSource source;
    private String debugFontName;

    public List<CFFFont> parse(byte[] byArray, CFFParser$ByteSource cFFParser$ByteSource) {
        this.source = cFFParser$ByteSource;
        return this.parse(new DataInputByteArray(byArray));
    }

    public List<CFFFont> parse(e e2) {
        int n;
        byte[] byArray = new byte[(int)e2.c()];
        e2.a(0L);
        int n2 = byArray.length;
        while ((n = e2.a(byArray, byArray.length - n2, n2)) > 0) {
            n2 -= n;
        }
        e2.a(0L);
        this.source = new CFFParser$CFFBytesource(byArray);
        return this.parse(new DataInputRandomAccessRead(e2));
    }

    private List<CFFFont> parse(DataInput dataInput) {
        switch (CFFParser.readTagName(dataInput)) {
            case "OTTO": {
                dataInput = this.createTaggedCFFDataInput(dataInput);
                break;
            }
            case "ttcf": {
                throw new IOException("True Type Collection fonts are not supported.");
            }
            case "\u0000\u0001\u0000\u0000": {
                throw new IOException("OpenType fonts containing a true type font are not supported.");
            }
            default: {
                dataInput.setPosition(0);
            }
        }
        CFFParser.readHeader(dataInput);
        String[] stringArray = CFFParser.readStringIndexData(dataInput);
        if (stringArray.length == 0) {
            throw new IOException("Name index missing in CFF font");
        }
        byte[][] byArray = CFFParser.readIndexData(dataInput);
        Object object = byArray;
        if (byArray.length == 0) {
            throw new IOException("Top DICT INDEX missing in CFF font");
        }
        this.stringIndex = CFFParser.readStringIndexData(dataInput);
        byte[][] byArray2 = CFFParser.readIndexData(dataInput);
        ArrayList<CFFFont> arrayList = new ArrayList<CFFFont>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            CFFFont cFFFont = this.parseFont(dataInput, stringArray[i], (byte[])object[i]);
            cFFFont.setGlobalSubrIndex(byArray2);
            cFFFont.setData(this.source);
            arrayList.add(cFFFont);
        }
        return arrayList;
    }

    private DataInput createTaggedCFFDataInput(DataInput object) {
        int n = object.readShort();
        object.readShort();
        object.readShort();
        object.readShort();
        for (int i = 0; i < n; ++i) {
            String string = CFFParser.readTagName((DataInput)object);
            CFFParser.readLong((DataInput)object);
            long l = CFFParser.readLong((DataInput)object);
            long l2 = CFFParser.readLong((DataInput)object);
            if (!"CFF ".equals(string)) continue;
            object.setPosition((int)l);
            object = object.readBytes((int)l2);
            return new DataInputByteArray((byte[])object);
        }
        throw new IOException("CFF tag not found in this OpenType font.");
    }

    private static String readTagName(DataInput object) {
        object = object.readBytes(4);
        return new String((byte[])object, StandardCharsets.ISO_8859_1);
    }

    private static long readLong(DataInput dataInput) {
        return dataInput.readUnsignedShort() << 16 | dataInput.readUnsignedShort();
    }

    private static int readOffSize(DataInput dataInput) {
        int n = dataInput.readUnsignedByte();
        if (n <= 0 || n > 4) {
            throw new IOException("Illegal (< 1 or > 4) offSize value " + n + " in CFF font at position " + (dataInput.getPosition() - 1));
        }
        return n;
    }

    private static CFFParser$Header readHeader(DataInput dataInput) {
        int n = dataInput.readUnsignedByte();
        int n2 = dataInput.readUnsignedByte();
        int n3 = dataInput.readUnsignedByte();
        int n4 = CFFParser.readOffSize(dataInput);
        return new CFFParser$Header(n, n2, n3, n4, null);
    }

    private static int[] readIndexDataOffsets(DataInput dataInput) {
        int n = dataInput.readUnsignedShort();
        if (n == 0) {
            return new int[0];
        }
        int n2 = CFFParser.readOffSize(dataInput);
        int[] nArray = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            int n3 = dataInput.readOffset(n2);
            if (n3 > dataInput.length()) {
                throw new IOException("illegal offset value " + n3 + " in CFF font");
            }
            nArray[i] = n3;
        }
        return nArray;
    }

    private static byte[][] readIndexData(DataInput dataInput) {
        int[] nArray = CFFParser.readIndexDataOffsets(dataInput);
        if (nArray.length == 0) {
            return new byte[0][];
        }
        int n = nArray.length - 1;
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i + 1] - nArray[i];
            byArrayArray[i] = dataInput.readBytes(n2);
        }
        return byArrayArray;
    }

    private static String[] readStringIndexData(DataInput dataInput) {
        int[] nArray = CFFParser.readIndexDataOffsets(dataInput);
        if (nArray.length == 0) {
            return new String[0];
        }
        int n = nArray.length - 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i + 1] - nArray[i];
            if (n2 < 0) {
                throw new IOException("Negative index data length + " + n2 + " at " + i + ": offsets[" + (i + 1) + "]=" + nArray[i + 1] + ", offsets[" + i + "]=" + nArray[i]);
            }
            stringArray[i] = new String(dataInput.readBytes(n2), StandardCharsets.ISO_8859_1);
        }
        return stringArray;
    }

    private static CFFParser$DictData readDictData(DataInput dataInput) {
        CFFParser$DictData cFFParser$DictData = new CFFParser$DictData(null);
        while (dataInput.hasRemaining()) {
            cFFParser$DictData.add(CFFParser.readEntry(dataInput));
        }
        return cFFParser$DictData;
    }

    private static CFFParser$DictData readDictData(DataInput dataInput, int n, int n2) {
        CFFParser$DictData cFFParser$DictData = new CFFParser$DictData(null);
        if (n2 > 0) {
            dataInput.setPosition(n);
            n += n2;
            while (dataInput.getPosition() < n) {
                cFFParser$DictData.add(CFFParser.readEntry(dataInput));
            }
        }
        return cFFParser$DictData;
    }

    private static CFFParser$DictData$Entry readEntry(DataInput dataInput) {
        int n;
        CFFParser$DictData$Entry cFFParser$DictData$Entry;
        block3: {
            cFFParser$DictData$Entry = new CFFParser$DictData$Entry(null);
            while (true) {
                if ((n = dataInput.readUnsignedByte()) >= 0 && n <= 21) break block3;
                if (n == 28 || n == 29) {
                    cFFParser$DictData$Entry.addOperand(CFFParser.readIntegerNumber(dataInput, n));
                    continue;
                }
                if (n == 30) {
                    cFFParser$DictData$Entry.addOperand(CFFParser.readRealNumber(dataInput));
                    continue;
                }
                if (n < 32 || n > 254) break;
                cFFParser$DictData$Entry.addOperand(CFFParser.readIntegerNumber(dataInput, n));
            }
            throw new IOException("invalid DICT data b0 byte: " + n);
        }
        CFFParser$DictData$Entry.access$302(cFFParser$DictData$Entry, CFFParser.readOperator(dataInput, n));
        return cFFParser$DictData$Entry;
    }

    private static String readOperator(DataInput dataInput, int n) {
        if (n == 12) {
            int n2 = dataInput.readUnsignedByte();
            return CFFOperator.getOperator(n, n2);
        }
        return CFFOperator.getOperator(n);
    }

    private static Integer readIntegerNumber(DataInput dataInput, int n) {
        if (n == 28) {
            return dataInput.readShort();
        }
        if (n == 29) {
            return dataInput.readInt();
        }
        if (n >= 32 && n <= 246) {
            return n - 139;
        }
        if (n >= 247 && n <= 250) {
            int n2 = dataInput.readUnsignedByte();
            return (n - 247 << 8) + n2 + 108;
        }
        if (n >= 251 && n <= 254) {
            int n3 = dataInput.readUnsignedByte();
            return (-(n - 251) << 8) - n3 - 108;
        }
        throw new IllegalArgumentException();
    }

    private static Double readRealNumber(DataInput dataInput) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int[] nArray = new int[2];
        while (!bl) {
            int n = dataInput.readUnsignedByte();
            nArray[0] = n / 16;
            nArray[1] = n % 16;
            int[] nArray2 = nArray;
            block12: for (int i = 0; i < 2; ++i) {
                int n2 = nArray2[i];
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        stringBuilder.append(n2);
                        bl2 = false;
                        continue block12;
                    }
                    case 10: {
                        stringBuilder.append('.');
                        continue block12;
                    }
                    case 11: {
                        if (bl3) {
                            LOG.warn((Object)("duplicate 'E' ignored after " + stringBuilder));
                            continue block12;
                        }
                        stringBuilder.append('E');
                        bl2 = true;
                        bl3 = true;
                        continue block12;
                    }
                    case 12: {
                        if (bl3) {
                            LOG.warn((Object)("duplicate 'E-' ignored after " + stringBuilder));
                            continue block12;
                        }
                        stringBuilder.append("E-");
                        bl2 = true;
                        bl3 = true;
                        continue block12;
                    }
                    case 13: {
                        continue block12;
                    }
                    case 14: {
                        stringBuilder.append('-');
                        continue block12;
                    }
                    case 15: {
                        bl = true;
                        continue block12;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal nibble " + n2);
                    }
                }
            }
        }
        if (bl2) {
            stringBuilder.append('0');
        }
        if (stringBuilder.length() == 0) {
            return 0.0;
        }
        try {
            return Double.valueOf(stringBuilder.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException);
        }
    }

    private CFFFont parseFont(DataInput object, String list, byte[] object2) {
        Object object3;
        DataInputByteArray dataInputByteArray = new DataInputByteArray((byte[])object2);
        object2 = dataInputByteArray;
        CFFParser$DictData cFFParser$DictData = CFFParser.readDictData(dataInputByteArray);
        object2 = cFFParser$DictData;
        Object object4 = cFFParser$DictData.getEntry("SyntheticBase");
        if (object4 != null) {
            throw new IOException("Synthetic Fonts are not supported");
        }
        boolean bl = ((CFFParser$DictData)object2).getEntry("ROS") != null;
        if (bl) {
            object3 = new CFFCIDFont();
            CFFParser$DictData$Entry cFFParser$DictData$Entry = ((CFFParser$DictData)object2).getEntry("ROS");
            if (cFFParser$DictData$Entry == null || cFFParser$DictData$Entry.size() < 3) {
                throw new IOException("ROS entry must have 3 elements");
            }
            ((CFFCIDFont)object3).setRegistry(this.readString(cFFParser$DictData$Entry.getNumber(0).intValue()));
            ((CFFCIDFont)object3).setOrdering(this.readString(cFFParser$DictData$Entry.getNumber(1).intValue()));
            ((CFFCIDFont)object3).setSupplement(cFFParser$DictData$Entry.getNumber(2).intValue());
            object4 = object3;
        } else {
            object4 = new CFFType1Font();
        }
        this.debugFontName = list;
        ((CFFFont)object4).setName((String)((Object)list));
        ((CFFFont)object4).addValueToTopDict("version", this.getString((CFFParser$DictData)object2, "version"));
        ((CFFFont)object4).addValueToTopDict("Notice", this.getString((CFFParser$DictData)object2, "Notice"));
        ((CFFFont)object4).addValueToTopDict("Copyright", this.getString((CFFParser$DictData)object2, "Copyright"));
        ((CFFFont)object4).addValueToTopDict("FullName", this.getString((CFFParser$DictData)object2, "FullName"));
        ((CFFFont)object4).addValueToTopDict("FamilyName", this.getString((CFFParser$DictData)object2, "FamilyName"));
        ((CFFFont)object4).addValueToTopDict("Weight", this.getString((CFFParser$DictData)object2, "Weight"));
        ((CFFFont)object4).addValueToTopDict("isFixedPitch", ((CFFParser$DictData)object2).getBoolean("isFixedPitch", false));
        ((CFFFont)object4).addValueToTopDict("ItalicAngle", ((CFFParser$DictData)object2).getNumber("ItalicAngle", 0));
        ((CFFFont)object4).addValueToTopDict("UnderlinePosition", ((CFFParser$DictData)object2).getNumber("UnderlinePosition", -100));
        ((CFFFont)object4).addValueToTopDict("UnderlineThickness", ((CFFParser$DictData)object2).getNumber("UnderlineThickness", 50));
        ((CFFFont)object4).addValueToTopDict("PaintType", ((CFFParser$DictData)object2).getNumber("PaintType", 0));
        ((CFFFont)object4).addValueToTopDict("CharstringType", ((CFFParser$DictData)object2).getNumber("CharstringType", 2));
        ((CFFFont)object4).addValueToTopDict("FontMatrix", ((CFFParser$DictData)object2).getArray("FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
        ((CFFFont)object4).addValueToTopDict("UniqueID", ((CFFParser$DictData)object2).getNumber("UniqueID", null));
        ((CFFFont)object4).addValueToTopDict("FontBBox", ((CFFParser$DictData)object2).getArray("FontBBox", Arrays.asList(0, 0, 0, 0)));
        ((CFFFont)object4).addValueToTopDict("StrokeWidth", ((CFFParser$DictData)object2).getNumber("StrokeWidth", 0));
        ((CFFFont)object4).addValueToTopDict("XUID", ((CFFParser$DictData)object2).getArray("XUID", null));
        object3 = ((CFFParser$DictData)object2).getEntry("CharStrings");
        if (object3 == null || !((CFFParser$DictData$Entry)object3).hasOperands()) {
            throw new IOException("CharStrings is missing or empty");
        }
        int n = ((CFFParser$DictData$Entry)object3).getNumber(0).intValue();
        object.setPosition(n);
        list = (List<Object>)CFFParser.readIndexData((DataInput)object);
        object3 = ((CFFParser$DictData)object2).getEntry("charset");
        if (object3 != null && ((CFFParser$DictData$Entry)object3).hasOperands()) {
            int n2 = ((CFFParser$DictData$Entry)object3).getNumber(0).intValue();
            if (!bl && n2 == 0) {
                object3 = CFFISOAdobeCharset.getInstance();
            } else if (!bl && n2 == 1) {
                object3 = CFFExpertCharset.getInstance();
            } else if (!bl && n2 == 2) {
                object3 = CFFExpertSubsetCharset.getInstance();
            } else if (((Object)list).length > 0) {
                object.setPosition(n2);
                object3 = this.readCharset((DataInput)object, ((Object)list).length, bl);
            } else {
                LOG.debug((Object)"Couldn't read CharStrings index - returning empty charset instead");
                object3 = new CFFParser$EmptyCharsetType1(null);
            }
        } else {
            object3 = bl ? new CFFParser$EmptyCharsetCID(((Object)list).length, null) : CFFISOAdobeCharset.getInstance();
        }
        ((CFFFont)object4).setCharset((CFFCharset)object3);
        ((CFFFont)object4).charStrings = (byte[][])list;
        if (bl) {
            int n3 = 0;
            if (((Object)list).length == 0) {
                LOG.debug((Object)"Couldn't read CharStrings index - parsing CIDFontDicts with number of char strings set to 0");
            } else {
                n3 = ((Object)list).length;
            }
            this.parseCIDFontDicts((DataInput)object, (CFFParser$DictData)object2, (CFFCIDFont)object4, n3);
            object = null;
            list = ((CFFCIDFont)object4).getFontDicts();
            if (!list.isEmpty() && list.get(0).containsKey("FontMatrix")) {
                object = (List)((Map)list.get(0)).get("FontMatrix");
            }
            if ((list = ((CFFParser$DictData)object2).getArray("FontMatrix", null)) == null) {
                if (object != null) {
                    ((CFFFont)object4).addValueToTopDict("FontMatrix", object);
                } else {
                    ((CFFFont)object4).addValueToTopDict("FontMatrix", ((CFFParser$DictData)object2).getArray("FontMatrix", Arrays.asList(0.001, 0.0, 0.0, 0.001, 0.0, 0.0)));
                }
            } else if (object != null) {
                this.concatenateMatrix(list, (List<Number>)object);
            }
        } else {
            this.parseType1Dicts((DataInput)object, (CFFParser$DictData)object2, (CFFType1Font)object4, (CFFCharset)object3);
        }
        return object4;
    }

    private void concatenateMatrix(List<Number> list, List<Number> list2) {
        double d = list.get(0).doubleValue();
        double d2 = list.get(1).doubleValue();
        double d3 = list.get(2).doubleValue();
        double d4 = list.get(3).doubleValue();
        double d5 = list.get(4).doubleValue();
        double d6 = list.get(5).doubleValue();
        double d7 = list2.get(0).doubleValue();
        double d8 = list2.get(1).doubleValue();
        double d9 = list2.get(2).doubleValue();
        double d10 = list2.get(3).doubleValue();
        double d11 = list2.get(4).doubleValue();
        double d12 = list2.get(5).doubleValue();
        list.set(0, d * d7 + d2 * d9);
        list.set(1, d * d8 + d2 * d4);
        list.set(2, d3 * d7 + d4 * d9);
        list.set(3, d3 * d8 + d4 * d10);
        list.set(4, d5 * d7 + d6 * d9 + d11);
        list.set(5, d5 * d8 + d6 * d10 + d12);
    }

    private void parseCIDFontDicts(DataInput dataInput, CFFParser$DictData cFFParser$DictData, CFFCIDFont cFFCIDFont, int n) {
        CFFParser$DictData$Entry cFFParser$DictData$Entry = cFFParser$DictData.getEntry("FDArray");
        if (cFFParser$DictData$Entry == null || !cFFParser$DictData$Entry.hasOperands()) {
            throw new IOException("FDArray is missing for a CIDKeyed Font.");
        }
        int n2 = cFFParser$DictData$Entry.getNumber(0).intValue();
        dataInput.setPosition(n2);
        Object object = CFFParser.readIndexData(dataInput);
        if (((byte[][])object).length == 0) {
            throw new IOException("Font dict index is missing for a CIDKeyed Font");
        }
        LinkedList<Map<String, Object>> linkedList = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> linkedList2 = new LinkedList<Map<String, Object>>();
        for (Object object2 : object) {
            DataInputByteArray dataInputByteArray = new DataInputByteArray((byte[])object2);
            object2 = dataInputByteArray;
            CFFParser$DictData cFFParser$DictData2 = CFFParser.readDictData(dataInputByteArray);
            object2 = cFFParser$DictData2;
            Object object3 = cFFParser$DictData2.getEntry("Private");
            if (object3 == null || ((CFFParser$DictData$Entry)object3).size() < 2) {
                throw new IOException("Font DICT invalid without \"Private\" entry");
            }
            Map<Object, Object> map = new LinkedHashMap<String, Object>(4);
            map.put("FontName", this.getString((CFFParser$DictData)object2, "FontName"));
            map.put("FontType", ((CFFParser$DictData)object2).getNumber("FontType", 0));
            map.put("FontBBox", ((CFFParser$DictData)object2).getArray("FontBBox", null));
            map.put("FontMatrix", ((CFFParser$DictData)object2).getArray("FontMatrix", null));
            linkedList2.add(map);
            int n3 = ((CFFParser$DictData$Entry)object3).getNumber(1).intValue();
            int n4 = ((CFFParser$DictData$Entry)object3).getNumber(0).intValue();
            object3 = CFFParser.readDictData(dataInput, n3, n4);
            map = this.readPrivateDict((CFFParser$DictData)object3);
            linkedList.add(map);
            object3 = ((CFFParser$DictData)object3).getNumber("Subrs", 0);
            if (!(object3 instanceof Integer) || (Integer)object3 <= 0) continue;
            dataInput.setPosition(n3 + (Integer)object3);
            map.put("Subrs", CFFParser.readIndexData(dataInput));
        }
        CFFParser$DictData$Entry cFFParser$DictData$Entry2 = cFFParser$DictData.getEntry("FDSelect");
        object = cFFParser$DictData$Entry2;
        if (cFFParser$DictData$Entry2 == null || !((CFFParser$DictData$Entry)object).hasOperands()) {
            throw new IOException("FDSelect is missing or empty");
        }
        int n5 = ((CFFParser$DictData$Entry)object).getNumber(0).intValue();
        dataInput.setPosition(n5);
        FDSelect fDSelect = CFFParser.readFDSelect(dataInput, n);
        cFFCIDFont.setFontDict(linkedList2);
        cFFCIDFont.setPrivDict(linkedList);
        cFFCIDFont.setFdSelect(fDSelect);
    }

    private Map<String, Object> readPrivateDict(CFFParser$DictData cFFParser$DictData) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(17);
        linkedHashMap.put("BlueValues", cFFParser$DictData.getDelta("BlueValues", null));
        linkedHashMap.put("OtherBlues", cFFParser$DictData.getDelta("OtherBlues", null));
        linkedHashMap.put("FamilyBlues", cFFParser$DictData.getDelta("FamilyBlues", null));
        linkedHashMap.put("FamilyOtherBlues", cFFParser$DictData.getDelta("FamilyOtherBlues", null));
        linkedHashMap.put("BlueScale", cFFParser$DictData.getNumber("BlueScale", 0.039625));
        linkedHashMap.put("BlueShift", cFFParser$DictData.getNumber("BlueShift", 7));
        linkedHashMap.put("BlueFuzz", cFFParser$DictData.getNumber("BlueFuzz", 1));
        linkedHashMap.put("StdHW", cFFParser$DictData.getNumber("StdHW", null));
        linkedHashMap.put("StdVW", cFFParser$DictData.getNumber("StdVW", null));
        linkedHashMap.put("StemSnapH", cFFParser$DictData.getDelta("StemSnapH", null));
        linkedHashMap.put("StemSnapV", cFFParser$DictData.getDelta("StemSnapV", null));
        linkedHashMap.put("ForceBold", cFFParser$DictData.getBoolean("ForceBold", false));
        linkedHashMap.put("LanguageGroup", cFFParser$DictData.getNumber("LanguageGroup", 0));
        linkedHashMap.put("ExpansionFactor", cFFParser$DictData.getNumber("ExpansionFactor", 0.06));
        linkedHashMap.put("initialRandomSeed", cFFParser$DictData.getNumber("initialRandomSeed", 0));
        linkedHashMap.put("defaultWidthX", cFFParser$DictData.getNumber("defaultWidthX", 0));
        linkedHashMap.put("nominalWidthX", cFFParser$DictData.getNumber("nominalWidthX", 0));
        return linkedHashMap;
    }

    private void parseType1Dicts(DataInput dataInput, CFFParser$DictData object, CFFType1Font cFFType1Font, CFFCharset object2) {
        CFFParser$DictData$Entry cFFParser$DictData$Entry = ((CFFParser$DictData)object).getEntry("Encoding");
        int n = cFFParser$DictData$Entry != null && cFFParser$DictData$Entry.hasOperands() ? cFFParser$DictData$Entry.getNumber(0).intValue() : 0;
        switch (n) {
            case 0: {
                object2 = CFFStandardEncoding.getInstance();
                break;
            }
            case 1: {
                object2 = CFFExpertEncoding.getInstance();
                break;
            }
            default: {
                dataInput.setPosition(n);
                object2 = this.readEncoding(dataInput, (CFFCharset)object2);
            }
        }
        cFFType1Font.setEncoding((CFFEncoding)object2);
        object = ((CFFParser$DictData)object).getEntry("Private");
        if (object == null || ((CFFParser$DictData$Entry)object).size() < 2) {
            throw new IOException("Private dictionary entry missing for font " + cFFType1Font.getName());
        }
        int n2 = ((CFFParser$DictData$Entry)object).getNumber(1).intValue();
        int n3 = ((CFFParser$DictData$Entry)object).getNumber(0).intValue();
        Object object3 = CFFParser.readDictData(dataInput, n2, n3);
        Map<String, Object> map = this.readPrivateDict((CFFParser$DictData)object3);
        map.forEach(cFFType1Font::addToPrivateDict);
        object3 = ((CFFParser$DictData)object3).getNumber("Subrs", 0);
        if (object3 instanceof Integer && (Integer)object3 > 0) {
            dataInput.setPosition(n2 + (Integer)object3);
            cFFType1Font.addToPrivateDict("Subrs", CFFParser.readIndexData(dataInput));
        }
    }

    private String readString(int n) {
        if (n < 0) {
            throw new IOException("Invalid negative index when reading a string");
        }
        if (n <= 390) {
            return CFFStandardString.getName(n);
        }
        if (this.stringIndex != null && n - 391 < this.stringIndex.length) {
            return this.stringIndex[n - 391];
        }
        return "SID" + n;
    }

    private String getString(CFFParser$DictData object, String string) {
        if ((object = ((CFFParser$DictData)object).getEntry(string)) != null && ((CFFParser$DictData$Entry)object).hasOperands()) {
            return this.readString(((CFFParser$DictData$Entry)object).getNumber(0).intValue());
        }
        return null;
    }

    private CFFEncoding readEncoding(DataInput dataInput, CFFCharset cFFCharset) {
        int n = dataInput.readUnsignedByte();
        int n2 = n & 0x7F;
        switch (n2) {
            case 0: {
                return this.readFormat0Encoding(dataInput, cFFCharset, n);
            }
            case 1: {
                return this.readFormat1Encoding(dataInput, cFFCharset, n);
            }
        }
        throw new IOException("Invalid encoding base format " + n2);
    }

    private CFFParser$Format0Encoding readFormat0Encoding(DataInput dataInput, CFFCharset cFFCharset, int n) {
        CFFParser$Format0Encoding cFFParser$Format0Encoding = new CFFParser$Format0Encoding(dataInput.readUnsignedByte(), null);
        cFFParser$Format0Encoding.add(0, 0, ".notdef");
        for (int i = 1; i <= CFFParser$Format0Encoding.access$700(cFFParser$Format0Encoding); ++i) {
            int n2 = dataInput.readUnsignedByte();
            int n3 = cFFCharset.getSIDForGID(i);
            cFFParser$Format0Encoding.add(n2, n3, this.readString(n3));
        }
        if ((n & 0x80) != 0) {
            this.readSupplement(dataInput, cFFParser$Format0Encoding);
        }
        return cFFParser$Format0Encoding;
    }

    private CFFParser$Format1Encoding readFormat1Encoding(DataInput dataInput, CFFCharset cFFCharset, int n) {
        CFFParser$Format1Encoding cFFParser$Format1Encoding = new CFFParser$Format1Encoding(dataInput.readUnsignedByte(), null);
        cFFParser$Format1Encoding.add(0, 0, ".notdef");
        int n2 = 1;
        for (int i = 0; i < CFFParser$Format1Encoding.access$900(cFFParser$Format1Encoding); ++i) {
            int n3 = dataInput.readUnsignedByte();
            int n4 = dataInput.readUnsignedByte();
            for (int j = 0; j <= n4; ++j) {
                int n5 = cFFCharset.getSIDForGID(n2);
                cFFParser$Format1Encoding.add(n3 + j, n5, this.readString(n5));
                ++n2;
            }
        }
        if ((n & 0x80) != 0) {
            this.readSupplement(dataInput, cFFParser$Format1Encoding);
        }
        return cFFParser$Format1Encoding;
    }

    private void readSupplement(DataInput dataInput, CFFParser$CFFBuiltInEncoding cFFParser$CFFBuiltInEncoding) {
        int n = dataInput.readUnsignedByte();
        CFFParser$CFFBuiltInEncoding.access$1002(cFFParser$CFFBuiltInEncoding, new CFFParser$CFFBuiltInEncoding$Supplement[n]);
        for (int i = 0; i < n; ++i) {
            int n2 = dataInput.readUnsignedByte();
            int n3 = dataInput.readUnsignedShort();
            CFFParser$CFFBuiltInEncoding.access$1000((CFFParser$CFFBuiltInEncoding)cFFParser$CFFBuiltInEncoding)[i] = new CFFParser$CFFBuiltInEncoding$Supplement(n2, n3, this.readString(n3), null);
            CFFParser$CFFBuiltInEncoding cFFParser$CFFBuiltInEncoding2 = cFFParser$CFFBuiltInEncoding;
            cFFParser$CFFBuiltInEncoding2.add(CFFParser$CFFBuiltInEncoding.access$1000(cFFParser$CFFBuiltInEncoding2)[i]);
        }
    }

    private static FDSelect readFDSelect(DataInput dataInput, int n) {
        int n2 = dataInput.readUnsignedByte();
        switch (n2) {
            case 0: {
                return CFFParser.readFormat0FDSelect(dataInput, n);
            }
            case 3: {
                return CFFParser.readFormat3FDSelect(dataInput);
            }
        }
        throw new IllegalArgumentException();
    }

    private static CFFParser$Format0FDSelect readFormat0FDSelect(DataInput dataInput, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = dataInput.readUnsignedByte();
        }
        return new CFFParser$Format0FDSelect(nArray, null);
    }

    private static CFFParser$Format3FDSelect readFormat3FDSelect(DataInput dataInput) {
        int n = dataInput.readUnsignedShort();
        CFFParser$Range3[] cFFParser$Range3Array = new CFFParser$Range3[n];
        for (int i = 0; i < n; ++i) {
            cFFParser$Range3Array[i] = new CFFParser$Range3(dataInput.readUnsignedShort(), dataInput.readUnsignedByte(), null);
        }
        return new CFFParser$Format3FDSelect(cFFParser$Range3Array, dataInput.readUnsignedShort(), null);
    }

    private CFFCharset readCharset(DataInput dataInput, int n, boolean bl) {
        int n2 = dataInput.readUnsignedByte();
        switch (n2) {
            case 0: {
                return this.readFormat0Charset(dataInput, n, bl);
            }
            case 1: {
                return this.readFormat1Charset(dataInput, n, bl);
            }
            case 2: {
                return this.readFormat2Charset(dataInput, n, bl);
            }
        }
        throw new IOException("Incorrect charset format " + n2);
    }

    private CFFParser$Format0Charset readFormat0Charset(DataInput dataInput, int n, boolean n2) {
        CFFParser$Format0Charset cFFParser$Format0Charset = new CFFParser$Format0Charset(n2 != 0, null);
        if (n2 != 0) {
            cFFParser$Format0Charset.addCID(0, 0);
            for (n2 = 1; n2 < n; ++n2) {
                cFFParser$Format0Charset.addCID(n2, dataInput.readUnsignedShort());
            }
        } else {
            cFFParser$Format0Charset.addSID(0, 0, ".notdef");
            for (n2 = 1; n2 < n; ++n2) {
                int n3 = dataInput.readUnsignedShort();
                cFFParser$Format0Charset.addSID(n2, n3, this.readString(n3));
            }
        }
        return cFFParser$Format0Charset;
    }

    private CFFParser$Format1Charset readFormat1Charset(DataInput dataInput, int n, boolean n2) {
        CFFParser$Format1Charset cFFParser$Format1Charset = new CFFParser$Format1Charset(n2 != 0, null);
        if (n2 != 0) {
            int n3;
            cFFParser$Format1Charset.addCID(0, 0);
            for (n2 = 1; n2 < n; n2 += n3 + 1) {
                int n4 = dataInput.readUnsignedShort();
                n3 = dataInput.readUnsignedByte();
                cFFParser$Format1Charset.addRangeMapping(new CFFParser$RangeMapping(n2, n4, n3, null));
            }
        } else {
            int n5;
            cFFParser$Format1Charset.addSID(0, 0, ".notdef");
            for (n2 = 1; n2 < n; n2 += n5) {
                int n6 = dataInput.readUnsignedShort();
                n5 = dataInput.readUnsignedByte() + 1;
                for (int i = 0; i < n5; ++i) {
                    int n7 = n6 + i;
                    cFFParser$Format1Charset.addSID(n2 + i, n7, this.readString(n7));
                }
            }
        }
        return cFFParser$Format1Charset;
    }

    private CFFParser$Format2Charset readFormat2Charset(DataInput dataInput, int n, boolean n2) {
        CFFParser$Format2Charset cFFParser$Format2Charset = new CFFParser$Format2Charset(n2 != 0, null);
        if (n2 != 0) {
            int n3;
            cFFParser$Format2Charset.addCID(0, 0);
            for (n2 = 1; n2 < n; n2 += n3 + 1) {
                int n4 = dataInput.readUnsignedShort();
                n3 = dataInput.readUnsignedShort();
                cFFParser$Format2Charset.addRangeMapping(new CFFParser$RangeMapping(n2, n4, n3, null));
            }
        } else {
            int n5;
            cFFParser$Format2Charset.addSID(0, 0, ".notdef");
            for (n2 = 1; n2 < n; n2 += n5) {
                int n6 = dataInput.readUnsignedShort();
                n5 = dataInput.readUnsignedShort() + 1;
                for (int i = 0; i < n5; ++i) {
                    int n7 = n6 + i;
                    cFFParser$Format2Charset.addSID(n2 + i, n7, this.readString(n7));
                }
            }
        }
        return cFFParser$Format2Charset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.debugFontName + "]";
    }

    static /* synthetic */ Log access$2100() {
        return LOG;
    }
}

