/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import org.apache.fontbox.cmap.CMap;

class CIDRange {
    private final int from;
    private int to;
    private final int unicode;
    private final int codeLength;

    CIDRange(int n, int n2, int n3, int n4) {
        this.from = n;
        this.to = n2;
        this.unicode = n3;
        this.codeLength = n4;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public int map(byte[] byArray) {
        int n;
        if (byArray.length == this.codeLength && this.from <= (n = CMap.toInt(byArray)) && n <= this.to) {
            return this.unicode + (n - this.from);
        }
        return -1;
    }

    public int map(int n, int n2) {
        if (n2 == this.codeLength && this.from <= n && n <= this.to) {
            return this.unicode + (n - this.from);
        }
        return -1;
    }

    public int unmap(int n) {
        if (this.unicode <= n && n <= this.unicode + (this.to - this.from)) {
            return this.from + (n - this.unicode);
        }
        return -1;
    }

    public boolean extend(int n, int n2, int n3, int n4) {
        if (this.codeLength == n4 && n == this.to + 1 && n3 == this.unicode + this.to - this.from + 1) {
            this.to = n2;
            return true;
        }
        return false;
    }
}

