/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import org.apache.a.d.e;
import org.apache.a.d.f;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.RandomAccessReadDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class GlyphTable
extends TTFTable {
    public static final String TAG = "glyf";
    private GlyphData[] glyphs;
    private TTFDataStream data;
    private IndexToLocationTable loca;
    private int numGlyphs;
    private int cached = 0;
    private HorizontalMetricsTable hmt = null;
    private static final int MAX_CACHE_SIZE = 5000;
    private static final int MAX_CACHED_GLYPHS = 100;

    GlyphTable() {
    }

    @Override
    void read(TrueTypeFont trueTypeFont, TTFDataStream object) {
        this.loca = trueTypeFont.getIndexToLocation();
        this.numGlyphs = trueTypeFont.getNumberOfGlyphs();
        if (this.numGlyphs < 5000) {
            this.glyphs = new GlyphData[this.numGlyphs];
        }
        object = ((TTFDataStream)object).read((int)this.getLength());
        this.data = new RandomAccessReadDataStream((e)new f((byte[])object));
        this.hmt = trueTypeFont.getHorizontalMetrics();
        this.initialized = true;
    }

    public void setGlyphs(GlyphData[] glyphDataArray) {
        this.glyphs = glyphDataArray;
    }

    public GlyphData getGlyph(int n) {
        if (n < 0 || n >= this.numGlyphs) {
            return null;
        }
        if (this.glyphs != null && this.glyphs[n] != null) {
            return this.glyphs[n];
        }
        TTFDataStream tTFDataStream = this.data;
        synchronized (tTFDataStream) {
            Object object = this.loca.getOffsets();
            if (object[n] == object[n + 1]) {
                GlyphData glyphData = new GlyphData();
                object = glyphData;
                glyphData.initEmptyData();
            } else {
                long l = this.data.getCurrentPosition();
                this.data.seek(object[n]);
                object = this.getGlyphData(n);
                this.data.seek(l);
            }
            if (this.glyphs != null && this.glyphs[n] == null && this.cached < 100) {
                this.glyphs[n] = object;
                ++this.cached;
            }
            return object;
        }
    }

    private GlyphData getGlyphData(int n) {
        GlyphData glyphData = new GlyphData();
        n = this.hmt == null ? 0 : this.hmt.getLeftSideBearing(n);
        GlyphTable glyphTable = this;
        glyphData.initData(glyphTable, glyphTable.data, n);
        if (glyphData.getDescription().isComposite()) {
            glyphData.getDescription().resolve();
        }
        return glyphData;
    }
}

