/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.KerningSubtable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class KerningTable
extends TTFTable {
    private static final Log LOG = LogFactory.getLog(KerningTable.class);
    public static final String TAG = "kern";
    private KerningSubtable[] subtables;

    KerningTable() {
    }

    @Override
    void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) {
        int n = tTFDataStream.readUnsignedShort();
        if (n != 0) {
            n = n << 16 | tTFDataStream.readUnsignedShort();
        }
        int n2 = 0;
        if (n == 0) {
            n2 = tTFDataStream.readUnsignedShort();
        } else if (n == 1) {
            n2 = (int)tTFDataStream.readUnsignedInt();
        } else {
            LOG.debug((Object)("Skipped kerning table due to an unsupported kerning table version: " + n));
        }
        if (n2 > 0) {
            this.subtables = new KerningSubtable[n2];
            for (int i = 0; i < n2; ++i) {
                KerningSubtable kerningSubtable = new KerningSubtable();
                kerningSubtable.read(tTFDataStream, n);
                this.subtables[i] = kerningSubtable;
            }
        }
        this.initialized = true;
    }

    public KerningSubtable getHorizontalKerningSubtable() {
        return this.getHorizontalKerningSubtable(false);
    }

    public KerningSubtable getHorizontalKerningSubtable(boolean bl) {
        if (this.subtables != null) {
            KerningSubtable[] kerningSubtableArray = this.subtables;
            int n = this.subtables.length;
            for (int i = 0; i < n; ++i) {
                KerningSubtable kerningSubtable = kerningSubtableArray[i];
                if (!kerningSubtable.isHorizontalKerning(bl)) continue;
                return kerningSubtable;
            }
        }
        return null;
    }
}

