/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.EOFException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class OS2WindowsMetricsTable
extends TTFTable {
    private static final Log LOG = LogFactory.getLog(OS2WindowsMetricsTable.class);
    public static final int WEIGHT_CLASS_THIN = 100;
    public static final int WEIGHT_CLASS_ULTRA_LIGHT = 200;
    public static final int WEIGHT_CLASS_LIGHT = 300;
    public static final int WEIGHT_CLASS_NORMAL = 400;
    public static final int WEIGHT_CLASS_MEDIUM = 500;
    public static final int WEIGHT_CLASS_SEMI_BOLD = 600;
    public static final int WEIGHT_CLASS_BOLD = 700;
    public static final int WEIGHT_CLASS_EXTRA_BOLD = 800;
    public static final int WEIGHT_CLASS_BLACK = 900;
    public static final int WIDTH_CLASS_ULTRA_CONDENSED = 1;
    public static final int WIDTH_CLASS_EXTRA_CONDENSED = 2;
    public static final int WIDTH_CLASS_CONDENSED = 3;
    public static final int WIDTH_CLASS_SEMI_CONDENSED = 4;
    public static final int WIDTH_CLASS_MEDIUM = 5;
    public static final int WIDTH_CLASS_SEMI_EXPANDED = 6;
    public static final int WIDTH_CLASS_EXPANDED = 7;
    public static final int WIDTH_CLASS_EXTRA_EXPANDED = 8;
    public static final int WIDTH_CLASS_ULTRA_EXPANDED = 9;
    public static final int FAMILY_CLASS_NO_CLASSIFICATION = 0;
    public static final int FAMILY_CLASS_OLDSTYLE_SERIFS = 1;
    public static final int FAMILY_CLASS_TRANSITIONAL_SERIFS = 2;
    public static final int FAMILY_CLASS_MODERN_SERIFS = 3;
    public static final int FAMILY_CLASS_CLAREDON_SERIFS = 4;
    public static final int FAMILY_CLASS_SLAB_SERIFS = 5;
    public static final int FAMILY_CLASS_FREEFORM_SERIFS = 7;
    public static final int FAMILY_CLASS_SANS_SERIF = 8;
    public static final int FAMILY_CLASS_ORNAMENTALS = 9;
    public static final int FAMILY_CLASS_SCRIPTS = 10;
    public static final int FAMILY_CLASS_SYMBOLIC = 12;
    public static final short FSTYPE_RESTRICTED = 2;
    public static final short FSTYPE_PREVIEW_AND_PRINT = 4;
    public static final short FSTYPE_EDITIBLE = 8;
    public static final short FSTYPE_NO_SUBSETTING = 256;
    public static final short FSTYPE_BITMAP_ONLY = 512;
    private int version;
    private short averageCharWidth;
    private int weightClass;
    private int widthClass;
    private short fsType;
    private short subscriptXSize;
    private short subscriptYSize;
    private short subscriptXOffset;
    private short subscriptYOffset;
    private short superscriptXSize;
    private short superscriptYSize;
    private short superscriptXOffset;
    private short superscriptYOffset;
    private short strikeoutSize;
    private short strikeoutPosition;
    private int familyClass;
    private byte[] panose = new byte[10];
    private long unicodeRange1;
    private long unicodeRange2;
    private long unicodeRange3;
    private long unicodeRange4;
    private String achVendId = "XXXX";
    private int fsSelection;
    private int firstCharIndex;
    private int lastCharIndex;
    private int typoAscender;
    private int typoDescender;
    private int typoLineGap;
    private int winAscent;
    private int winDescent;
    private long codePageRange1 = 0L;
    private long codePageRange2 = 0L;
    private int sxHeight;
    private int sCapHeight;
    private int usDefaultChar;
    private int usBreakChar;
    private int usMaxContext;
    public static final String TAG = "OS/2";

    OS2WindowsMetricsTable() {
    }

    public String getAchVendId() {
        return this.achVendId;
    }

    public void setAchVendId(String string) {
        this.achVendId = string;
    }

    public short getAverageCharWidth() {
        return this.averageCharWidth;
    }

    public void setAverageCharWidth(short s) {
        this.averageCharWidth = s;
    }

    public long getCodePageRange1() {
        return this.codePageRange1;
    }

    public void setCodePageRange1(long l) {
        this.codePageRange1 = l;
    }

    public long getCodePageRange2() {
        return this.codePageRange2;
    }

    public void setCodePageRange2(long l) {
        this.codePageRange2 = l;
    }

    public int getFamilyClass() {
        return this.familyClass;
    }

    public void setFamilyClass(int n) {
        this.familyClass = n;
    }

    public int getFirstCharIndex() {
        return this.firstCharIndex;
    }

    public void setFirstCharIndex(int n) {
        this.firstCharIndex = n;
    }

    public int getFsSelection() {
        return this.fsSelection;
    }

    public void setFsSelection(int n) {
        this.fsSelection = n;
    }

    public short getFsType() {
        return this.fsType;
    }

    public void setFsType(short s) {
        this.fsType = s;
    }

    public int getLastCharIndex() {
        return this.lastCharIndex;
    }

    public void setLastCharIndex(int n) {
        this.lastCharIndex = n;
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public void setPanose(byte[] byArray) {
        this.panose = byArray;
    }

    public short getStrikeoutPosition() {
        return this.strikeoutPosition;
    }

    public void setStrikeoutPosition(short s) {
        this.strikeoutPosition = s;
    }

    public short getStrikeoutSize() {
        return this.strikeoutSize;
    }

    public void setStrikeoutSize(short s) {
        this.strikeoutSize = s;
    }

    public short getSubscriptXOffset() {
        return this.subscriptXOffset;
    }

    public void setSubscriptXOffset(short s) {
        this.subscriptXOffset = s;
    }

    public short getSubscriptXSize() {
        return this.subscriptXSize;
    }

    public void setSubscriptXSize(short s) {
        this.subscriptXSize = s;
    }

    public short getSubscriptYOffset() {
        return this.subscriptYOffset;
    }

    public void setSubscriptYOffset(short s) {
        this.subscriptYOffset = s;
    }

    public short getSubscriptYSize() {
        return this.subscriptYSize;
    }

    public void setSubscriptYSize(short s) {
        this.subscriptYSize = s;
    }

    public short getSuperscriptXOffset() {
        return this.superscriptXOffset;
    }

    public void setSuperscriptXOffset(short s) {
        this.superscriptXOffset = s;
    }

    public short getSuperscriptXSize() {
        return this.superscriptXSize;
    }

    public void setSuperscriptXSize(short s) {
        this.superscriptXSize = s;
    }

    public short getSuperscriptYOffset() {
        return this.superscriptYOffset;
    }

    public void setSuperscriptYOffset(short s) {
        this.superscriptYOffset = s;
    }

    public short getSuperscriptYSize() {
        return this.superscriptYSize;
    }

    public void setSuperscriptYSize(short s) {
        this.superscriptYSize = s;
    }

    public int getTypoLineGap() {
        return this.typoLineGap;
    }

    public void setTypoLineGap(int n) {
        this.typoLineGap = n;
    }

    public int getTypoAscender() {
        return this.typoAscender;
    }

    public void setTypoAscender(int n) {
        this.typoAscender = n;
    }

    public int getTypoDescender() {
        return this.typoDescender;
    }

    public void setTypoDescender(int n) {
        this.typoDescender = n;
    }

    public long getUnicodeRange1() {
        return this.unicodeRange1;
    }

    public void setUnicodeRange1(long l) {
        this.unicodeRange1 = l;
    }

    public long getUnicodeRange2() {
        return this.unicodeRange2;
    }

    public void setUnicodeRange2(long l) {
        this.unicodeRange2 = l;
    }

    public long getUnicodeRange3() {
        return this.unicodeRange3;
    }

    public void setUnicodeRange3(long l) {
        this.unicodeRange3 = l;
    }

    public long getUnicodeRange4() {
        return this.unicodeRange4;
    }

    public void setUnicodeRange4(long l) {
        this.unicodeRange4 = l;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getWeightClass() {
        return this.weightClass;
    }

    public void setWeightClass(int n) {
        this.weightClass = n;
    }

    public int getWidthClass() {
        return this.widthClass;
    }

    public void setWidthClass(int n) {
        this.widthClass = n;
    }

    public int getWinAscent() {
        return this.winAscent;
    }

    public void setWinAscent(int n) {
        this.winAscent = n;
    }

    public int getWinDescent() {
        return this.winDescent;
    }

    public void setWinDescent(int n) {
        this.winDescent = n;
    }

    public int getHeight() {
        return this.sxHeight;
    }

    public int getCapHeight() {
        return this.sCapHeight;
    }

    public int getDefaultChar() {
        return this.usDefaultChar;
    }

    public int getBreakChar() {
        return this.usBreakChar;
    }

    public int getMaxContext() {
        return this.usMaxContext;
    }

    @Override
    void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) {
        this.version = tTFDataStream.readUnsignedShort();
        this.averageCharWidth = tTFDataStream.readSignedShort();
        this.weightClass = tTFDataStream.readUnsignedShort();
        this.widthClass = tTFDataStream.readUnsignedShort();
        this.fsType = tTFDataStream.readSignedShort();
        this.subscriptXSize = tTFDataStream.readSignedShort();
        this.subscriptYSize = tTFDataStream.readSignedShort();
        this.subscriptXOffset = tTFDataStream.readSignedShort();
        this.subscriptYOffset = tTFDataStream.readSignedShort();
        this.superscriptXSize = tTFDataStream.readSignedShort();
        this.superscriptYSize = tTFDataStream.readSignedShort();
        this.superscriptXOffset = tTFDataStream.readSignedShort();
        this.superscriptYOffset = tTFDataStream.readSignedShort();
        this.strikeoutSize = tTFDataStream.readSignedShort();
        this.strikeoutPosition = tTFDataStream.readSignedShort();
        this.familyClass = tTFDataStream.readSignedShort();
        this.panose = tTFDataStream.read(10);
        this.unicodeRange1 = tTFDataStream.readUnsignedInt();
        this.unicodeRange2 = tTFDataStream.readUnsignedInt();
        this.unicodeRange3 = tTFDataStream.readUnsignedInt();
        this.unicodeRange4 = tTFDataStream.readUnsignedInt();
        this.achVendId = tTFDataStream.readString(4);
        this.fsSelection = tTFDataStream.readUnsignedShort();
        this.firstCharIndex = tTFDataStream.readUnsignedShort();
        this.lastCharIndex = tTFDataStream.readUnsignedShort();
        try {
            this.typoAscender = tTFDataStream.readSignedShort();
            this.typoDescender = tTFDataStream.readSignedShort();
            this.typoLineGap = tTFDataStream.readSignedShort();
            this.winAscent = tTFDataStream.readUnsignedShort();
            this.winDescent = tTFDataStream.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            LOG.debug((Object)"EOF, probably some legacy TrueType font");
            this.initialized = true;
            return;
        }
        if (this.version > 0) {
            try {
                this.codePageRange1 = tTFDataStream.readUnsignedInt();
                this.codePageRange2 = tTFDataStream.readUnsignedInt();
            }
            catch (EOFException eOFException) {
                this.version = 0;
                LOG.warn((Object)"Could not read all expected parts of version >= 1, setting version to 0", (Throwable)eOFException);
                this.initialized = true;
                return;
            }
        }
        if (this.version >= 2) {
            try {
                this.sxHeight = tTFDataStream.readSignedShort();
                this.sCapHeight = tTFDataStream.readSignedShort();
                this.usDefaultChar = tTFDataStream.readUnsignedShort();
                this.usBreakChar = tTFDataStream.readUnsignedShort();
                this.usMaxContext = tTFDataStream.readUnsignedShort();
            }
            catch (EOFException eOFException) {
                this.version = 1;
                LOG.warn((Object)"Could not read all expected parts of version >= 2, setting version to 1", (Throwable)eOFException);
                this.initialized = true;
                return;
            }
        }
        this.initialized = true;
    }
}

