/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.awt.geom.GeneralPath;
import org.apache.fontbox.ttf.CFFTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TrueTypeFont;

public class OpenTypeFont
extends TrueTypeFont {
    private boolean isPostScript;

    OpenTypeFont(TTFDataStream tTFDataStream) {
        super(tTFDataStream);
    }

    @Override
    void setVersion(float f2) {
        this.isPostScript = Float.floatToIntBits(f2) == 1184802985;
        super.setVersion(f2);
    }

    public CFFTable getCFF() {
        if (!this.isPostScript) {
            throw new UnsupportedOperationException("TTF fonts do not have a CFF table");
        }
        return (CFFTable)this.getTable("CFF ");
    }

    @Override
    public GlyphTable getGlyph() {
        if (this.isPostScript) {
            throw new UnsupportedOperationException("OTF fonts do not have a glyf table");
        }
        return super.getGlyph();
    }

    @Override
    public GeneralPath getPath(String string) {
        if (this.isPostScript && this.isSupportedOTF()) {
            int n = this.nameToGID(string);
            return this.getCFF().getFont().getType2CharString(n).getPath();
        }
        return super.getPath(string);
    }

    public boolean isPostScript() {
        return this.isPostScript || this.tables.containsKey("CFF ") || this.tables.containsKey("CFF2");
    }

    public boolean isSupportedOTF() {
        return !this.isPostScript || this.tables.containsKey("CFF ") || !this.tables.containsKey("CFF2");
    }

    public boolean hasLayoutTables() {
        return this.tables.containsKey("BASE") || this.tables.containsKey("GDEF") || this.tables.containsKey("GPOS") || this.tables.containsKey("GSUB") || this.tables.containsKey("JSTF");
    }
}

