/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OpenTypeScript {
    private static final Log LOG;
    public static final String INHERITED = "Inherited";
    public static final String UNKNOWN = "Unknown";
    public static final String TAG_DEFAULT = "DFLT";
    private static final Map<String, String[]> UNICODE_SCRIPT_TO_OPENTYPE_TAG_MAP;
    private static int[] unicodeRangeStarts;
    private static String[] unicodeRangeScripts;

    private OpenTypeScript() {
    }

    private static void parseScriptsFile(InputStream closeable) {
        Object object;
        TreeMap<int[], Object> treeMap = new TreeMap<int[], Object>((nArray, nArray2) -> Integer.compare(nArray[0], nArray2[0]));
        closeable = new LineNumberReader(new InputStreamReader((InputStream)closeable));
        Object object2 = null;
        try {
            Object object3;
            object = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
            Object object4 = null;
            while ((object3 = ((LineNumberReader)closeable).readLine()) != null) {
                int n = ((String)object3).indexOf(35);
                if (n != -1) {
                    object3 = ((String)object3).substring(0, n);
                }
                if (((String)object3).length() < 2 || (n = ((StringTokenizer)(object3 = new StringTokenizer((String)object3, ";"))).countTokens()) < 2) continue;
                String string = ((StringTokenizer)object3).nextToken().trim();
                object3 = ((StringTokenizer)object3).nextToken().trim();
                int[] nArray3 = new int[2];
                int n2 = string.indexOf("..");
                if (n2 == -1) {
                    nArray3[0] = nArray3[1] = Integer.parseInt(string, 16);
                } else {
                    nArray3[0] = Integer.parseInt(string.substring(0, n2), 16);
                    nArray3[1] = Integer.parseInt(string.substring(n2 + 2), 16);
                }
                if (nArray3[0] == object[1] + true && ((String)object3).equals(object4)) {
                    object[1] = nArray3[1];
                    continue;
                }
                treeMap.put(nArray3, object3);
                object = nArray3;
                object4 = object3;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            object2 = throwable;
            throw throwable2;
        }
        finally {
            if (object2 != null) {
                try {
                    ((BufferedReader)closeable).close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object2).addSuppressed(throwable);
                }
            } else {
                ((BufferedReader)closeable).close();
            }
        }
        unicodeRangeStarts = new int[treeMap.size()];
        unicodeRangeScripts = new String[treeMap.size()];
        int n = 0;
        object2 = treeMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            OpenTypeScript.unicodeRangeStarts[n] = ((int[])object.getKey())[0];
            OpenTypeScript.unicodeRangeScripts[n] = (String)object.getValue();
            ++n;
        }
    }

    private static String getUnicodeScript(int n) {
        OpenTypeScript.ensureValidCodePoint(n);
        int n2 = Character.getType(n);
        if (n2 == 0) {
            return UNKNOWN;
        }
        if ((n = Arrays.binarySearch(unicodeRangeStarts, n)) < 0) {
            n = -n - 2;
        }
        return unicodeRangeScripts[n];
    }

    public static String[] getScriptTags(int n) {
        OpenTypeScript.ensureValidCodePoint(n);
        String string = OpenTypeScript.getUnicodeScript(n);
        return UNICODE_SCRIPT_TO_OPENTYPE_TAG_MAP.get(string);
    }

    private static void ensureValidCodePoint(int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException("Invalid codepoint: " + n);
        }
    }

    static {
        Object object;
        LOG = LogFactory.getLog(OpenTypeScript.class);
        Object object2 = new Object[][]{{"Adlam", new String[]{"adlm"}}, {"Ahom", new String[]{"ahom"}}, {"Anatolian_Hieroglyphs", new String[]{"hluw"}}, {"Arabic", new String[]{"arab"}}, {"Armenian", new String[]{"armn"}}, {"Avestan", new String[]{"avst"}}, {"Balinese", new String[]{"bali"}}, {"Bamum", new String[]{"bamu"}}, {"Bassa_Vah", new String[]{"bass"}}, {"Batak", new String[]{"batk"}}, {"Bengali", new String[]{"bng2", "beng"}}, {"Bhaiksuki", new String[]{"bhks"}}, {"Bopomofo", new String[]{"bopo"}}, {"Brahmi", new String[]{"brah"}}, {"Braille", new String[]{"brai"}}, {"Buginese", new String[]{"bugi"}}, {"Buhid", new String[]{"buhd"}}, {"Canadian_Aboriginal", new String[]{"cans"}}, {"Carian", new String[]{"cari"}}, {"Caucasian_Albanian", new String[]{"aghb"}}, {"Chakma", new String[]{"cakm"}}, {"Cham", new String[]{"cham"}}, {"Cherokee", new String[]{"cher"}}, {"Common", new String[]{TAG_DEFAULT}}, {"Coptic", new String[]{"copt"}}, {"Cuneiform", new String[]{"xsux"}}, {"Cypriot", new String[]{"cprt"}}, {"Cyrillic", new String[]{"cyrl"}}, {"Deseret", new String[]{"dsrt"}}, {"Devanagari", new String[]{"dev2", "deva"}}, {"Duployan", new String[]{"dupl"}}, {"Egyptian_Hieroglyphs", new String[]{"egyp"}}, {"Elbasan", new String[]{"elba"}}, {"Ethiopic", new String[]{"ethi"}}, {"Georgian", new String[]{"geor"}}, {"Glagolitic", new String[]{"glag"}}, {"Gothic", new String[]{"goth"}}, {"Grantha", new String[]{"gran"}}, {"Greek", new String[]{"grek"}}, {"Gujarati", new String[]{"gjr2", "gujr"}}, {"Gurmukhi", new String[]{"gur2", "guru"}}, {"Han", new String[]{"hani"}}, {"Hangul", new String[]{"hang"}}, {"Hanunoo", new String[]{"hano"}}, {"Hatran", new String[]{"hatr"}}, {"Hebrew", new String[]{"hebr"}}, {"Hiragana", new String[]{"kana"}}, {"Imperial_Aramaic", new String[]{"armi"}}, {INHERITED, new String[]{INHERITED}}, {"Inscriptional_Pahlavi", new String[]{"phli"}}, {"Inscriptional_Parthian", new String[]{"prti"}}, {"Javanese", new String[]{"java"}}, {"Kaithi", new String[]{"kthi"}}, {"Kannada", new String[]{"knd2", "knda"}}, {"Katakana", new String[]{"kana"}}, {"Kayah_Li", new String[]{"kali"}}, {"Kharoshthi", new String[]{"khar"}}, {"Khmer", new String[]{"khmr"}}, {"Khojki", new String[]{"khoj"}}, {"Khudawadi", new String[]{"sind"}}, {"Lao", new String[]{"lao "}}, {"Latin", new String[]{"latn"}}, {"Lepcha", new String[]{"lepc"}}, {"Limbu", new String[]{"limb"}}, {"Linear_A", new String[]{"lina"}}, {"Linear_B", new String[]{"linb"}}, {"Lisu", new String[]{"lisu"}}, {"Lycian", new String[]{"lyci"}}, {"Lydian", new String[]{"lydi"}}, {"Mahajani", new String[]{"mahj"}}, {"Malayalam", new String[]{"mlm2", "mlym"}}, {"Mandaic", new String[]{"mand"}}, {"Manichaean", new String[]{"mani"}}, {"Marchen", new String[]{"marc"}}, {"Meetei_Mayek", new String[]{"mtei"}}, {"Mende_Kikakui", new String[]{"mend"}}, {"Meroitic_Cursive", new String[]{"merc"}}, {"Meroitic_Hieroglyphs", new String[]{"mero"}}, {"Miao", new String[]{"plrd"}}, {"Modi", new String[]{"modi"}}, {"Mongolian", new String[]{"mong"}}, {"Mro", new String[]{"mroo"}}, {"Multani", new String[]{"mult"}}, {"Myanmar", new String[]{"mym2", "mymr"}}, {"Nabataean", new String[]{"nbat"}}, {"Newa", new String[]{"newa"}}, {"New_Tai_Lue", new String[]{"talu"}}, {"Nko", new String[]{"nko "}}, {"Ogham", new String[]{"ogam"}}, {"Ol_Chiki", new String[]{"olck"}}, {"Old_Italic", new String[]{"ital"}}, {"Old_Hungarian", new String[]{"hung"}}, {"Old_North_Arabian", new String[]{"narb"}}, {"Old_Permic", new String[]{"perm"}}, {"Old_Persian", new String[]{"xpeo"}}, {"Old_South_Arabian", new String[]{"sarb"}}, {"Old_Turkic", new String[]{"orkh"}}, {"Oriya", new String[]{"ory2", "orya"}}, {"Osage", new String[]{"osge"}}, {"Osmanya", new String[]{"osma"}}, {"Pahawh_Hmong", new String[]{"hmng"}}, {"Palmyrene", new String[]{"palm"}}, {"Pau_Cin_Hau", new String[]{"pauc"}}, {"Phags_Pa", new String[]{"phag"}}, {"Phoenician", new String[]{"phnx"}}, {"Psalter_Pahlavi", new String[]{"phlp"}}, {"Rejang", new String[]{"rjng"}}, {"Runic", new String[]{"runr"}}, {"Samaritan", new String[]{"samr"}}, {"Saurashtra", new String[]{"saur"}}, {"Sharada", new String[]{"shrd"}}, {"Shavian", new String[]{"shaw"}}, {"Siddham", new String[]{"sidd"}}, {"SignWriting", new String[]{"sgnw"}}, {"Sinhala", new String[]{"sinh"}}, {"Sora_Sompeng", new String[]{"sora"}}, {"Sundanese", new String[]{"sund"}}, {"Syloti_Nagri", new String[]{"sylo"}}, {"Syriac", new String[]{"syrc"}}, {"Tagalog", new String[]{"tglg"}}, {"Tagbanwa", new String[]{"tagb"}}, {"Tai_Le", new String[]{"tale"}}, {"Tai_Tham", new String[]{"lana"}}, {"Tai_Viet", new String[]{"tavt"}}, {"Takri", new String[]{"takr"}}, {"Tamil", new String[]{"tml2", "taml"}}, {"Tangut", new String[]{"tang"}}, {"Telugu", new String[]{"tel2", "telu"}}, {"Thaana", new String[]{"thaa"}}, {"Thai", new String[]{"thai"}}, {"Tibetan", new String[]{"tibt"}}, {"Tifinagh", new String[]{"tfng"}}, {"Tirhuta", new String[]{"tirh"}}, {"Ugaritic", new String[]{"ugar"}}, {UNKNOWN, new String[]{TAG_DEFAULT}}, {"Vai", new String[]{"vai "}}, {"Warang_Citi", new String[]{"wara"}}, {"Yi", new String[]{"yi  "}}};
        UNICODE_SCRIPT_TO_OPENTYPE_TAG_MAP = new HashMap<String, String[]>(138);
        for (int i = 0; i < 138; ++i) {
            object = object2[i];
            UNICODE_SCRIPT_TO_OPENTYPE_TAG_MAP.put((String)object[0], (String[])object[1]);
        }
        object2 = "/org/apache/fontbox/unicode/Scripts.txt";
        try {
            object2 = OpenTypeScript.class.getResourceAsStream((String)object2);
            Throwable throwable = null;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object2);
                object = null;
                try {
                    OpenTypeScript.parseScriptsFile(bufferedInputStream);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    object = throwable2;
                    throw throwable3;
                }
                finally {
                    if (object != null) {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)object).addSuppressed(throwable4);
                        }
                    } else {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throwable = throwable5;
                throw throwable6;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            LOG.warn((Object)("Could not parse Scripts.txt, mirroring char map will be empty: " + iOException.getMessage()), (Throwable)iOException);
        }
    }
}

